/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.ByteArrayEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Server;

public class LocalConnector
extends AbstractConnector {
    ByteArrayEndPoint _endp;
    ByteArrayBuffer _in;
    ByteArrayBuffer _out;
    Server _server;
    boolean _accepting;
    boolean _keepOpen;

    public LocalConnector() {
        this.setPort(1);
    }

    @Override
    public Object getConnection() {
        return this._endp;
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        this._server = server;
    }

    public void clear() {
        this._in.clear();
        this._out.clear();
    }

    public void reopen() {
        this._in.clear();
        this._out.clear();
        this._endp = new ByteArrayEndPoint();
        this._endp.setIn(this._in);
        this._endp.setOut(this._out);
        this._endp.setGrowOutput(true);
        this._accepting = false;
    }

    @Override
    public void doStart() throws Exception {
        this._in = new ByteArrayBuffer(8192);
        this._out = new ByteArrayBuffer(8192);
        this._endp = new ByteArrayEndPoint();
        this._endp.setIn(this._in);
        this._endp.setOut(this._out);
        this._endp.setGrowOutput(true);
        this._accepting = false;
        super.doStart();
    }

    public String getResponses(String string) throws Exception {
        return this.getResponses(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponses(String string, boolean bl) throws Exception {
        Object object;
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(string);
        if (this._in.space() < byteArrayBuffer.length()) {
            object = new ByteArrayBuffer(this._in.length() + byteArrayBuffer.length());
            ((AbstractBuffer)object).put(this._in);
            this._in = object;
            this._endp.setIn(this._in);
        }
        this._in.put(byteArrayBuffer);
        object = this;
        synchronized (object) {
            this._keepOpen = bl;
            this._accepting = true;
            this.notify();
            while (this._accepting) {
                this.wait();
            }
        }
        this._out = this._endp.getOut();
        return this._out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayBuffer getResponses(ByteArrayBuffer byteArrayBuffer, boolean bl) throws Exception {
        Object object;
        if (this._in.space() < byteArrayBuffer.length()) {
            object = new ByteArrayBuffer(this._in.length() + byteArrayBuffer.length());
            ((AbstractBuffer)object).put(this._in);
            this._in = object;
            this._endp.setIn(this._in);
        }
        this._in.put(byteArrayBuffer);
        object = this;
        synchronized (object) {
            this._keepOpen = bl;
            this._accepting = true;
            this.notify();
            while (this._accepting) {
                this.wait();
            }
        }
        this._out = this._endp.getOut();
        return this._out;
    }

    @Override
    protected Buffer newBuffer(int n) {
        return new ByteArrayBuffer(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(int n) throws IOException, InterruptedException {
        HttpConnection httpConnection = null;
        while (this.isRunning()) {
            LocalConnector localConnector = this;
            synchronized (localConnector) {
                try {
                    while (!this._accepting) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            try {
                if (httpConnection == null) {
                    httpConnection = new HttpConnection(this, this._endp, this.getServer());
                    this.connectionOpened(httpConnection);
                }
                while (this._in.length() > 0) {
                    httpConnection.handle();
                }
            }
            finally {
                if (!this._keepOpen) {
                    this.connectionClosed(httpConnection);
                    httpConnection.destroy();
                    httpConnection = null;
                }
                localConnector = this;
                synchronized (localConnector) {
                    this._accepting = false;
                    this.notify();
                }
            }
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getLocalPort() {
        return -1;
    }
}

