/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;

public class Main {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 3) {
            System.err.println("Usage - java org.mortbay.jetty.Main [<addr>:]<port>");
            System.err.println("Usage - java org.mortbay.jetty.Main [<addr>:]<port> docroot");
            System.err.println("Usage - java org.mortbay.jetty.Main [<addr>:]<port> -webapp myapp.war");
            System.err.println("Usage - java org.mortbay.jetty.Main [<addr>:]<port> -webapps webapps");
            System.err.println("Usage - java -jar jetty-x.x.x-standalone.jar [<addr>:]<port>");
            System.err.println("Usage - java -jar jetty-x.x.x-standalone.jar [<addr>:]<port> docroot");
            System.err.println("Usage - java -jar jetty-x.x.x-standalone.jar [<addr>:]<port> -webapp myapp.war");
            System.err.println("Usage - java -jar jetty-x.x.x-standalone.jar [<addr>:]<port> -webapps webapps");
            System.exit(1);
        }
        try {
            Server server = new Server();
            ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
            server.setHandler(contextHandlerCollection);
            SocketConnector socketConnector = new SocketConnector();
            String string = stringArray[0];
            int n = string.lastIndexOf(58);
            if (n < 0) {
                socketConnector.setPort(Integer.parseInt(string));
            } else {
                socketConnector.setHost(string.substring(0, n));
                socketConnector.setPort(Integer.parseInt(string.substring(n + 1)));
            }
            server.setConnectors(new Connector[]{socketConnector});
            if (stringArray.length < 3) {
                ContextHandler contextHandler = new ContextHandler();
                contextHandler.setContextPath("/");
                contextHandler.setResourceBase(stringArray.length == 1 ? "." : stringArray[1]);
                ServletHandler servletHandler = new ServletHandler();
                servletHandler.addServletWithMapping("org.mortbay.jetty.servlet.DefaultServlet", "/");
                contextHandler.setHandler(servletHandler);
                contextHandlerCollection.addHandler(contextHandler);
            } else if ("-webapps".equals(stringArray[1])) {
                WebAppContext.addWebApplications(server, stringArray[2], "org/mortbay/jetty/webapp/webdefault.xml", true, true);
            } else if ("-webapp".equals(stringArray[1])) {
                WebAppContext webAppContext = new WebAppContext();
                webAppContext.setWar(stringArray[2]);
                webAppContext.setContextPath("/");
                contextHandlerCollection.addHandler(webAppContext);
            }
            server.start();
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
        }
    }
}

