/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.DateCache;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.Utf8StringBuffer;

public class NCSARequestLog
extends AbstractLifeCycle
implements RequestLog {
    private String _filename;
    private boolean _extended = true;
    private boolean _append = true;
    private int _retainDays = 31;
    private boolean _closeOut;
    private boolean _preferProxiedForAddress;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    private String _filenameDateFormat = null;
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = "GMT";
    private String[] _ignorePaths;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private boolean _logServer = false;
    private transient OutputStream _out;
    private transient OutputStream _fileOut;
    private transient DateCache _logDateCache;
    private transient PathMap _ignorePathMap;
    private transient Writer _writer;
    private transient ArrayList _buffers;
    private transient char[] _copy;

    public NCSARequestLog() {
    }

    public NCSARequestLog(String string) {
        this.setFilename(string);
    }

    public void setFilename(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this._filename = string;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._fileOut instanceof RolloverFileOutputStream) {
            return ((RolloverFileOutputStream)this._fileOut).getDatedFilename();
        }
        return null;
    }

    public void setLogDateFormat(String string) {
        this._logDateFormat = string;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogLocale(Locale locale) {
        this._logLocale = locale;
    }

    public Locale getLogLocale() {
        return this._logLocale;
    }

    public void setLogTimeZone(String string) {
        this._logTimeZone = string;
    }

    public String getLogTimeZone() {
        return this._logTimeZone;
    }

    public void setRetainDays(int n) {
        this._retainDays = n;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setExtended(boolean bl) {
        this._extended = bl;
    }

    public boolean isExtended() {
        return this._extended;
    }

    public void setAppend(boolean bl) {
        this._append = bl;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setIgnorePaths(String[] stringArray) {
        this._ignorePaths = stringArray;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setLogCookies(boolean bl) {
        this._logCookies = bl;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public boolean getLogServer() {
        return this._logServer;
    }

    public void setLogServer(boolean bl) {
        this._logServer = bl;
    }

    public void setLogLatency(boolean bl) {
        this._logLatency = bl;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    public void setPreferProxiedForAddress(boolean bl) {
        this._preferProxiedForAddress = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Request request, Response response) {
        block41: {
            if (!this.isStarted()) {
                return;
            }
            try {
                int n;
                Cookie[] cookieArray;
                StringBuffer stringBuffer;
                Utf8StringBuffer utf8StringBuffer;
                if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getRequestURI()) != null) {
                    return;
                }
                if (this._fileOut == null) {
                    return;
                }
                Appendable appendable = this._writer;
                synchronized (appendable) {
                    int n2 = this._buffers.size();
                    utf8StringBuffer = n2 == 0 ? new Utf8StringBuffer(160) : (Utf8StringBuffer)this._buffers.remove(n2 - 1);
                    stringBuffer = utf8StringBuffer.getStringBuffer();
                }
                appendable = stringBuffer;
                synchronized (appendable) {
                    if (this._logServer) {
                        stringBuffer.append(request.getServerName());
                        stringBuffer.append(' ');
                    }
                    String string = null;
                    if (this._preferProxiedForAddress) {
                        string = request.getHeader("X-Forwarded-For");
                    }
                    if (string == null) {
                        string = request.getRemoteAddr();
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(" - ");
                    cookieArray = request.getRemoteUser();
                    stringBuffer.append((String)(cookieArray == null ? " - " : cookieArray));
                    stringBuffer.append(" [");
                    if (this._logDateCache != null) {
                        stringBuffer.append(this._logDateCache.format(request.getTimeStamp()));
                    } else {
                        stringBuffer.append(request.getTimeStampBuffer().toString());
                    }
                    stringBuffer.append("] \"");
                    stringBuffer.append(request.getMethod());
                    stringBuffer.append(' ');
                    request.getUri().writeTo(utf8StringBuffer);
                    stringBuffer.append(' ');
                    stringBuffer.append(request.getProtocol());
                    stringBuffer.append("\" ");
                    n = response.getStatus();
                    if (n <= 0) {
                        n = 404;
                    }
                    stringBuffer.append((char)(48 + n / 100 % 10));
                    stringBuffer.append((char)(48 + n / 10 % 10));
                    stringBuffer.append((char)(48 + n % 10));
                    long l = response.getContentCount();
                    if (l >= 0L) {
                        stringBuffer.append(' ');
                        if (l > 99999L) {
                            stringBuffer.append(Long.toString(l));
                        } else {
                            if (l > 9999L) {
                                stringBuffer.append((char)(48L + l / 10000L % 10L));
                            }
                            if (l > 999L) {
                                stringBuffer.append((char)(48L + l / 1000L % 10L));
                            }
                            if (l > 99L) {
                                stringBuffer.append((char)(48L + l / 100L % 10L));
                            }
                            if (l > 9L) {
                                stringBuffer.append((char)(48L + l / 10L % 10L));
                            }
                            stringBuffer.append((char)(48L + l % 10L));
                        }
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(" - ");
                    }
                }
                if (!(this._extended || this._logCookies || this._logLatency)) {
                    appendable = this._writer;
                    synchronized (appendable) {
                        stringBuffer.append(StringUtil.__LINE_SEPARATOR);
                        int n3 = stringBuffer.length();
                        if (n3 > this._copy.length) {
                            n3 = this._copy.length;
                        }
                        stringBuffer.getChars(0, n3, this._copy, 0);
                        this._writer.write(this._copy, 0, n3);
                        this._writer.flush();
                        utf8StringBuffer.reset();
                        this._buffers.add(utf8StringBuffer);
                        break block41;
                    }
                }
                appendable = this._writer;
                synchronized (appendable) {
                    int n4 = stringBuffer.length();
                    if (n4 > this._copy.length) {
                        n4 = this._copy.length;
                    }
                    stringBuffer.getChars(0, n4, this._copy, 0);
                    this._writer.write(this._copy, 0, n4);
                    utf8StringBuffer.reset();
                    this._buffers.add(utf8StringBuffer);
                    if (this._extended) {
                        this.logExtended(request, response, this._writer);
                    }
                    if (this._logCookies) {
                        cookieArray = request.getCookies();
                        if (cookieArray == null || cookieArray.length == 0) {
                            this._writer.write(" -");
                        } else {
                            this._writer.write(" \"");
                            for (n = 0; n < cookieArray.length; ++n) {
                                if (n != 0) {
                                    this._writer.write(59);
                                }
                                this._writer.write(cookieArray[n].getName());
                                this._writer.write(61);
                                this._writer.write(cookieArray[n].getValue());
                            }
                            this._writer.write(34);
                        }
                    }
                    if (this._logLatency) {
                        this._writer.write(32);
                        this._writer.write(TypeUtil.toString(System.currentTimeMillis() - request.getTimeStamp()));
                    }
                    this._writer.write(StringUtil.__LINE_SEPARATOR);
                    this._writer.flush();
                }
            }
            catch (IOException iOException) {
                Log.warn(iOException);
            }
        }
    }

    protected void logExtended(Request request, Response response, Writer writer) throws IOException {
        String string = request.getHeader("Referer");
        if (string == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(string);
            writer.write("\" ");
        }
        String string2 = request.getHeader("User-Agent");
        if (string2 == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(string2);
            writer.write(34);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this._logDateFormat != null) {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
            this._logDateCache.setTimeZoneID(this._logTimeZone);
        }
        if (this._filename != null) {
            this._fileOut = new RolloverFileOutputStream(this._filename, this._append, this._retainDays, TimeZone.getTimeZone(this._logTimeZone), this._filenameDateFormat, null);
            this._closeOut = true;
            Log.info("Opened " + this.getDatedFilename());
        } else {
            this._fileOut = System.err;
        }
        this._out = this._fileOut;
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMap();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        this._writer = new OutputStreamWriter(this._out);
        this._buffers = new ArrayList();
        this._copy = new char[1024];
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
        }
        if (this._out != null && this._closeOut) {
            try {
                this._out.close();
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
            }
        }
        this._out = null;
        this._fileOut = null;
        this._closeOut = false;
        this._logDateCache = null;
        this._writer = null;
        this._buffers = null;
        this._copy = null;
    }

    public String getFilenameDateFormat() {
        return this._filenameDateFormat;
    }

    public void setFilenameDateFormat(String string) {
        this._filenameDateFormat = string;
    }
}

