/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.DirectNIOBuffer;
import org.mortbay.io.nio.IndirectNIOBuffer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;
import org.mortbay.util.UrlEncoded;
import org.mortbay.util.ajax.Continuation;

public class Request
implements HttpServletRequest {
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int __NONE = 0;
    private static final int _STREAM = 1;
    private static final int __READER = 2;
    private boolean _handled = false;
    private HttpConnection _connection;
    private EndPoint _endp;
    private Map _roleMap;
    private Attributes _attributes;
    private String _authType;
    private String _characterEncoding;
    private String _queryEncoding;
    private String _serverName;
    private String _remoteAddr;
    private String _remoteHost;
    private String _method;
    private String _pathInfo;
    private int _port;
    private String _protocol = "HTTP/1.1";
    private String _queryString;
    private String _requestedSessionId;
    private boolean _requestedSessionIdFromCookie = false;
    private String _requestURI;
    private String _scheme = "http";
    private String _contextPath;
    private String _servletPath;
    private String _servletName;
    private HttpURI _uri;
    private Principal _userPrincipal;
    private MultiMap _parameters;
    private MultiMap _baseParameters;
    private boolean _paramsExtracted;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _readerEncoding;
    private boolean _dns = false;
    private ContextHandler.SContext _context;
    private HttpSession _session;
    private SessionManager _sessionManager;
    private boolean _cookiesExtracted = false;
    private Cookie[] _cookies;
    private String[] _unparsedCookies;
    private long _timeStamp;
    private Buffer _timeStampBuffer;
    private Continuation _continuation;
    private Object _requestAttributeListeners;
    private Object _requestListeners;
    private Map _savedNewSessions;
    private UserRealm _userRealm;

    public Request() {
    }

    public Request(HttpConnection httpConnection) {
        this._connection = httpConnection;
        this._endp = httpConnection.getEndPoint();
        this._dns = this._connection.getResolveNames();
    }

    protected void setConnection(HttpConnection httpConnection) {
        this._connection = httpConnection;
        this._endp = httpConnection.getEndPoint();
        this._dns = httpConnection.getResolveNames();
    }

    protected void recycle() {
        if (this._inputState == 2) {
            try {
                int n = this._reader.read();
                while (n != -1) {
                    n = this._reader.read();
                }
            }
            catch (Exception exception) {
                Log.ignore(exception);
                this._reader = null;
            }
        }
        this._handled = false;
        if (this._context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this._attributes != null) {
            this._attributes.clearAttributes();
        }
        this._authType = null;
        this._characterEncoding = null;
        this._queryEncoding = null;
        this._context = null;
        this._serverName = null;
        this._method = null;
        this._pathInfo = null;
        this._port = 0;
        this._protocol = "HTTP/1.1";
        this._queryString = null;
        this._requestedSessionId = null;
        this._requestedSessionIdFromCookie = false;
        this._session = null;
        this._requestURI = null;
        this._scheme = "http";
        this._servletPath = null;
        this._timeStamp = 0L;
        this._timeStampBuffer = null;
        this._uri = null;
        this._userPrincipal = null;
        if (this._baseParameters != null) {
            this._baseParameters.clear();
        }
        this._parameters = null;
        this._paramsExtracted = false;
        this._inputState = 0;
        this._cookiesExtracted = false;
        if (this._savedNewSessions != null) {
            this._savedNewSessions.clear();
        }
        this._savedNewSessions = null;
        if (this._continuation != null && this._continuation.isPending()) {
            this._continuation.reset();
        }
    }

    public Buffer getTimeStampBuffer() {
        if (this._timeStampBuffer == null && this._timeStamp > 0L) {
            this._timeStampBuffer = HttpFields.__dateCache.formatBuffer(this._timeStamp);
        }
        return this._timeStampBuffer;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public void setTimeStamp(long l) {
        this._timeStamp = l;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public void setHandled(boolean bl) {
        this._handled = bl;
    }

    public Object getAttribute(String string) {
        if ("org.mortbay.jetty.ajax.Continuation".equals(string)) {
            return this.getContinuation(true);
        }
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public String getAuthType() {
        return this._authType;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public long getContentRead() {
        if (this._connection == null || this._connection.getParser() == null) {
            return -1L;
        }
        return ((HttpParser)this._connection.getParser()).getContentRead();
    }

    public int getContentLength() {
        return (int)this._connection.getRequestFields().getLongField(HttpHeaders.CONTENT_LENGTH_BUFFER);
    }

    public String getContentType() {
        return this._connection.getRequestFields().getStringField(HttpHeaders.CONTENT_TYPE_BUFFER);
    }

    public void setContentType(String string) {
        this._connection.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, string);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Cookie[] getCookies() {
        Object object;
        if (this._cookiesExtracted) {
            return this._cookies;
        }
        if (!this._connection.getRequestFields().containsKey(HttpHeaders.COOKIE_BUFFER)) {
            this._cookies = null;
            this._cookiesExtracted = true;
            this._unparsedCookies = null;
            return this._cookies;
        }
        if (this._unparsedCookies != null) {
            int n = 0;
            object = this._connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (n >= this._unparsedCookies.length || !string.equals(this._unparsedCookies[n])) {
                    this._unparsedCookies = null;
                    break;
                }
                ++n;
            }
            if (this._unparsedCookies != null && this._unparsedCookies.length == n) {
                this._cookiesExtracted = true;
                return this._cookies;
            }
        }
        this._cookies = null;
        Object object2 = null;
        object = null;
        int n = 0;
        Enumeration enumeration = this._connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                object = LazyList.add(object, string);
                String string2 = null;
                String string3 = null;
                Cookie cookie = null;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n2 = -1;
                int n3 = -1;
                int n4 = string.length();
                int n5 = n4 - 1;
                block21: for (int i = 0; i < n4; ++i) {
                    block59: {
                        char c;
                        block58: {
                            c = string.charAt(i);
                            if (!bl2) break block58;
                            if (bl3) {
                                bl3 = false;
                                continue;
                            }
                            switch (c) {
                                case '\"': {
                                    n3 = i;
                                    bl2 = false;
                                    if (i == n5) {
                                        if (bl) {
                                            string3 = string.substring(n2, n3 + 1);
                                        } else {
                                            string2 = string.substring(n2, n3 + 1);
                                            string3 = "";
                                        }
                                    }
                                    break block59;
                                }
                                case '\\': {
                                    bl3 = true;
                                    break;
                                }
                            }
                            continue;
                        }
                        if (bl) {
                            switch (c) {
                                case '\t': 
                                case ' ': {
                                    continue block21;
                                }
                                case '\"': {
                                    if (n2 < 0) {
                                        bl2 = true;
                                        n2 = i;
                                    }
                                    n3 = i;
                                    if (i != n5) continue block21;
                                    string3 = string.substring(n2, n3 + 1);
                                    break;
                                }
                                case ',': 
                                case ';': {
                                    string3 = n2 >= 0 ? string.substring(n2, n3 + 1) : "";
                                    n2 = -1;
                                    bl = false;
                                    break;
                                }
                                default: {
                                    if (n2 < 0) {
                                        n2 = i;
                                    }
                                    n3 = i;
                                    if (i != n5) continue block21;
                                    string3 = string.substring(n2, n3 + 1);
                                    break;
                                }
                            }
                        } else {
                            switch (c) {
                                case '\t': 
                                case ' ': {
                                    continue block21;
                                }
                                case '\"': {
                                    if (n2 < 0) {
                                        bl2 = true;
                                        n2 = i;
                                    }
                                    n3 = i;
                                    if (i != n5) continue block21;
                                    string2 = string.substring(n2, n3 + 1);
                                    string3 = "";
                                    break;
                                }
                                case ',': 
                                case ';': {
                                    if (n2 >= 0) {
                                        string2 = string.substring(n2, n3 + 1);
                                        string3 = "";
                                    }
                                    n2 = -1;
                                    break;
                                }
                                case '=': {
                                    if (n2 >= 0) {
                                        string2 = string.substring(n2, n3 + 1);
                                    }
                                    n2 = -1;
                                    bl = true;
                                    continue block21;
                                }
                                default: {
                                    if (n2 < 0) {
                                        n2 = i;
                                    }
                                    n3 = i;
                                    if (i != n5) continue block21;
                                    string2 = string.substring(n2, n3 + 1);
                                    string3 = "";
                                }
                            }
                        }
                    }
                    if (string3 == null || string2 == null) continue;
                    string2 = QuotedStringTokenizer.unquote(string2);
                    string3 = QuotedStringTokenizer.unquote(string3);
                    try {
                        if (string2.startsWith("$")) {
                            String string4 = string2.toLowerCase();
                            if ("$path".equals(string4)) {
                                if (cookie != null) {
                                    cookie.setPath(string3);
                                }
                            } else if ("$domain".equals(string4)) {
                                if (cookie != null) {
                                    cookie.setDomain(string3);
                                }
                            } else if ("$port".equals(string4)) {
                                if (cookie != null) {
                                    cookie.setComment("port=" + string3);
                                }
                            } else if ("$version".equals(string4)) {
                                n = Integer.parseInt(string3);
                            }
                        } else {
                            cookie = new Cookie(string2, string3);
                            if (n > 0) {
                                cookie.setVersion(n);
                            }
                            object2 = LazyList.add(object2, cookie);
                        }
                    }
                    catch (Exception exception) {
                        Log.warn(exception.toString());
                        Log.debug(exception);
                    }
                    string2 = null;
                    string3 = null;
                }
            }
            catch (Exception exception) {
                Log.warn(exception);
            }
        }
        int n6 = LazyList.size(object2);
        this._cookiesExtracted = true;
        if (n6 > 0) {
            int n7;
            if (this._cookies == null || this._cookies.length != n6) {
                this._cookies = new Cookie[n6];
            }
            for (n7 = 0; n7 < n6; ++n7) {
                this._cookies[n7] = (Cookie)LazyList.get(object2, n7);
            }
            n6 = LazyList.size(object);
            this._unparsedCookies = new String[n6];
            for (n7 = 0; n7 < n6; ++n7) {
                this._unparsedCookies[n7] = (String)LazyList.get(object, n7);
            }
        } else {
            this._cookies = null;
            this._unparsedCookies = null;
        }
        if (this._cookies == null || this._cookies.length == 0) {
            return null;
        }
        return this._cookies;
    }

    public long getDateHeader(String string) {
        return this._connection.getRequestFields().getDateField(string);
    }

    public String getHeader(String string) {
        return this._connection.getRequestFields().getStringField(string);
    }

    public Enumeration getHeaderNames() {
        return this._connection.getRequestFields().getFieldNames();
    }

    public Enumeration getHeaders(String string) {
        Enumeration enumeration = this._connection.getRequestFields().getValues(string);
        if (enumeration == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return enumeration;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        return this._connection.getInputStream();
    }

    public int getIntHeader(String string) {
        return (int)this._connection.getRequestFields().getLongField(string);
    }

    public String getLocalAddr() {
        return this._endp == null ? null : this._endp.getLocalAddr();
    }

    public Locale getLocale() {
        Enumeration enumeration = this._connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Locale.getDefault();
        }
        List list = HttpFields.qualityList(enumeration);
        if (list.size() == 0) {
            return Locale.getDefault();
        }
        int n = 0;
        int n2 = list.size();
        if (n < n2) {
            String string = (String)list.get(n);
            string = HttpFields.valueParameters(string, null);
            String string2 = "";
            int n3 = string.indexOf(45);
            if (n3 > -1) {
                string2 = string.substring(n3 + 1).trim();
                string = string.substring(0, n3).trim();
            }
            return new Locale(string, string2);
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Enumeration enumeration = this._connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List list = HttpFields.qualityList(enumeration);
        if (list.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        Object object = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            string = HttpFields.valueParameters(string, null);
            String string2 = "";
            int n2 = string.indexOf(45);
            if (n2 > -1) {
                string2 = string.substring(n2 + 1).trim();
                string = string.substring(0, n2).trim();
            }
            object = LazyList.ensureSize(object, n);
            object = LazyList.add(object, new Locale(string, string2));
        }
        if (LazyList.size(object) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(object));
    }

    public String getLocalName() {
        if (this._dns) {
            return this._endp == null ? null : this._endp.getLocalHost();
        }
        return this._endp == null ? null : this._endp.getLocalAddr();
    }

    public int getLocalPort() {
        return this._endp == null ? 0 : this._endp.getLocalPort();
    }

    public String getMethod() {
        return this._method;
    }

    public String getParameter(String string) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(string, 0);
    }

    public Map getParameterMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.unmodifiableMap(this._parameters.toStringArrayMap());
    }

    public Enumeration getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.enumeration(this._parameters.keySet());
    }

    public String[] getParameterValues(String string) {
        List list;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if ((list = this._parameters.getValues(string)) == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(this._pathInfo);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String string = this.getCharacterEncoding();
        if (string == null) {
            string = StringUtil.__ISO_8859_1;
        }
        if (this._reader == null || !string.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream servletInputStream = this.getInputStream();
            this._readerEncoding = string;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)servletInputStream, string)){

                @Override
                public void close() throws IOException {
                    servletInputStream.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRealPath(String string) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(string);
    }

    public String getRemoteAddr() {
        if (this._remoteAddr != null) {
            return this._remoteAddr;
        }
        return this._endp == null ? null : this._endp.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this._dns) {
            if (this._remoteHost != null) {
                return this._remoteHost;
            }
            return this._endp == null ? null : this._endp.getRemoteHost();
        }
        return this.getRemoteAddr();
    }

    public int getRemotePort() {
        return this._endp == null ? 0 : this._endp.getRemotePort();
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null || this._context == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            String string2 = URIUtil.addPaths(this._servletPath, this._pathInfo);
            int n = string2.lastIndexOf("/");
            string2 = n > 1 ? string2.substring(0, n + 1) : "/";
            string = URIUtil.addPaths(string2, string);
        }
        return this._context.getRequestDispatcher(string);
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    public String getRequestURI() {
        if (this._requestURI == null && this._uri != null) {
            this._requestURI = this._uri.getPathAndParam();
        }
        return this._requestURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(48);
        synchronized (stringBuffer2) {
            String string = this.getScheme();
            int n = this.getServerPort();
            stringBuffer.append(string);
            stringBuffer.append("://");
            stringBuffer.append(this.getServerName());
            if (this._port > 0 && (string.equalsIgnoreCase("http") && n != 80 || string.equalsIgnoreCase("https") && n != 443)) {
                stringBuffer.append(':');
                stringBuffer.append(this._port);
            }
            stringBuffer.append(this.getRequestURI());
            return stringBuffer;
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getServerName() {
        if (this._serverName != null) {
            return this._serverName;
        }
        this._serverName = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._serverName != null) {
            return this._serverName;
        }
        Buffer buffer = this._connection.getRequestFields().get(HttpHeaders.HOST_BUFFER);
        if (buffer != null) {
            int n = buffer.length();
            while (n-- > 0) {
                if (buffer.peek(buffer.getIndex() + n) != 58) continue;
                this._serverName = BufferUtil.to8859_1_String(buffer.peek(buffer.getIndex(), n));
                this._port = BufferUtil.toInt(buffer.peek(buffer.getIndex() + n + 1, buffer.length() - n - 1));
                return this._serverName;
            }
            if (this._serverName == null || this._port < 0) {
                this._serverName = BufferUtil.to8859_1_String(buffer);
                this._port = 0;
            }
            return this._serverName;
        }
        if (this._connection != null) {
            this._serverName = this.getLocalName();
            this._port = this.getLocalPort();
            if (this._serverName != null && !"0.0.0.0".equals(this._serverName)) {
                return this._serverName;
            }
        }
        try {
            this._serverName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Log.ignore(unknownHostException);
        }
        return this._serverName;
    }

    public int getServerPort() {
        if (this._port <= 0) {
            if (this._serverName == null) {
                this.getServerName();
            }
            if (this._port <= 0) {
                if (this._serverName != null && this._uri != null) {
                    this._port = this._uri.getPort();
                } else {
                    int n = this._port = this._endp == null ? 0 : this._endp.getLocalPort();
                }
            }
        }
        if (this._port <= 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this._port;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public String getServletName() {
        return this._servletName;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (this._sessionManager == null && bl) {
            throw new IllegalStateException("No SessionHandler or SessionManager");
        }
        if (this._session != null && this._sessionManager != null && this._sessionManager.isValid(this._session)) {
            return this._session;
        }
        this._session = null;
        String string = this.getRequestedSessionId();
        if (string != null && this._sessionManager != null) {
            this._session = this._sessionManager.getHttpSession(string);
            if (this._session == null && !bl) {
                return null;
            }
        }
        if (this._session == null && this._sessionManager != null && bl) {
            this._session = this._sessionManager.newHttpSession(this);
            Cookie cookie = this._sessionManager.getSessionCookie(this._session, this.getContextPath(), this.isSecure());
            if (cookie != null) {
                this._connection.getResponse().addCookie(cookie);
            }
        }
        return this._session;
    }

    public Principal getUserPrincipal() {
        if (this._userPrincipal != null && this._userPrincipal instanceof SecurityHandler.NotChecked) {
            String string;
            SecurityHandler.NotChecked notChecked = (SecurityHandler.NotChecked)this._userPrincipal;
            this._userPrincipal = SecurityHandler.__NO_USER;
            Authenticator authenticator = notChecked.getSecurityHandler().getAuthenticator();
            UserRealm userRealm = notChecked.getSecurityHandler().getUserRealm();
            String string2 = string = this.getPathInfo() == null ? this.getServletPath() : this.getServletPath() + this.getPathInfo();
            if (userRealm != null && authenticator != null) {
                try {
                    authenticator.authenticate(userRealm, string, this, null);
                }
                catch (Exception exception) {
                    Log.ignore(exception);
                }
            }
        }
        if (this._userPrincipal == SecurityHandler.__NO_USER) {
            return null;
        }
        return this._userPrincipal;
    }

    public String getQueryString() {
        if (this._queryString == null && this._uri != null) {
            this._queryString = this._queryEncoding == null ? this._uri.getQuery() : this._uri.getQuery(this._queryEncoding);
        }
        return this._queryString;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        if (this._requestedSessionId == null) {
            return false;
        }
        HttpSession httpSession = this.getSession(false);
        return httpSession == null ? false : this._sessionManager.getIdManager().getClusterId(this._requestedSessionId).equals(this._sessionManager.getClusterId(httpSession));
    }

    public boolean isSecure() {
        return this._connection.isConfidential(this);
    }

    public boolean isUserInRole(String object) {
        Object object2;
        if (this._roleMap != null && (object2 = (String)this._roleMap.get(object)) != null) {
            object = object2;
        }
        object2 = this.getUserPrincipal();
        if (this._userRealm != null && object2 != null) {
            return this._userRealm.isUserInRole((Principal)object2, (String)object);
        }
        return false;
    }

    public void removeAttribute(String string) {
        Object object;
        Object object2 = object = this._attributes == null ? null : this._attributes.getAttribute(string);
        if (this._attributes != null) {
            this._attributes.removeAttribute(string);
        }
        if (object != null && this._requestAttributeListeners != null) {
            ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, string, object);
            int n = LazyList.size(this._requestAttributeListeners);
            for (int i = 0; i < n; ++i) {
                ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)LazyList.get(this._requestAttributeListeners, i);
                if (!(servletRequestAttributeListener instanceof ServletRequestAttributeListener)) continue;
                ServletRequestAttributeListener servletRequestAttributeListener2 = servletRequestAttributeListener;
                servletRequestAttributeListener2.attributeRemoved(servletRequestAttributeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        ByteBuffer byteBuffer;
        Object object2;
        Object object3 = object2 = this._attributes == null ? null : this._attributes.getAttribute(string);
        if ("org.mortbay.jetty.Request.queryEncoding".equals(string)) {
            this.setQueryEncoding(object == null ? null : object.toString());
        } else if ("org.mortbay.jetty.ResponseBuffer".equals(string)) {
            try {
                ByteBuffer byteBuffer2 = byteBuffer = (ByteBuffer)object;
                synchronized (byteBuffer2) {
                    AbstractBuffer abstractBuffer = byteBuffer.isDirect() ? new DirectNIOBuffer(byteBuffer, true) : new IndirectNIOBuffer(byteBuffer, true);
                    ((HttpConnection.Output)this.getServletResponse().getOutputStream()).sendResponse(abstractBuffer);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(string, object);
        if (this._requestAttributeListeners != null) {
            byteBuffer = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, string, object2 == null ? object : object2);
            int n = LazyList.size(this._requestAttributeListeners);
            for (int i = 0; i < n; ++i) {
                ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)LazyList.get(this._requestAttributeListeners, i);
                if (!(servletRequestAttributeListener instanceof ServletRequestAttributeListener)) continue;
                ServletRequestAttributeListener servletRequestAttributeListener2 = servletRequestAttributeListener;
                if (object2 == null) {
                    servletRequestAttributeListener2.attributeAdded((ServletRequestAttributeEvent)byteBuffer);
                    continue;
                }
                if (object == null) {
                    servletRequestAttributeListener2.attributeRemoved((ServletRequestAttributeEvent)byteBuffer);
                    continue;
                }
                servletRequestAttributeListener2.attributeReplaced((ServletRequestAttributeEvent)byteBuffer);
            }
        }
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = string;
        if (!StringUtil.isUTF8(string)) {
            "".getBytes(string);
        }
    }

    public void setCharacterEncodingUnchecked(String string) {
        this._characterEncoding = string;
    }

    private void extractParameters() {
        Object object;
        int n;
        if (this._baseParameters == null) {
            this._baseParameters = new MultiMap(16);
        }
        if (this._paramsExtracted) {
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            }
            return;
        }
        this._paramsExtracted = true;
        if (this._uri != null && this._uri.hasQuery()) {
            if (this._queryEncoding == null) {
                this._uri.decodeQueryTo(this._baseParameters);
            } else {
                try {
                    this._uri.decodeQueryTo(this._baseParameters, this._queryEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (Log.isDebugEnabled()) {
                        Log.warn(unsupportedEncodingException);
                    }
                    Log.warn(unsupportedEncodingException.toString());
                }
            }
        }
        String string = this.getCharacterEncoding();
        String string2 = this.getContentType();
        if (string2 != null && string2.length() > 0 && "application/x-www-form-urlencoded".equalsIgnoreCase(string2 = HttpFields.valueParameters(string2, null)) && ("POST".equals(this.getMethod()) || "PUT".equals(this.getMethod())) && (n = this.getContentLength()) != 0) {
            try {
                int n2 = -1;
                if (this._context != null) {
                    n2 = this._context.getContextHandler().getMaxFormContentSize();
                } else {
                    object = (Integer)this._connection.getConnector().getServer().getAttribute("org.mortbay.jetty.Request.maxFormContentSize");
                    if (object != null) {
                        n2 = (Integer)object;
                    }
                }
                if (n > n2 && n2 > 0) {
                    throw new IllegalStateException("Form too large" + n + ">" + n2);
                }
                object = this.getInputStream();
                UrlEncoded.decodeTo((InputStream)object, this._baseParameters, string, n < 0 ? n2 : -1);
            }
            catch (IOException iOException) {
                if (Log.isDebugEnabled()) {
                    Log.warn(iOException);
                }
                Log.warn(iOException.toString());
            }
        }
        if (this._parameters == null) {
            this._parameters = this._baseParameters;
        } else if (this._parameters != this._baseParameters) {
            for (Map.Entry entry : this._baseParameters.entrySet()) {
                object = (String)entry.getKey();
                Object v = entry.getValue();
                for (int i = 0; i < LazyList.size(v); ++i) {
                    this._parameters.add(object, LazyList.get(v, i));
                }
            }
        }
    }

    public void setServerName(String string) {
        this._serverName = string;
    }

    public void setServerPort(int n) {
        this._port = n;
    }

    public void setRemoteAddr(String string) {
        this._remoteAddr = string;
    }

    public void setRemoteHost(String string) {
        this._remoteHost = string;
    }

    public HttpURI getUri() {
        return this._uri;
    }

    public void setUri(HttpURI httpURI) {
        this._uri = httpURI;
    }

    public HttpConnection getConnection() {
        return this._connection;
    }

    public int getInputState() {
        return this._inputState;
    }

    public void setAuthType(String string) {
        this._authType = string;
    }

    public void setCookies(Cookie[] cookieArray) {
        this._cookies = cookieArray;
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public void setRequestedSessionId(String string) {
        this._requestedSessionId = string;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public void setRequestedSessionIdFromCookie(boolean bl) {
        this._requestedSessionIdFromCookie = bl;
    }

    public void setSession(HttpSession httpSession) {
        this._session = httpSession;
    }

    public void setScheme(String string) {
        this._scheme = string;
    }

    public void setQueryString(String string) {
        this._queryString = string;
    }

    public void setRequestURI(String string) {
        this._requestURI = string;
    }

    public void setContextPath(String string) {
        this._contextPath = string;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public void setServletName(String string) {
        this._servletName = string;
    }

    public void setUserPrincipal(Principal principal) {
        this._userPrincipal = principal;
    }

    public void setContext(ContextHandler.SContext sContext) {
        this._context = sContext;
    }

    public ContextHandler.SContext getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRootURL() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(48);
        synchronized (stringBuffer2) {
            String string = this.getScheme();
            int n = this.getServerPort();
            stringBuffer.append(string);
            stringBuffer.append("://");
            stringBuffer.append(this.getServerName());
            if (n > 0 && (string.equalsIgnoreCase("http") && n != 80 || string.equalsIgnoreCase("https") && n != 443)) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
            return stringBuffer;
        }
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        return this._attributes;
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public Continuation getContinuation() {
        return this._continuation;
    }

    public Continuation getContinuation(boolean bl) {
        if (this._continuation == null && bl) {
            this._continuation = this.getConnection().getConnector().newContinuation();
        }
        return this._continuation;
    }

    void setContinuation(Continuation continuation) {
        this._continuation = continuation;
    }

    public MultiMap getParameters() {
        return this._parameters;
    }

    public void setParameters(MultiMap multiMap) {
        MultiMap multiMap2 = this._parameters = multiMap == null ? this._baseParameters : multiMap;
        if (this._paramsExtracted && this._parameters == null) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return this.getMethod() + " " + this._uri + " " + this.getProtocol() + "\n" + this._connection.getRequestFields().toString();
    }

    public static Request getRequest(HttpServletRequest httpServletRequest) {
        if (httpServletRequest instanceof Request) {
            return (Request)httpServletRequest;
        }
        while (httpServletRequest instanceof ServletRequestWrapper) {
            httpServletRequest = (HttpServletRequest)((ServletRequestWrapper)httpServletRequest).getRequest();
        }
        if (httpServletRequest instanceof Request) {
            return (Request)httpServletRequest;
        }
        return HttpConnection.getCurrentConnection().getRequest();
    }

    public void addEventListener(EventListener eventListener) {
        if (eventListener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, eventListener);
        }
    }

    public void removeEventListener(EventListener eventListener) {
        this._requestAttributeListeners = LazyList.remove(this._requestAttributeListeners, eventListener);
    }

    public void setRequestListeners(Object object) {
        this._requestListeners = object;
    }

    public Object takeRequestListeners() {
        Object object = this._requestListeners;
        this._requestListeners = null;
        return object;
    }

    public void saveNewSession(Object object, HttpSession httpSession) {
        if (this._savedNewSessions == null) {
            this._savedNewSessions = new HashMap();
        }
        this._savedNewSessions.put(object, httpSession);
    }

    public HttpSession recoverNewSession(Object object) {
        if (this._savedNewSessions == null) {
            return null;
        }
        return (HttpSession)this._savedNewSessions.get(object);
    }

    public UserRealm getUserRealm() {
        return this._userRealm;
    }

    public void setUserRealm(UserRealm userRealm) {
        this._userRealm = userRealm;
    }

    public String getQueryEncoding() {
        return this._queryEncoding;
    }

    public void setQueryEncoding(String string) {
        this._queryEncoding = string;
        this._queryString = null;
    }

    public void setRoleMap(Map map) {
        this._roleMap = map;
    }

    public Map getRoleMap() {
        return this._roleMap;
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public ServletResponse getServletResponse() {
        return this._connection.getResponse();
    }
}

