/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;

public class ResourceCache
extends AbstractLifeCycle
implements Serializable {
    private int _maxCachedFileSize = 0x100000;
    private int _maxCachedFiles = 2048;
    private int _maxCacheSize = 0x1000000;
    private MimeTypes _mimeTypes;
    protected transient Map _cache;
    protected transient int _cachedSize;
    protected transient int _cachedFiles;
    protected transient Content _mostRecentlyUsed;
    protected transient Content _leastRecentlyUsed;

    public ResourceCache(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public int getCachedSize() {
        return this._cachedSize;
    }

    public int getCachedFiles() {
        return this._cachedFiles;
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int n) {
        this._maxCachedFileSize = n;
        this.flushCache();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int n) {
        this._maxCacheSize = n;
        this.flushCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int n) {
        this._maxCachedFiles = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        if (this._cache != null) {
            ResourceCache resourceCache = this;
            synchronized (resourceCache) {
                ArrayList arrayList = new ArrayList(this._cache.values());
                for (Content content : arrayList) {
                    content.invalidate();
                }
                this._cache.clear();
                this._cachedSize = 0;
                this._cachedFiles = 0;
                this._mostRecentlyUsed = null;
                this._leastRecentlyUsed = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content lookup(String string, ResourceFactory resourceFactory) throws IOException {
        Content content = null;
        Object object = this._cache;
        synchronized (object) {
            content = (Content)this._cache.get(string);
            if (content != null && content.isValid()) {
                return content;
            }
        }
        object = resourceFactory.getResource(string);
        return this.load(string, (Resource)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content lookup(String string, Resource resource) throws IOException {
        Content content = null;
        Map map = this._cache;
        synchronized (map) {
            content = (Content)this._cache.get(string);
            if (content != null && content.isValid()) {
                return content;
            }
        }
        return this.load(string, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content load(String string, Resource resource) throws IOException {
        long l;
        Content content = null;
        if (resource != null && resource.exists() && !resource.isDirectory() && (l = resource.length()) > 0L && l < (long)this._maxCachedFileSize && l < (long)this._maxCacheSize) {
            content = new Content(resource);
            this.fill(content);
            Map map = this._cache;
            synchronized (map) {
                Content content2 = (Content)this._cache.get(string);
                if (content2 != null) {
                    content.release();
                    return content2;
                }
                int n = this._maxCacheSize - (int)l;
                while (this._cachedSize > n || this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles) {
                    this._leastRecentlyUsed.invalidate();
                }
                content.cache(string);
                return content;
            }
        }
        return null;
    }

    @Override
    public synchronized void doStart() throws Exception {
        this._cache = new HashMap();
        this._cachedSize = 0;
        this._cachedFiles = 0;
    }

    @Override
    public void doStop() throws InterruptedException {
        this.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fill(Content content) throws IOException {
        try {
            InputStream inputStream = content.getResource().getInputStream();
            int n = (int)content.getResource().length();
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n);
            byteArrayBuffer.readFrom(inputStream, n);
            inputStream.close();
            content.setBuffer(byteArrayBuffer);
        }
        finally {
            content.getResource().release();
        }
    }

    public class Content
    implements HttpContent {
        String _key;
        Resource _resource;
        long _lastModified;
        Content _prev;
        Content _next;
        Buffer _lastModifiedBytes;
        Buffer _contentType;
        Buffer _buffer;

        Content(Resource resource) {
            this._resource = resource;
            this._next = this;
            this._prev = this;
            this._contentType = ResourceCache.this._mimeTypes.getMimeByExtension(this._resource.toString());
            this._lastModified = resource.lastModified();
        }

        void cache(String string) {
            this._key = string;
            this._next = ResourceCache.this._mostRecentlyUsed;
            ResourceCache.this._mostRecentlyUsed = this;
            if (this._next != null) {
                this._next._prev = this;
            }
            this._prev = null;
            if (ResourceCache.this._leastRecentlyUsed == null) {
                ResourceCache.this._leastRecentlyUsed = this;
            }
            ResourceCache.this._cache.put(this._key, this);
            ResourceCache.this._cachedSize += this._buffer.length();
            ++ResourceCache.this._cachedFiles;
            if (this._lastModified != -1L) {
                this._lastModifiedBytes = new ByteArrayBuffer(HttpFields.formatDate(this._lastModified, false));
            }
        }

        public String getKey() {
            return this._key;
        }

        public boolean isCached() {
            return this._key != null;
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        boolean isValid() {
            if (this._lastModified == this._resource.lastModified()) {
                if (ResourceCache.this._mostRecentlyUsed != this) {
                    Content content = this._prev;
                    Content content2 = this._next;
                    this._next = ResourceCache.this._mostRecentlyUsed;
                    ResourceCache.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (content != null) {
                        content._next = content2;
                    }
                    if (content2 != null) {
                        content2._prev = content;
                    }
                    if (ResourceCache.this._leastRecentlyUsed == this && content != null) {
                        ResourceCache.this._leastRecentlyUsed = content;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            Content content = this;
            synchronized (content) {
                ResourceCache.this._cache.remove(this._key);
                this._key = null;
                ResourceCache.this._cachedSize -= this._buffer.length();
                --ResourceCache.this._cachedFiles;
                if (ResourceCache.this._mostRecentlyUsed == this) {
                    ResourceCache.this._mostRecentlyUsed = this._next;
                } else {
                    this._prev._next = this._next;
                }
                if (ResourceCache.this._leastRecentlyUsed == this) {
                    ResourceCache.this._leastRecentlyUsed = this._prev;
                } else {
                    this._next._prev = this._prev;
                }
                this._prev = null;
                this._next = null;
                if (this._resource != null) {
                    this._resource.release();
                }
                this._resource = null;
            }
        }

        @Override
        public Buffer getLastModified() {
            return this._lastModifiedBytes;
        }

        @Override
        public Buffer getContentType() {
            return this._contentType;
        }

        public void setContentType(Buffer buffer) {
            this._contentType = buffer;
        }

        @Override
        public void release() {
        }

        @Override
        public Buffer getBuffer() {
            if (this._buffer == null) {
                return null;
            }
            return new View(this._buffer);
        }

        public void setBuffer(Buffer buffer) {
            this._buffer = buffer;
        }

        @Override
        public long getContentLength() {
            if (this._buffer == null) {
                return -1L;
            }
            return this._buffer.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }
    }
}

