/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.io.BufferCache;
import org.mortbay.jetty.Generator;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.log.Log;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.IO;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public class Response
implements HttpServletResponse {
    public static final int DISABLED = -1;
    public static final int NONE = 0;
    public static final int STREAM = 1;
    public static final int WRITER = 2;
    private static PrintWriter __nullPrintWriter;
    private static ServletOutputStream __nullServletOut;
    private HttpConnection _connection;
    private int _status = 200;
    private String _reason;
    private Locale _locale;
    private String _mimeType;
    private BufferCache.CachedBuffer _cachedMimeType;
    private String _characterEncoding;
    private boolean _explicitEncoding;
    private String _contentType;
    private int _outputState;
    private PrintWriter _writer;

    public Response(HttpConnection httpConnection) {
        this._connection = httpConnection;
    }

    protected void recycle() {
        this._status = 200;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._cachedMimeType = null;
        this._characterEncoding = null;
        this._explicitEncoding = false;
        this._contentType = null;
        this._outputState = 0;
        this._writer = null;
    }

    public void addCookie(Cookie cookie) {
        this._connection.getResponseFields().addSetCookie(cookie);
    }

    public boolean containsHeader(String string) {
        return this._connection.getResponseFields().containsKey(string);
    }

    public String encodeURL(String string) {
        Request request = this._connection.getRequest();
        SessionManager sessionManager = request.getSessionManager();
        if (sessionManager == null) {
            return string;
        }
        String string2 = sessionManager.getSessionURLPrefix();
        if (string2 == null) {
            return string;
        }
        if (string == null || request == null || request.isRequestedSessionIdFromCookie()) {
            int n = string.indexOf(string2);
            if (n != -1) {
                int n2 = string.indexOf("?", n);
                if (n2 < 0) {
                    n2 = string.indexOf("#", n);
                }
                if (n2 <= n) {
                    return string.substring(0, n);
                }
                return string.substring(0, n) + string.substring(n2);
            }
            return string;
        }
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return string;
        }
        if (!sessionManager.isValid(httpSession)) {
            return string;
        }
        String string3 = sessionManager.getNodeId(httpSession);
        int n = string.indexOf(string2);
        if (n != -1) {
            int n3 = string.indexOf("?", n);
            if (n3 < 0) {
                n3 = string.indexOf("#", n);
            }
            if (n3 <= n) {
                return string.substring(0, n + string2.length()) + string3;
            }
            return string.substring(0, n + string2.length()) + string3 + string.substring(n3);
        }
        int n4 = string.indexOf(63);
        if (n4 < 0) {
            n4 = string.indexOf(35);
        }
        if (n4 < 0) {
            return string + string2 + string3;
        }
        return string.substring(0, n4) + string2 + string3 + string.substring(n4);
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeURL(string);
    }

    public void sendError(int n, String string) throws IOException {
        if (this._connection.isIncluding()) {
            return;
        }
        if (this.isCommitted()) {
            Log.warn("Committed before " + n + " " + string);
        }
        this.resetBuffer();
        this._characterEncoding = null;
        this.setHeader("Expires", null);
        this.setHeader("Last-Modified", null);
        this.setHeader("Cache-Control", null);
        this.setHeader("Content-Type", null);
        this.setHeader("Content-Length", null);
        this._outputState = 0;
        this.setStatus(n, string);
        if (string == null) {
            string = HttpGenerator.getReason(n);
        }
        if (n != 204 && n != 304 && n != 206 && n >= 200) {
            Request request = this._connection.getRequest();
            ErrorHandler errorHandler = null;
            ContextHandler.SContext sContext = request.getContext();
            if (sContext != null) {
                errorHandler = sContext.getContextHandler().getErrorHandler();
            }
            if (errorHandler != null) {
                request.setAttribute("javax.servlet.error.status_code", new Integer(n));
                request.setAttribute("javax.servlet.error.message", string);
                request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
                errorHandler.handle(null, this._connection.getRequest(), this, 8);
            } else {
                String string2;
                this.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
                this.setContentType("text/html; charset=iso-8859-1");
                ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer(2048);
                if (string != null) {
                    string = StringUtil.replace(string, "&", "&amp;");
                    string = StringUtil.replace(string, "<", "&lt;");
                    string = StringUtil.replace(string, ">", "&gt;");
                }
                if ((string2 = request.getRequestURI()) != null) {
                    string2 = StringUtil.replace(string2, "&", "&amp;");
                    string2 = StringUtil.replace(string2, "<", "&lt;");
                    string2 = StringUtil.replace(string2, ">", "&gt;");
                }
                byteArrayISO8859Writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\"/>\n");
                byteArrayISO8859Writer.write("<title>Error ");
                byteArrayISO8859Writer.write(Integer.toString(n));
                byteArrayISO8859Writer.write(' ');
                if (string == null) {
                    string = HttpGenerator.getReason(n);
                }
                byteArrayISO8859Writer.write(string);
                byteArrayISO8859Writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
                byteArrayISO8859Writer.write(Integer.toString(n));
                byteArrayISO8859Writer.write("</h2>\n<p>Problem accessing ");
                byteArrayISO8859Writer.write(string2);
                byteArrayISO8859Writer.write(". Reason:\n<pre>    ");
                byteArrayISO8859Writer.write(string);
                byteArrayISO8859Writer.write("</pre>");
                byteArrayISO8859Writer.write("</p>\n<hr /><i><small>Powered by Jetty://</small></i>");
                for (int i = 0; i < 20; ++i) {
                    byteArrayISO8859Writer.write("\n                                                ");
                }
                byteArrayISO8859Writer.write("\n</body>\n</html>\n");
                byteArrayISO8859Writer.flush();
                this.setContentLength(byteArrayISO8859Writer.size());
                byteArrayISO8859Writer.writeTo((OutputStream)this.getOutputStream());
                byteArrayISO8859Writer.destroy();
            }
        } else if (n != 206) {
            this._connection.getRequestFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
            this._connection.getRequestFields().remove(HttpHeaders.CONTENT_LENGTH_BUFFER);
            this._characterEncoding = null;
            this._mimeType = null;
            this._cachedMimeType = null;
        }
        this.complete();
    }

    public void sendError(int n) throws IOException {
        if (n == 102) {
            this.sendProcessing();
        } else {
            this.sendError(n, null);
        }
    }

    public void sendProcessing() throws IOException {
        Generator generator = this._connection.getGenerator();
        if (generator instanceof HttpGenerator) {
            HttpGenerator httpGenerator = (HttpGenerator)generator;
            String string = this._connection.getRequest().getHeader("Expect");
            if (string != null && string.startsWith("102") && httpGenerator.getVersion() >= 11) {
                boolean bl = httpGenerator.isPersistent();
                httpGenerator.setResponse(102, null);
                httpGenerator.completeHeader(null, true);
                httpGenerator.setPersistent(true);
                httpGenerator.complete();
                httpGenerator.flush();
                httpGenerator.reset(false);
                httpGenerator.setPersistent(bl);
            }
        }
    }

    public void sendRedirect(String string) throws IOException {
        if (this._connection.isIncluding()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme(string)) {
            Object object;
            Object object2;
            StringBuffer stringBuffer = this._connection.getRequest().getRootURL();
            if (string.startsWith("/")) {
                stringBuffer.append(string);
            } else {
                object2 = this._connection.getRequest().getRequestURI();
                object = ((String)object2).endsWith("/") ? object2 : URIUtil.parentPath((String)object2);
                string = URIUtil.addPaths((String)object, string);
                if (string == null) {
                    throw new IllegalStateException("path cannot be above root");
                }
                if (!string.startsWith("/")) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(string);
            }
            string = stringBuffer.toString();
            object2 = new HttpURI(string);
            object = ((HttpURI)object2).getDecodedPath();
            String string2 = URIUtil.canonicalPath((String)object);
            if (string2 == null) {
                throw new IllegalArgumentException();
            }
            if (!string2.equals(object)) {
                stringBuffer = this._connection.getRequest().getRootURL();
                stringBuffer.append(string2);
                if (((HttpURI)object2).getQuery() != null) {
                    stringBuffer.append('?');
                    stringBuffer.append(((HttpURI)object2).getQuery());
                }
                if (((HttpURI)object2).getFragment() != null) {
                    stringBuffer.append('#');
                    stringBuffer.append(((HttpURI)object2).getFragment());
                }
                string = stringBuffer.toString();
            }
        }
        this.resetBuffer();
        this.setHeader("Location", string);
        this.setStatus(302);
        this.complete();
    }

    public void setDateHeader(String string, long l) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().putDateField(string, l);
        }
    }

    public void addDateHeader(String string, long l) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().addDateField(string, l);
        }
    }

    public void setHeader(String string, String string2) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().put(string, string2);
            if ("Content-Length".equalsIgnoreCase(string)) {
                if (string2 == null) {
                    this._connection._generator.setContentLength(-1L);
                } else {
                    this._connection._generator.setContentLength(Long.parseLong(string2));
                }
            }
        }
    }

    public String getHeader(String string) {
        return this._connection.getResponseFields().getStringField(string);
    }

    public Enumeration getHeaders(String string) {
        Enumeration enumeration = this._connection.getResponseFields().getValues(string);
        if (enumeration == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return enumeration;
    }

    public void addHeader(String string, String string2) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().add(string, string2);
            if ("Content-Length".equalsIgnoreCase(string)) {
                this._connection._generator.setContentLength(Long.parseLong(string2));
            }
        }
    }

    public void setIntHeader(String string, int n) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().putLongField(string, (long)n);
            if ("Content-Length".equalsIgnoreCase(string)) {
                this._connection._generator.setContentLength(n);
            }
        }
    }

    public void addIntHeader(String string, int n) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().addLongField(string, (long)n);
            if ("Content-Length".equalsIgnoreCase(string)) {
                this._connection._generator.setContentLength(n);
            }
        }
    }

    public void setStatus(int n) {
        this.setStatus(n, null);
    }

    public void setStatus(int n, String string) {
        if (!this._connection.isIncluding()) {
            this._status = n;
            this._reason = string;
        }
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            this._characterEncoding = StringUtil.__ISO_8859_1;
        }
        return this._characterEncoding;
    }

    String getSetCharacterEncoding() {
        return this._characterEncoding;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputState == -1) {
            return __nullServletOut;
        }
        if (this._outputState != 0 && this._outputState != 1) {
            throw new IllegalStateException("WRITER");
        }
        this._outputState = 1;
        return this._connection.getOutputStream();
    }

    public boolean isWriting() {
        return this._outputState == 2;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputState == -1) {
            return __nullPrintWriter;
        }
        if (this._outputState != 0 && this._outputState != 2) {
            throw new IllegalStateException("STREAM");
        }
        if (this._writer == null) {
            String string = this._characterEncoding;
            if (string == null) {
                if (this._mimeType != null) {
                    string = null;
                }
                if (string == null) {
                    string = StringUtil.__ISO_8859_1;
                }
                this.setCharacterEncoding(string);
            }
            this._writer = this._connection.getPrintWriter(string);
        }
        this._outputState = 2;
        return this._writer;
    }

    public void setCharacterEncoding(String string) {
        if (this._connection.isIncluding()) {
            return;
        }
        if (this._outputState == 0 && !this.isCommitted()) {
            this._explicitEncoding = true;
            if (string == null) {
                if (this._characterEncoding != null) {
                    this._characterEncoding = null;
                    if (this._cachedMimeType != null) {
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._cachedMimeType);
                    } else {
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._mimeType);
                    }
                }
            } else {
                this._characterEncoding = string;
                if (this._contentType != null) {
                    int n = this._contentType.indexOf(59);
                    if (n < 0) {
                        BufferCache.CachedBuffer cachedBuffer;
                        this._contentType = null;
                        if (this._cachedMimeType != null && (cachedBuffer = this._cachedMimeType.getAssociate(this._characterEncoding)) != null) {
                            this._contentType = cachedBuffer.toString();
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, cachedBuffer);
                        }
                        if (this._contentType == null) {
                            this._contentType = this._mimeType + "; charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else {
                        int n2;
                        int n3;
                        int n4 = this._contentType.indexOf("charset=", n);
                        this._contentType = n4 < 0 ? this._contentType + " charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ") : ((n3 = this._contentType.indexOf(" ", n2 = n4 + 8)) < 0 ? this._contentType.substring(0, n2) + QuotedStringTokenizer.quote(this._characterEncoding, ";= ") : this._contentType.substring(0, n2) + QuotedStringTokenizer.quote(this._characterEncoding, ";= ") + this._contentType.substring(n3));
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    }
                }
            }
        }
    }

    public void setContentLength(int n) {
        if (this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        this._connection._generator.setContentLength(n);
        if (n >= 0) {
            this._connection.getResponseFields().putLongField("Content-Length", (long)n);
            if (this._connection._generator.isContentWritten()) {
                if (this._outputState == 2) {
                    this._writer.close();
                } else if (this._outputState == 1) {
                    try {
                        this.getOutputStream().close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
        }
    }

    public void setLongContentLength(long l) {
        if (this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        this._connection._generator.setContentLength(l);
        this._connection.getResponseFields().putLongField("Content-Length", l);
    }

    public void setContentType(String string) {
        if (this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        if (string == null) {
            if (this._locale == null) {
                this._characterEncoding = null;
            }
            this._mimeType = null;
            this._cachedMimeType = null;
            this._contentType = null;
            this._connection.getResponseFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
        } else {
            int n = string.indexOf(59);
            if (n > 0) {
                this._mimeType = string.substring(0, n).trim();
                this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                int n2 = string.indexOf("charset=", n + 1);
                if (n2 >= 0) {
                    this._explicitEncoding = true;
                    int n3 = n2 + 8;
                    int n4 = string.indexOf(32, n3);
                    if (this._outputState == 2) {
                        if (n2 == n + 1 && n4 < 0 || n2 == n + 2 && n4 < 0 && string.charAt(n + 1) == ' ') {
                            if (this._cachedMimeType != null) {
                                BufferCache.CachedBuffer cachedBuffer = this._cachedMimeType.getAssociate(this._characterEncoding);
                                if (cachedBuffer != null) {
                                    this._contentType = cachedBuffer.toString();
                                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, cachedBuffer);
                                } else {
                                    this._contentType = this._mimeType + "; charset=" + this._characterEncoding;
                                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                                }
                            } else {
                                this._contentType = this._mimeType + "; charset=" + this._characterEncoding;
                                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                            }
                        } else if (n4 < 0) {
                            this._contentType = string.substring(0, n2) + " charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        } else {
                            this._contentType = string.substring(0, n2) + string.substring(n4) + " charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else if (n2 == n + 1 && n4 < 0 || n2 == n + 2 && n4 < 0 && string.charAt(n + 1) == ' ') {
                        this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                        this._characterEncoding = QuotedStringTokenizer.unquote(string.substring(n3));
                        if (this._cachedMimeType != null) {
                            BufferCache.CachedBuffer cachedBuffer = this._cachedMimeType.getAssociate(this._characterEncoding);
                            if (cachedBuffer != null) {
                                this._contentType = cachedBuffer.toString();
                                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, cachedBuffer);
                            } else {
                                this._contentType = string;
                                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                            }
                        } else {
                            this._contentType = string;
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else if (n4 > 0) {
                        this._characterEncoding = QuotedStringTokenizer.unquote(string.substring(n3, n4));
                        this._contentType = string;
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    } else {
                        this._characterEncoding = QuotedStringTokenizer.unquote(string.substring(n3));
                        this._contentType = string;
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    }
                } else {
                    this._cachedMimeType = null;
                    this._contentType = this._characterEncoding == null ? string : string + " charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                }
            } else {
                this._mimeType = string;
                this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                if (this._characterEncoding != null) {
                    if (this._cachedMimeType != null) {
                        BufferCache.CachedBuffer cachedBuffer = this._cachedMimeType.getAssociate(this._characterEncoding);
                        if (cachedBuffer != null) {
                            this._contentType = cachedBuffer.toString();
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, cachedBuffer);
                        } else {
                            this._contentType = this._mimeType + "; charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else {
                        this._contentType = string + "; charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    }
                } else if (this._cachedMimeType != null) {
                    this._contentType = this._cachedMimeType.toString();
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._cachedMimeType);
                } else {
                    this._contentType = string;
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                }
            }
        }
    }

    public void setBufferSize(int n) {
        if (this.isCommitted() || this.getContentCount() > 0L) {
            throw new IllegalStateException("Committed or content written");
        }
        this._connection.getGenerator().increaseContentBufferSize(n);
    }

    public int getBufferSize() {
        return this._connection.getGenerator().getContentBufferSize();
    }

    public void flushBuffer() throws IOException {
        this._connection.flushResponse();
    }

    public void reset() {
        Object object;
        this.resetBuffer();
        HttpFields httpFields = this._connection.getResponseFields();
        httpFields.clear();
        String string = this._connection.getRequestFields().getStringField(HttpHeaders.CONNECTION_BUFFER);
        if (string != null) {
            object = string.split(",");
            block5: for (int i = 0; object != null && i < ((String[])object).length; ++i) {
                BufferCache.CachedBuffer cachedBuffer = HttpHeaderValues.CACHE.get(((String)object[0]).trim());
                if (cachedBuffer == null) continue;
                switch (cachedBuffer.getOrdinal()) {
                    case 1: {
                        httpFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        continue block5;
                    }
                    case 5: {
                        if (!"HTTP/1.0".equalsIgnoreCase(this._connection.getRequest().getProtocol())) continue block5;
                        httpFields.put(HttpHeaders.CONNECTION_BUFFER, "keep-alive");
                        continue block5;
                    }
                    case 8: {
                        httpFields.put(HttpHeaders.CONNECTION_BUFFER, "TE");
                    }
                }
            }
        }
        if (this._connection.getConnector().getServer().getSendDateHeader()) {
            object = this._connection.getRequest();
            httpFields.put(HttpHeaders.DATE_BUFFER, ((Request)object).getTimeStampBuffer(), ((Request)object).getTimeStamp());
        }
        this._status = 200;
        this._reason = null;
        this._mimeType = null;
        this._cachedMimeType = null;
        this._contentType = null;
        this._characterEncoding = null;
        this._explicitEncoding = false;
        this._locale = null;
        this._outputState = 0;
        this._writer = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this._connection.getGenerator().resetBuffer();
    }

    public boolean isCommitted() {
        return this._connection.isResponseCommitted();
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        this._locale = locale;
        this._connection.getResponseFields().put(HttpHeaders.CONTENT_LANGUAGE_BUFFER, locale.toString().replace('_', '-'));
        if (this._explicitEncoding || this._outputState != 0) {
            return;
        }
        if (this._connection.getRequest().getContext() == null) {
            return;
        }
        String string = this._connection.getRequest().getContext().getContextHandler().getLocaleEncoding(locale);
        if (string != null && string.length() > 0) {
            this._characterEncoding = string;
            String string2 = this.getContentType();
            if (string2 != null) {
                this._characterEncoding = string;
                int n = string2.indexOf(59);
                if (n < 0) {
                    this._mimeType = string2;
                    this._contentType = string2 = string2 + "; charset=" + string;
                } else {
                    this._mimeType = string2.substring(0, n);
                    this._contentType = this._mimeType = this._mimeType + "; charset=" + string;
                }
                this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
            }
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public void complete() throws IOException {
        this._connection.completeResponse();
    }

    public long getContentCount() {
        if (this._connection == null || this._connection.getGenerator() == null) {
            return -1L;
        }
        return this._connection.getGenerator().getContentWritten();
    }

    public HttpFields getHttpFields() {
        return this._connection.getResponseFields();
    }

    public String toString() {
        return "HTTP/1.1 " + this._status + " " + (this._reason == null ? "" : this._reason) + System.getProperty("line.separator") + this._connection.getResponseFields().toString();
    }

    static {
        try {
            __nullPrintWriter = new PrintWriter(IO.getNullWriter());
            __nullServletOut = new NullOutput();
        }
        catch (Exception exception) {
            Log.warn(exception);
        }
    }

    private static class NullOutput
    extends ServletOutputStream {
        private NullOutput() {
        }

        public void write(int n) throws IOException {
        }
    }
}

