/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import org.mortbay.component.Container;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

public class Server
extends HandlerWrapper
implements Attributes {
    public static final String UNKNOWN_VERSION = "6.1.x";
    public static final String SNAPSHOT_VERSION = "6.1-SNAPSHOT";
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    private static String _version = Server.class.getPackage() != null && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : "6.1.x";
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private UserRealm[] _realms;
    private Container _container = new Container();
    private SessionIdManager _sessionIdManager;
    private boolean _sendServerVersion = true;
    private boolean _sendDateHeader = false;
    private AttributesMap _attributes = new AttributesMap();
    private List _dependentLifeCycles = new ArrayList();
    private int _graceful = 0;

    public Server() {
        this.setServer(this);
    }

    public Server(int n) {
        this.setServer(this);
        SocketConnector socketConnector = new SocketConnector();
        socketConnector.setPort(n);
        this.setConnectors(new Connector[]{socketConnector});
    }

    public static String getVersion() {
        return _version;
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean bl) {
        if (bl) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.addToArray(this.getConnectors(), connector, Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.removeFromArray(this.getConnectors(), connector));
    }

    public void setConnectors(Connector[] connectorArray) {
        if (connectorArray != null) {
            for (int i = 0; i < connectorArray.length; ++i) {
                connectorArray[i].setServer(this);
            }
        }
        this._container.update((Object)this, this._connectors, connectorArray, "connector");
        this._connectors = connectorArray;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool", true);
        this._threadPool = threadPool;
    }

    @Override
    protected void doStart() throws Exception {
        Log.info("jetty-" + _version);
        HttpGenerator.setServerVersion(_version);
        MultiException multiException = new MultiException();
        for (int i = 0; this._realms != null && i < this._realms.length; ++i) {
            if (!(this._realms[i] instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)this._realms[i])).start();
        }
        Iterator iterator = this._dependentLifeCycles.iterator();
        while (iterator.hasNext()) {
            try {
                ((LifeCycle)iterator.next()).start();
            }
            catch (Throwable throwable) {
                multiException.add(throwable);
            }
        }
        if (this._threadPool == null) {
            QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
            this.setThreadPool(queuedThreadPool);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.start();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).start();
            }
        }
        catch (Throwable throwable) {
            multiException.add(throwable);
        }
        try {
            super.doStart();
        }
        catch (Throwable throwable) {
            Log.warn("Error starting handlers", throwable);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable throwable) {
                    multiException.add(throwable);
                }
            }
        }
        multiException.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        int n;
        MultiException multiException = new MultiException();
        for (n = 0; this._realms != null && n < this._realms.length; ++n) {
            if (!(this._realms[n] instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)this._realms[n])).stop();
        }
        if (this._graceful > 0) {
            if (this._connectors != null) {
                n = this._connectors.length;
                while (n-- > 0) {
                    Log.info("Graceful shutdown {}", this._connectors[n]);
                    try {
                        this._connectors[n].close();
                    }
                    catch (Throwable throwable) {
                        multiException.add(throwable);
                    }
                }
            }
            Handler[] handlerArray = this.getChildHandlersByClass(Graceful.class);
            for (int i = 0; i < handlerArray.length; ++i) {
                Graceful graceful = (Graceful)((Object)handlerArray[i]);
                Log.info("Graceful shutdown {}", graceful);
                graceful.setShutdown(true);
            }
            Thread.sleep(this._graceful);
        }
        if (this._connectors != null) {
            n = this._connectors.length;
            while (n-- > 0) {
                try {
                    this._connectors[n].stop();
                }
                catch (Throwable throwable) {
                    multiException.add(throwable);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable throwable) {
            multiException.add(throwable);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.stop();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).stop();
            }
        }
        catch (Throwable throwable) {
            multiException.add(throwable);
        }
        if (!this._dependentLifeCycles.isEmpty()) {
            ListIterator listIterator = this._dependentLifeCycles.listIterator(this._dependentLifeCycles.size());
            while (listIterator.hasPrevious()) {
                try {
                    ((LifeCycle)listIterator.previous()).stop();
                }
                catch (Throwable throwable) {
                    multiException.add(throwable);
                }
            }
        }
        multiException.ifExceptionThrow();
    }

    public void handle(HttpConnection httpConnection) throws IOException, ServletException {
        String string = httpConnection.getRequest().getPathInfo();
        if (Log.isDebugEnabled()) {
            Log.debug("REQUEST " + string + " on " + httpConnection);
            this.handle(string, httpConnection.getRequest(), httpConnection.getResponse(), 1);
            Log.debug("RESPONSE " + string + "  " + httpConnection.getResponse().getStatus());
        } else {
            this.handle(string, httpConnection.getRequest(), httpConnection.getResponse(), 1);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public UserRealm[] getUserRealms() {
        return this._realms;
    }

    public void setUserRealms(UserRealm[] userRealmArray) {
        this._container.update((Object)this, this._realms, userRealmArray, "realm", true);
        this._realms = userRealmArray;
    }

    public void addUserRealm(UserRealm userRealm) {
        this.setUserRealms((UserRealm[])LazyList.addToArray(this.getUserRealms(), userRealm, UserRealm.class));
    }

    public void removeUserRealm(UserRealm userRealm) {
        this.setUserRealms((UserRealm[])LazyList.removeFromArray(this.getUserRealms(), userRealm));
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._container.update((Object)this, this._sessionIdManager, sessionIdManager, "sessionIdManager", true);
        this._sessionIdManager = sessionIdManager;
    }

    public void setSendServerVersion(boolean bl) {
        this._sendServerVersion = bl;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendDateHeader(boolean bl) {
        this._sendDateHeader = bl;
    }

    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public void addLifeCycle(LifeCycle lifeCycle) {
        if (lifeCycle == null) {
            return;
        }
        if (!this._dependentLifeCycles.contains(lifeCycle)) {
            this._dependentLifeCycles.add(lifeCycle);
            this._container.addBean(lifeCycle);
        }
        try {
            if (this.isStarted()) {
                lifeCycle.start();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void removeLifeCycle(LifeCycle lifeCycle) {
        if (lifeCycle == null) {
            return;
        }
        this._dependentLifeCycles.remove(lifeCycle);
        this._container.removeBean(lifeCycle);
    }

    @Override
    public void addHandler(Handler handler) {
        if (this.getHandler() == null) {
            this.setHandler(handler);
        } else if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).addHandler(handler);
        } else {
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{this.getHandler(), handler});
            this.setHandler(handlerCollection);
        }
    }

    @Override
    public void removeHandler(Handler handler) {
        if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).removeHandler(handler);
        }
    }

    public Handler[] getHandlers() {
        if (this.getHandler() instanceof HandlerCollection) {
            return ((HandlerCollection)this.getHandler()).getHandlers();
        }
        return null;
    }

    public void setHandlers(Handler[] handlerArray) {
        HandlerCollection handlerCollection;
        if (this.getHandler() instanceof HandlerCollection) {
            handlerCollection = (HandlerCollection)this.getHandler();
        } else {
            handlerCollection = new HandlerCollection();
            this.setHandler(handlerCollection);
        }
        handlerCollection.setHandlers(handlerArray);
    }

    @Override
    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    @Override
    public Object getAttribute(String string) {
        return this._attributes.getAttribute(string);
    }

    @Override
    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    @Override
    public void removeAttribute(String string) {
        this._attributes.removeAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this._attributes.setAttribute(string, object);
    }

    public int getGracefulShutdown() {
        return this._graceful;
    }

    public void setGracefulShutdown(int n) {
        this._graceful = n;
    }

    public static interface Graceful {
        public void setShutdown(boolean var1);
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method method = Runtime.class.getMethod("addShutdownHook", Thread.class);
                        method.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception exception) {
                        if (!Log.isDebugEnabled()) break block3;
                        Log.debug("No shutdown hook in JVM ", exception);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection collection) {
            this.createShutdownHook();
            return this.servers.addAll(collection);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return this.servers.remove(server);
        }

        public boolean removeAll(Collection collection) {
            this.createShutdownHook();
            return this.servers.removeAll(collection);
        }

        @Override
        public void run() {
            this.setName("Shutdown");
            Log.info("Shutdown hook executing");
            for (Server server : this.servers) {
                if (server == null) continue;
                try {
                    server.stop();
                }
                catch (Exception exception) {
                    Log.warn(exception);
                }
                Log.info("Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    Log.warn(exception);
                }
            }
        }
    }
}

