/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.log.Log;

public class SocketConnector
extends AbstractConnector {
    protected ServerSocket _serverSocket;
    protected Set _connections;

    @Override
    public Object getConnection() {
        return this._serverSocket;
    }

    @Override
    public void open() throws IOException {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            this._serverSocket = this.newServerSocket(this.getHost(), this.getPort(), this.getAcceptQueueSize());
        }
        this._serverSocket.setReuseAddress(this.getReuseAddress());
    }

    protected ServerSocket newServerSocket(String string, int n, int n2) throws IOException {
        ServerSocket serverSocket = string == null ? new ServerSocket(n, n2) : new ServerSocket(n, n2, InetAddress.getByName(string));
        return serverSocket;
    }

    @Override
    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
    }

    @Override
    public void accept(int n) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
    }

    protected HttpConnection newHttpConnection(EndPoint endPoint) {
        return new HttpConnection(this, endPoint, this.getServer());
    }

    @Override
    protected Buffer newBuffer(int n) {
        return new ByteArrayBuffer(n);
    }

    @Override
    public void customize(EndPoint endPoint, Request request) throws IOException {
        Connection connection = (Connection)endPoint;
        if (connection._sotimeout != this._maxIdleTime) {
            connection._sotimeout = this._maxIdleTime;
            ((Socket)endPoint.getTransport()).setSoTimeout(this._maxIdleTime);
        }
        super.customize(endPoint, request);
    }

    @Override
    public int getLocalPort() {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            return -1;
        }
        return this._serverSocket.getLocalPort();
    }

    @Override
    protected void doStart() throws Exception {
        this._connections = new HashSet();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        HashSet hashSet = null;
        Set set = this._connections;
        synchronized (set) {
            hashSet = new HashSet(this._connections);
        }
        for (Connection connection : hashSet) {
            connection.close();
        }
    }

    protected class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;
        protected Socket _socket;

        public Connection(Socket socket) throws IOException {
            super(socket);
            this._dispatched = false;
            this._connection = SocketConnector.this.newHttpConnection(this);
            this._sotimeout = socket.getSoTimeout();
            this._socket = socket;
        }

        public void dispatch() throws InterruptedException, IOException {
            if (SocketConnector.this.getThreadPool() == null || !SocketConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for {}", this._connection);
                this.close();
            }
        }

        @Override
        public int fill(Buffer buffer) throws IOException {
            int n = super.fill(buffer);
            if (n < 0) {
                this.close();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SocketConnector.this.connectionOpened(this._connection);
                Set set = SocketConnector.this._connections;
                synchronized (set) {
                    SocketConnector.this._connections.add(this);
                }
                while (SocketConnector.this.isStarted() && !this.isClosed()) {
                    int n;
                    if (this._connection.isIdle() && SocketConnector.this.getServer().getThreadPool().isLowOnThreads() && (n = SocketConnector.this.getLowResourceMaxIdleTime()) >= 0 && this._sotimeout != n) {
                        this._sotimeout = n;
                        this._socket.setSoTimeout(this._sotimeout);
                    }
                    this._connection.handle();
                }
            }
            catch (EofException eofException) {
                Log.debug("EOF", eofException);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            catch (HttpException httpException) {
                Log.debug("BAD", httpException);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            catch (Throwable throwable) {
                Log.warn("handle failed", throwable);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            finally {
                SocketConnector.this.connectionClosed(this._connection);
                Set set = SocketConnector.this._connections;
                synchronized (set) {
                    SocketConnector.this._connections.remove(this);
                }
            }
        }
    }
}

