/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.deployer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.deployer.ConfigurationManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.Scanner;
import org.mortbay.xml.XmlConfiguration;

public class ContextDeployer
extends AbstractLifeCycle {
    public static final String NAME = "ConfiguredDeployer";
    private int _scanInterval = 10;
    private Scanner _scanner;
    private ScannerListener _scannerListener;
    private Resource _configurationDir;
    private Map _currentDeployments = new HashMap();
    private ContextHandlerCollection _contexts;
    private ConfigurationManager _configMgr;
    private boolean _recursive = false;

    public ContextDeployer() throws Exception {
        this._scanner = new Scanner();
    }

    public ContextHandlerCollection getContexts() {
        return this._contexts;
    }

    public void setContexts(ContextHandlerCollection contextHandlerCollection) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot set Contexts after deployer start");
        }
        this._contexts = contextHandlerCollection;
    }

    public void setScanInterval(int n) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot change scan interval after deployer start");
        }
        this._scanInterval = n;
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setConfigurationDir(String string) throws Exception {
        this.setConfigurationDir(Resource.newResource(string));
    }

    public void setConfigurationDir(File file) throws Exception {
        this.setConfigurationDir(Resource.newResource(file.toURL()));
    }

    public void setConfigurationDir(Resource resource) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot change hot deploy dir after deployer start");
        }
        this._configurationDir = resource;
    }

    public void setDirectory(String string) throws Exception {
        this.setConfigurationDir(string);
    }

    public String getDirectory() {
        return this.getConfigurationDir().getName();
    }

    public Resource getConfigurationDir() {
        return this._configurationDir;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this._configMgr = configurationManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configMgr;
    }

    public void setRecursive(boolean bl) {
        this._recursive = bl;
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    private void deploy(String string) throws Exception {
        ContextHandler contextHandler = this.createContext(string);
        Log.info("Deploy " + string + " -> " + contextHandler);
        this._contexts.addHandler(contextHandler);
        this._currentDeployments.put(string, contextHandler);
        if (this._contexts.isStarted()) {
            contextHandler.start();
        }
    }

    private void undeploy(String string) throws Exception {
        ContextHandler contextHandler = (ContextHandler)this._currentDeployments.get(string);
        Log.info("Undeploy " + string + " -> " + contextHandler);
        if (contextHandler == null) {
            return;
        }
        contextHandler.stop();
        this._contexts.removeHandler(contextHandler);
        this._currentDeployments.remove(string);
    }

    private void redeploy(String string) throws Exception {
        this.undeploy(string);
        this.deploy(string);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._configurationDir == null) {
            throw new IllegalStateException("No configuraition dir specified");
        }
        if (this._contexts == null) {
            throw new IllegalStateException("No context handler collection specified for deployer");
        }
        this._scanner.setScanDir(this._configurationDir.getFile());
        this._scanner.setScanInterval(this.getScanInterval());
        this._scanner.setRecursive(this._recursive);
        this._scanner.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                try {
                    return string.endsWith(".xml") && file.equals(ContextDeployer.this.getConfigurationDir().getFile());
                }
                catch (IOException iOException) {
                    Log.warn(iOException);
                    return false;
                }
            }
        });
        this._scannerListener = new ScannerListener();
        this._scanner.addListener(this._scannerListener);
        this._scanner.scan();
        this._scanner.start();
        this._contexts.getServer().getContainer().addBean(this._scanner);
    }

    @Override
    protected void doStop() throws Exception {
        this._scanner.removeListener(this._scannerListener);
        this._scanner.stop();
    }

    private ContextHandler createContext(String string) throws Exception {
        Resource resource = Resource.newResource(string);
        if (!resource.exists()) {
            return null;
        }
        XmlConfiguration xmlConfiguration = new XmlConfiguration(resource.getURL());
        HashMap<String, Server> hashMap = new HashMap<String, Server>();
        hashMap.put("Server", this._contexts.getServer());
        if (this._configMgr != null) {
            hashMap.putAll(this._configMgr.getProperties());
        }
        xmlConfiguration.setProperties(hashMap);
        ContextHandler contextHandler = (ContextHandler)xmlConfiguration.configure();
        return contextHandler;
    }

    protected class ScannerListener
    implements Scanner.DiscreteListener {
        protected ScannerListener() {
        }

        @Override
        public void fileAdded(String string) throws Exception {
            ContextDeployer.this.deploy(string);
        }

        @Override
        public void fileChanged(String string) throws Exception {
            ContextDeployer.this.redeploy(string);
        }

        @Override
        public void fileRemoved(String string) throws Exception {
            ContextDeployer.this.undeploy(string);
        }

        public String toString() {
            return "ContextDeployer$Scanner";
        }
    }
}

