/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.deployer;

import java.util.ArrayList;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class WebAppDeployer
extends AbstractLifeCycle {
    private HandlerContainer _contexts;
    private String _webAppDir;
    private String _defaultsDescriptor;
    private String[] _configurationClasses;
    private boolean _extract;
    private boolean _parentLoaderPriority;
    private boolean _allowDuplicates;
    private ArrayList _deployed;

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setConfigurationClasses(String[] stringArray) {
        this._configurationClasses = stringArray;
    }

    public HandlerContainer getContexts() {
        return this._contexts;
    }

    public void setContexts(HandlerContainer handlerContainer) {
        this._contexts = handlerContainer;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String string) {
        this._defaultsDescriptor = string;
    }

    public boolean isExtract() {
        return this._extract;
    }

    public void setExtract(boolean bl) {
        this._extract = bl;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean bl) {
        this._parentLoaderPriority = bl;
    }

    public String getWebAppDir() {
        return this._webAppDir;
    }

    public void setWebAppDir(String string) {
        this._webAppDir = string;
    }

    public boolean getAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this._allowDuplicates = bl;
    }

    @Override
    public void doStart() throws Exception {
        this._deployed = new ArrayList();
        this.scan();
    }

    public void scan() throws Exception {
        if (this._contexts == null) {
            throw new IllegalArgumentException("No HandlerContainer");
        }
        Resource resource = Resource.newResource(this._webAppDir);
        if (!resource.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + resource);
        }
        if (!resource.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + resource);
        }
        String[] stringArray = resource.list();
        block4: for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            if (string.equalsIgnoreCase("CVS/") || string.equalsIgnoreCase("CVS") || string.startsWith(".")) continue;
            Resource resource2 = resource.addPath(resource.encode(string));
            if (!string.toLowerCase().endsWith(".war") && !string.toLowerCase().endsWith(".jar") ? !resource2.isDirectory() : (object = resource.addPath(string = string.substring(0, string.length() - 4))) != null && ((Resource)object).exists() && ((Resource)object).isDirectory()) continue;
            string = string.equalsIgnoreCase("root") || string.equalsIgnoreCase("root/") ? "/" : "/" + string;
            if (string.endsWith("/") && string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            if (!this._allowDuplicates) {
                object = this._contexts.getChildHandlersByClass(ContextHandler.class);
                for (int j = 0; j < ((Handler[])object).length; ++j) {
                    ContextHandler contextHandler = (ContextHandler)object[j];
                    if (string.equals(contextHandler.getContextPath())) continue block4;
                    try {
                        String string2 = null;
                        if (contextHandler instanceof WebAppContext) {
                            string2 = Resource.newResource(((WebAppContext)contextHandler).getWar()).getFile().getAbsolutePath();
                        } else if (contextHandler.getBaseResource() != null) {
                            string2 = contextHandler.getBaseResource().getFile().getAbsolutePath();
                        }
                        if (string2 == null || !string2.equals(resource2.getFile().getAbsolutePath())) continue;
                        continue block4;
                    }
                    catch (Exception exception) {
                        Log.ignore(exception);
                    }
                }
            }
            object = null;
            if (this._contexts instanceof ContextHandlerCollection && WebAppContext.class.isAssignableFrom(((ContextHandlerCollection)this._contexts).getContextClass())) {
                try {
                    object = (WebAppContext)((ContextHandlerCollection)this._contexts).getContextClass().newInstance();
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
            } else {
                object = new WebAppContext();
            }
            ((ContextHandler)object).setContextPath(string);
            if (this._configurationClasses != null) {
                ((WebAppContext)object).setConfigurationClasses(this._configurationClasses);
            }
            if (this._defaultsDescriptor != null) {
                ((WebAppContext)object).setDefaultsDescriptor(this._defaultsDescriptor);
            }
            ((WebAppContext)object).setExtractWAR(this._extract);
            ((WebAppContext)object).setWar(resource2.toString());
            ((WebAppContext)object).setParentLoaderPriority(this._parentLoaderPriority);
            this._contexts.addHandler((Handler)object);
            this._deployed.add(object);
            if (!this._contexts.isStarted()) continue;
            this._contexts.start();
        }
    }

    @Override
    public void doStop() throws Exception {
        int n = this._deployed.size();
        while (n-- > 0) {
            ContextHandler contextHandler = (ContextHandler)this._deployed.get(n);
            contextHandler.stop();
        }
    }
}

