/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.resource.Resource;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.URIUtil;

public class ContextHandler
extends HandlerWrapper
implements Attributes,
Server.Graceful {
    private static ThreadLocal __context = new ThreadLocal();
    public static final String MANAGED_ATTRIBUTES = "org.mortbay.jetty.servlet.ManagedAttributes";
    protected SContext _scontext;
    private AttributesMap _attributes;
    private AttributesMap _contextAttributes;
    private ClassLoader _classLoader;
    private String _contextPath = "/";
    private Map _initParams;
    private String _displayName;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private String[] _vhosts;
    private Set _connectors;
    private EventListener[] _eventListeners;
    private Logger _logger;
    private boolean _shutdown;
    private boolean _allowNullPathInfo;
    private int _maxFormContentSize = Integer.getInteger("org.mortbay.jetty.Request.maxFormContentSize", 200000);
    private boolean _compactPath = false;
    private Object _contextListeners;
    private Object _contextAttributeListeners;
    private Object _requestListeners;
    private Object _requestAttributeListeners;
    private Set _managedAttributes;

    public static SContext getCurrentContext() {
        SContext sContext = (SContext)__context.get();
        return sContext;
    }

    public ContextHandler() {
        this._scontext = new SContext();
        this._attributes = new AttributesMap();
        this._initParams = new HashMap();
    }

    protected ContextHandler(SContext sContext) {
        this._scontext = sContext;
        this._attributes = new AttributesMap();
        this._initParams = new HashMap();
    }

    public ContextHandler(String string) {
        this();
        this.setContextPath(string);
    }

    public ContextHandler(HandlerContainer handlerContainer, String string) {
        this();
        this.setContextPath(string);
        handlerContainer.addHandler(this);
    }

    public SContext getServletContext() {
        return this._scontext;
    }

    public boolean getAllowNullPathInfo() {
        return this._allowNullPathInfo;
    }

    public void setAllowNullPathInfo(boolean bl) {
        this._allowNullPathInfo = bl;
    }

    @Override
    public void setServer(Server server) {
        if (this._errorHandler != null) {
            Server server2 = this.getServer();
            if (server2 != null && server2 != server) {
                server2.getContainer().update((Object)this, this._errorHandler, null, "error", true);
            }
            super.setServer(server);
            if (server != null && server != server2) {
                server.getContainer().update((Object)this, null, this._errorHandler, "error", true);
            }
            this._errorHandler.setServer(server);
        } else {
            super.setServer(server);
        }
    }

    public void setVirtualHosts(String[] stringArray) {
        if (stringArray == null) {
            this._vhosts = stringArray;
        } else {
            this._vhosts = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this._vhosts[i] = this.normalizeHostname(stringArray[i]);
            }
        }
    }

    public String[] getVirtualHosts() {
        return this._vhosts;
    }

    public void setHosts(String[] stringArray) {
        this.setConnectorNames(stringArray);
    }

    public String[] getHosts() {
        return this.getConnectorNames();
    }

    public String[] getConnectorNames() {
        if (this._connectors == null || this._connectors.size() == 0) {
            return null;
        }
        return this._connectors.toArray(new String[this._connectors.size()]);
    }

    public void setConnectorNames(String[] stringArray) {
        this._connectors = stringArray == null || stringArray.length == 0 ? null : new HashSet<String>(Arrays.asList(stringArray));
    }

    @Override
    public Object getAttribute(String string) {
        return this._attributes.getAttribute(string);
    }

    @Override
    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getClassPath() {
        if (this._classLoader == null || !(this._classLoader instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)this._classLoader;
        URL[] uRLArray = uRLClassLoader.getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                Resource resource = Resource.newResource(uRLArray[i]);
                File file = resource.getFile();
                if (!file.exists()) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparatorChar);
                }
                stringBuffer.append(file.getAbsolutePath());
                continue;
            }
            catch (IOException iOException) {
                Log.debug(iOException);
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String string) {
        return (String)this._initParams.get(string);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public Map getInitParams() {
        return this._initParams;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public EventListener[] getEventListeners() {
        return this._eventListeners;
    }

    public void setEventListeners(EventListener[] eventListenerArray) {
        this._contextListeners = null;
        this._contextAttributeListeners = null;
        this._requestListeners = null;
        this._requestAttributeListeners = null;
        this._eventListeners = eventListenerArray;
        for (int i = 0; eventListenerArray != null && i < eventListenerArray.length; ++i) {
            EventListener eventListener = this._eventListeners[i];
            if (eventListener instanceof ServletContextListener) {
                this._contextListeners = LazyList.add(this._contextListeners, eventListener);
            }
            if (eventListener instanceof ServletContextAttributeListener) {
                this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, eventListener);
            }
            if (eventListener instanceof ServletRequestListener) {
                this._requestListeners = LazyList.add(this._requestListeners, eventListener);
            }
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, eventListener);
        }
    }

    public void addEventListener(EventListener eventListener) {
        this.setEventListeners((EventListener[])LazyList.addToArray(this.getEventListeners(), eventListener, EventListener.class));
    }

    public boolean isShutdown() {
        return !this._shutdown;
    }

    @Override
    public void setShutdown(boolean bl) {
        this._shutdown = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        if (this._contextPath == null) {
            throw new IllegalStateException("Null contextPath");
        }
        this._logger = Log.getLogger(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName());
        ClassLoader classLoader = null;
        Thread thread = null;
        SContext sContext = null;
        this._contextAttributes = new AttributesMap();
        try {
            if (this._classLoader != null) {
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._classLoader);
            }
            if (this._mimeTypes == null) {
                this._mimeTypes = new MimeTypes();
            }
            sContext = (SContext)__context.get();
            __context.set(this._scontext);
            if (this._errorHandler == null) {
                this.setErrorHandler(new ErrorHandler());
            }
            this.startContext();
        }
        finally {
            __context.set(sContext);
            if (this._classLoader != null) {
                thread.setContextClassLoader(classLoader);
            }
        }
    }

    protected void startContext() throws Exception {
        Object object;
        super.doStart();
        if (this._errorHandler != null) {
            this._errorHandler.start();
        }
        if (this._contextListeners != null) {
            object = new ServletContextEvent((ServletContext)this._scontext);
            for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized((ServletContextEvent)object);
            }
        }
        if ((object = (String)this._initParams.get(MANAGED_ATTRIBUTES)) != null) {
            this._managedAttributes = new HashSet();
            String[] stringArray = ((String)object).toString().split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                this._managedAttributes.add(stringArray[i]);
            }
            Enumeration enumeration = this._scontext.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object2 = this._scontext.getAttribute(string);
                this.setManagedAttribute(string, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        ClassLoader classLoader = null;
        Thread thread = null;
        SContext sContext = (SContext)__context.get();
        __context.set(this._scontext);
        try {
            Object object;
            if (this._classLoader != null) {
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._classLoader);
            }
            super.doStop();
            if (this._contextListeners != null) {
                object = new ServletContextEvent((ServletContext)this._scontext);
                int n = LazyList.size(this._contextListeners);
                while (n-- > 0) {
                    ((ServletContextListener)LazyList.get(this._contextListeners, n)).contextDestroyed((ServletContextEvent)object);
                }
            }
            if (this._errorHandler != null) {
                this._errorHandler.stop();
            }
            object = this._scontext.getAttributeNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.setManagedAttribute(string, null);
            }
        }
        finally {
            __context.set(sContext);
            if (this._classLoader != null) {
                thread.setContextClassLoader(classLoader);
            }
        }
        if (this._contextAttributes != null) {
            this._contextAttributes.clearAttributes();
        }
        this._contextAttributes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        int n2;
        int n3;
        String string2;
        Request request;
        boolean bl = false;
        SContext sContext = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ClassLoader classLoader = null;
        Thread thread = null;
        Request request2 = request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
        if (!this.isStarted() || this._shutdown || n == 1 && request.isHandled()) {
            return;
        }
        sContext = request.getContext();
        if (sContext != this._scontext) {
            bl = true;
            if (this._vhosts != null && this._vhosts.length > 0) {
                string2 = this.normalizeHostname(httpServletRequest.getServerName());
                n3 = 0;
                for (n2 = 0; n3 == 0 && n2 < this._vhosts.length; ++n2) {
                    String string6 = this._vhosts[n2];
                    if (string6 == null) continue;
                    n3 = string6.startsWith("*.") ? (int)(string6.regionMatches(true, 2, string2, string2.indexOf(".") + 1, string6.length() - 2) ? 1 : 0) : (int)(string6.equalsIgnoreCase(string2) ? 1 : 0);
                }
                if (n3 == 0) {
                    return;
                }
            }
            if (!(this._connectors == null || this._connectors.size() <= 0 || (string2 = HttpConnection.getCurrentConnection().getConnector().getName()) != null && this._connectors.contains(string2))) {
                return;
            }
            if (n == 1) {
                if (this._compactPath) {
                    string = URIUtil.compactPath(string);
                }
                if (string.equals(this._contextPath)) {
                    if (!this._allowNullPathInfo && !string.endsWith("/")) {
                        request.setHandled(true);
                        if (httpServletRequest.getQueryString() != null) {
                            httpServletResponse.sendRedirect(URIUtil.addPaths(httpServletRequest.getRequestURI(), "/") + "?" + httpServletRequest.getQueryString());
                        } else {
                            httpServletResponse.sendRedirect(URIUtil.addPaths(httpServletRequest.getRequestURI(), "/"));
                        }
                        return;
                    }
                    if (this._contextPath.length() > 1) {
                        string = "/";
                        httpServletRequest.setAttribute("org.mortbay.jetty.nullPathInfo", (Object)string);
                    }
                } else if (string.startsWith(this._contextPath) && (this._contextPath.length() == 1 || string.charAt(this._contextPath.length()) == '/')) {
                    if (this._contextPath.length() > 1) {
                        string = string.substring(this._contextPath.length());
                    }
                } else {
                    return;
                }
            }
        }
        try {
            block38: {
                string3 = request.getContextPath();
                string4 = request.getServletPath();
                string5 = request.getPathInfo();
                request.setContext(this._scontext);
                if (n != 4 && string.startsWith("/")) {
                    if (this._contextPath.length() == 1) {
                        request.setContextPath("");
                    } else {
                        request.setContextPath(this._contextPath);
                    }
                    request.setServletPath(null);
                    request.setPathInfo(string);
                }
                string2 = null;
                if (bl) {
                    if (this._classLoader != null) {
                        thread = Thread.currentThread();
                        classLoader = thread.getContextClassLoader();
                        thread.setContextClassLoader(this._classLoader);
                    }
                    request.setRequestListeners(this._requestListeners);
                    if (this._requestAttributeListeners != null) {
                        n3 = LazyList.size(this._requestAttributeListeners);
                        for (n2 = 0; n2 < n3; ++n2) {
                            request.addEventListener((EventListener)LazyList.get(this._requestAttributeListeners, n2));
                        }
                    }
                }
                try {
                    if (n == 1 && this.isProtectedTarget(string)) {
                        throw new HttpException(404);
                    }
                    Handler handler = this.getHandler();
                    if (handler != null) {
                        handler.handle(string, httpServletRequest, httpServletResponse, n);
                    }
                }
                catch (HttpException httpException) {
                    Log.debug(httpException);
                    httpServletResponse.sendError(httpException.getStatus(), httpException.getReason());
                }
                finally {
                    if (!bl) break block38;
                    request.takeRequestListeners();
                    if (this._requestAttributeListeners == null) break block38;
                    int n4 = LazyList.size(this._requestAttributeListeners);
                    while (n4-- > 0) {
                        request.removeEventListener((EventListener)LazyList.get(this._requestAttributeListeners, n4));
                    }
                }
            }
            if (sContext != this._scontext) {
                if (this._classLoader != null) {
                    thread.setContextClassLoader(classLoader);
                }
                request.setContext(sContext);
                request.setContextPath(string3);
                request.setServletPath(string4);
                request.setPathInfo(string5);
            }
        }
        catch (Throwable throwable) {
            if (sContext != this._scontext) {
                if (this._classLoader != null) {
                    thread.setContextClassLoader(classLoader);
                }
                request.setContext(sContext);
                request.setContextPath(string3);
                request.setServletPath(string4);
                request.setPathInfo(string5);
            }
            throw throwable;
        }
    }

    protected boolean isProtectedTarget(String string) {
        return false;
    }

    @Override
    public void removeAttribute(String string) {
        this.setManagedAttribute(string, null);
        this._attributes.removeAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.setManagedAttribute(string, object);
        this._attributes.setAttribute(string, object);
    }

    public void setAttributes(Attributes attributes) {
        if (attributes instanceof AttributesMap) {
            this._attributes = (AttributesMap)attributes;
            Enumeration enumeration = this._attributes.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.setManagedAttribute(string, attributes.getAttribute(string));
            }
        } else {
            this._attributes = new AttributesMap();
            Enumeration enumeration = attributes.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = attributes.getAttribute(string);
                this.setManagedAttribute(string, object);
                this._attributes.setAttribute(string, object);
            }
        }
    }

    @Override
    public void clearAttributes() {
        Enumeration enumeration = this._attributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setManagedAttribute(string, null);
        }
        this._attributes.clearAttributes();
    }

    private void setManagedAttribute(String string, Object object) {
        if (this._managedAttributes != null && this._managedAttributes.contains(string)) {
            Object object2 = this._scontext.getAttribute(string);
            if (object2 != null) {
                this.getServer().getContainer().removeBean(object2);
            }
            if (object != null) {
                this.getServer().getContainer().addBean(object);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String string) {
        if (string != null && string.length() > 1 && string.endsWith("/")) {
            throw new IllegalArgumentException("ends with /");
        }
        this._contextPath = string;
        if (this.getServer() != null && (this.getServer().isStarting() || this.getServer().isStarted())) {
            Handler[] handlerArray = this.getServer().getChildHandlersByClass(ContextHandlerCollection.class);
            for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
                ((ContextHandlerCollection)handlerArray[i]).mapContexts();
            }
        }
    }

    public void setInitParams(Map map) {
        if (map == null) {
            return;
        }
        this._initParams = new HashMap(map);
    }

    public void setDisplayName(String string) {
        this._displayName = string;
        if (this._classLoader != null && this._classLoader instanceof WebAppClassLoader) {
            ((WebAppClassLoader)this._classLoader).setName(string);
        }
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource resource) {
        this._baseResource = resource;
    }

    public void setResourceBase(String string) {
        try {
            this.setBaseResource(Resource.newResource(string));
        }
        catch (Exception exception) {
            Log.warn(exception.toString());
            Log.debug(exception);
            throw new IllegalArgumentException(string);
        }
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(String[] stringArray) {
        this._welcomeFiles = stringArray;
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            errorHandler.setServer(this.getServer());
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._errorHandler, errorHandler, "errorHandler", true);
        }
        this._errorHandler = errorHandler;
    }

    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    public void setMaxFormContentSize(int n) {
        this._maxFormContentSize = n;
    }

    public boolean isCompactPath() {
        return this._compactPath;
    }

    public void setCompactPath(boolean bl) {
        this._compactPath = bl;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + this.getBaseResource() + "}";
    }

    public synchronized Class loadClass(String string) throws ClassNotFoundException {
        if (string == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass(this.getClass(), string);
        }
        return this._classLoader.loadClass(string);
    }

    public void addLocaleEncoding(String string, String string2) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap();
        }
        this._localeEncodingMap.put(string, string2);
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String string = (String)this._localeEncodingMap.get(locale.toString());
        if (string == null) {
            string = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return string;
    }

    public Resource getResource(String string) throws MalformedURLException {
        if (string == null || !string.startsWith("/")) {
            throw new MalformedURLException(string);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            string = URIUtil.canonicalPath(string);
            Resource resource = this._baseResource.addPath(string);
            return resource;
        }
        catch (Exception exception) {
            Log.ignore(exception);
            return null;
        }
    }

    public Set getResourcePaths(String string) {
        try {
            string = URIUtil.canonicalPath(string);
            Resource resource = this.getResource(string);
            if (resource != null && resource.exists()) {
                String[] stringArray;
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                if ((stringArray = resource.list()) != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        hashSet.add(string + stringArray[i]);
                    }
                    return hashSet;
                }
            }
        }
        catch (Exception exception) {
            Log.ignore(exception);
        }
        return Collections.EMPTY_SET;
    }

    private String normalizeHostname(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public class SContext
    implements ServletContext {
        protected SContext() {
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        public ServletContext getContext(String string) {
            ContextHandler contextHandler = null;
            Handler[] handlerArray = ContextHandler.this.getServer().getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; i < handlerArray.length; ++i) {
                ContextHandler contextHandler2;
                String string2;
                if (handlerArray[i] == null || !handlerArray[i].isStarted() || !string.equals(string2 = (contextHandler2 = (ContextHandler)handlerArray[i]).getContextPath()) && (!string.startsWith(string2) || string.charAt(string2.length()) != '/') || contextHandler != null && string2.length() <= contextHandler.getContextPath().length()) continue;
                contextHandler = contextHandler2;
            }
            if (contextHandler != null) {
                return contextHandler._scontext;
            }
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public String getMimeType(String string) {
            if (ContextHandler.this._mimeTypes == null) {
                return null;
            }
            Buffer buffer = ContextHandler.this._mimeTypes.getMimeByExtension(string);
            if (buffer != null) {
                return buffer.toString();
            }
            return null;
        }

        public int getMinorVersion() {
            return 5;
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            return null;
        }

        public String getRealPath(String string) {
            if (string == null) {
                return null;
            }
            if (string.length() == 0) {
                string = "/";
            } else if (string.charAt(0) != '/') {
                string = "/" + string;
            }
            try {
                File file;
                Resource resource = ContextHandler.this.getResource(string);
                if (resource != null && (file = resource.getFile()) != null) {
                    return file.getCanonicalPath();
                }
            }
            catch (Exception exception) {
                Log.ignore(exception);
            }
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return null;
        }

        public URL getResource(String string) throws MalformedURLException {
            Resource resource = ContextHandler.this.getResource(string);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
            return null;
        }

        public InputStream getResourceAsStream(String string) {
            try {
                URL uRL = this.getResource(string);
                if (uRL == null) {
                    return null;
                }
                return uRL.openStream();
            }
            catch (Exception exception) {
                Log.ignore(exception);
                return null;
            }
        }

        public Set getResourcePaths(String string) {
            return ContextHandler.this.getResourcePaths(string);
        }

        public String getServerInfo() {
            return "jetty/" + Server.getVersion();
        }

        public Servlet getServlet(String string) throws ServletException {
            return null;
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(Exception exception, String string) {
            ContextHandler.this._logger.warn(string, exception);
        }

        public void log(String string) {
            ContextHandler.this._logger.info(string, null, null);
        }

        public void log(String string, Throwable throwable) {
            ContextHandler.this._logger.warn(string, throwable);
        }

        public String getInitParameter(String string) {
            return ContextHandler.this.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        public synchronized Object getAttribute(String string) {
            Object object = ContextHandler.this.getAttribute(string);
            if (object == null && ContextHandler.this._contextAttributes != null) {
                object = ContextHandler.this._contextAttributes.getAttribute(string);
            }
            return object;
        }

        public synchronized Enumeration getAttributeNames() {
            Enumeration enumeration;
            HashSet hashSet = new HashSet();
            if (ContextHandler.this._contextAttributes != null) {
                enumeration = ContextHandler.this._contextAttributes.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
            }
            enumeration = ContextHandler.this._attributes.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            return Collections.enumeration(hashSet);
        }

        public synchronized void setAttribute(String string, Object object) {
            Object object2;
            if (ContextHandler.this._contextAttributes == null) {
                ContextHandler.this.setAttribute(string, object);
                return;
            }
            ContextHandler.this.setManagedAttribute(string, object);
            Object object3 = object2 = ContextHandler.this._contextAttributes == null ? null : ContextHandler.this._contextAttributes.getAttribute(string);
            if (object == null) {
                ContextHandler.this._contextAttributes.removeAttribute(string);
            } else {
                ContextHandler.this._contextAttributes.setAttribute(string, object);
            }
            if (ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._scontext, string, object2 == null ? object : object2);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i);
                    if (object2 == null) {
                        servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                        continue;
                    }
                    if (object == null) {
                        servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
                        continue;
                    }
                    servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
                }
            }
        }

        public synchronized void removeAttribute(String string) {
            ContextHandler.this.setManagedAttribute(string, null);
            if (ContextHandler.this._contextAttributes == null) {
                ContextHandler.this._attributes.removeAttribute(string);
                return;
            }
            Object object = ContextHandler.this._contextAttributes.getAttribute(string);
            ContextHandler.this._contextAttributes.removeAttribute(string);
            if (object != null && ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._scontext, string, object);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ((ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i)).attributeRemoved(servletContextAttributeEvent);
                }
            }
        }

        public String getServletContextName() {
            String string = ContextHandler.this.getDisplayName();
            if (string == null) {
                string = ContextHandler.this.getContextPath();
            }
            return string;
        }

        public String getContextPath() {
            if (ContextHandler.this._contextPath != null && ContextHandler.this._contextPath.equals("/")) {
                return "";
            }
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "ServletContext@" + Integer.toHexString(this.hashCode()) + "{" + (this.getContextPath().equals("") ? "/" : this.getContextPath()) + "," + ContextHandler.this.getBaseResource() + "}";
        }
    }
}

