/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class ContextHandlerCollection
extends HandlerCollection {
    private PathMap _contextMap;
    private Class _contextClass = ContextHandler.class;

    public void mapContexts() {
        PathMap pathMap = new PathMap();
        Handler[] handlerArray = this.getHandlers();
        for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
            Handler[] handlerArray2 = null;
            if (handlerArray[i] instanceof ContextHandler) {
                handlerArray2 = new Handler[]{handlerArray[i]};
            } else {
                if (!(handlerArray[i] instanceof HandlerContainer)) continue;
                handlerArray2 = ((HandlerContainer)((Object)handlerArray[i])).getChildHandlersByClass(ContextHandler.class);
            }
            for (int j = 0; j < handlerArray2.length; ++j) {
                HashMap hashMap;
                ContextHandler contextHandler = (ContextHandler)handlerArray2[j];
                String string = contextHandler.getContextPath();
                if (string == null || string.indexOf(44) >= 0 || string.startsWith("*")) {
                    throw new IllegalArgumentException("Illegal context spec:" + string);
                }
                if (!string.startsWith("/")) {
                    string = '/' + string;
                }
                if (string.length() > 1) {
                    if (string.endsWith("/")) {
                        string = string + "*";
                    } else if (!string.endsWith("/*")) {
                        string = string + "/*";
                    }
                }
                Object object = pathMap.get(string);
                String[] stringArray = contextHandler.getVirtualHosts();
                if (stringArray != null && stringArray.length > 0) {
                    if (object instanceof Map) {
                        hashMap = (Map)object;
                    } else {
                        hashMap = new HashMap();
                        hashMap.put("*", object);
                        pathMap.put(string, hashMap);
                    }
                    for (int k = 0; k < stringArray.length; ++k) {
                        String string2 = stringArray[k];
                        object = hashMap.get(string2);
                        object = LazyList.add(object, handlerArray[i]);
                        hashMap.put(string2, object);
                    }
                    continue;
                }
                if (object instanceof Map) {
                    hashMap = (HashMap)object;
                    object = hashMap.get("*");
                    object = LazyList.add(object, handlerArray[i]);
                    hashMap.put("*", object);
                    continue;
                }
                object = LazyList.add(object, handlerArray[i]);
                pathMap.put(string, object);
            }
        }
        this._contextMap = pathMap;
    }

    @Override
    public void setHandlers(Handler[] handlerArray) {
        this._contextMap = null;
        super.setHandlers(handlerArray);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        Handler[] handlerArray = this.getHandlers();
        if (handlerArray == null || handlerArray.length == 0) {
            return;
        }
        Request request = HttpConnection.getCurrentConnection().getRequest();
        PathMap pathMap = this._contextMap;
        if (pathMap != null && string != null && string.startsWith("/")) {
            Object object = pathMap.getLazyMatches(string);
            for (int i = 0; i < LazyList.size(object); ++i) {
                Object object2;
                Map.Entry entry = (Map.Entry)LazyList.get(object, i);
                Object v = entry.getValue();
                if (v instanceof Map) {
                    Handler handler;
                    int n2;
                    Map map = (Map)v;
                    object2 = this.normalizeHostname(httpServletRequest.getServerName());
                    v = map.get(object2);
                    for (n2 = 0; n2 < LazyList.size(v); ++n2) {
                        handler = (Handler)LazyList.get(v, n2);
                        handler.handle(string, httpServletRequest, httpServletResponse, n);
                        if (!request.isHandled()) continue;
                        return;
                    }
                    v = map.get("*." + ((String)object2).substring(((String)object2).indexOf(".") + 1));
                    for (n2 = 0; n2 < LazyList.size(v); ++n2) {
                        handler = (Handler)LazyList.get(v, n2);
                        handler.handle(string, httpServletRequest, httpServletResponse, n);
                        if (!request.isHandled()) continue;
                        return;
                    }
                    v = map.get("*");
                    for (n2 = 0; n2 < LazyList.size(v); ++n2) {
                        handler = (Handler)LazyList.get(v, n2);
                        handler.handle(string, httpServletRequest, httpServletResponse, n);
                        if (!request.isHandled()) continue;
                        return;
                    }
                    continue;
                }
                for (int j = 0; j < LazyList.size(v); ++j) {
                    object2 = (Handler)LazyList.get(v, j);
                    object2.handle(string, httpServletRequest, httpServletResponse, n);
                    if (!request.isHandled()) continue;
                    return;
                }
            }
        } else {
            for (int i = 0; i < handlerArray.length; ++i) {
                handlerArray[i].handle(string, httpServletRequest, httpServletResponse, n);
                if (!request.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String string, String string2) {
        try {
            ContextHandler contextHandler = (ContextHandler)this._contextClass.newInstance();
            contextHandler.setContextPath(string);
            contextHandler.setResourceBase(string2);
            this.addHandler(contextHandler);
            return contextHandler;
        }
        catch (Exception exception) {
            Log.debug(exception);
            throw new Error(exception);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class clazz) {
        if (clazz == null || !ContextHandler.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = clazz;
    }

    private String normalizeHostname(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

