/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.util.DateCache;
import org.mortbay.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        int n2;
        String string2;
        Request request = (Request)httpServletRequest;
        Response response = (Response)httpServletResponse;
        Thread thread = Thread.currentThread();
        String string3 = thread.getName();
        boolean bl = false;
        boolean bl2 = false;
        String string4 = (String)httpServletRequest.getAttribute("org.mortbay.jetty.thread.name");
        if (string4 == null) {
            string4 = string3 + "://" + request.getHeader("Host") + request.getUri();
        } else {
            bl2 = true;
        }
        String string5 = null;
        try {
            string2 = this._date.now();
            n2 = this._date.lastMs();
            if (bl2) {
                this._print.println(string2 + (n2 > 99 ? "." : (n2 > 9 ? ".0" : ".00")) + n2 + ":" + string4 + " RETRY");
            } else {
                this._print.println(string2 + (n2 > 99 ? "." : (n2 > 9 ? ".0" : ".00")) + n2 + ":" + string4 + " " + request.getRemoteAddr() + " " + httpServletRequest.getMethod() + " " + request.getHeader("Cookie") + "; " + request.getHeader("User-Agent"));
            }
            thread.setName(string4);
            super.handle(string, httpServletRequest, httpServletResponse, n);
        }
        catch (RetryRequest retryRequest) {
            try {
                bl = true;
                httpServletRequest.setAttribute("org.mortbay.jetty.thread.name", (Object)string4);
                throw retryRequest;
                catch (IOException iOException) {
                    string5 = iOException.toString();
                    throw iOException;
                }
                catch (ServletException servletException) {
                    string5 = servletException.toString() + ":" + servletException.getCause();
                    throw servletException;
                }
                catch (RuntimeException runtimeException) {
                    string5 = runtimeException.toString();
                    throw runtimeException;
                }
                catch (Error error) {
                    string5 = error.toString();
                    throw error;
                }
            }
            catch (Throwable throwable) {
                thread.setName(string3);
                String string6 = this._date.now();
                int n3 = this._date.lastMs();
                if (bl) {
                    this._print.println(string6 + (n3 > 99 ? "." : (n3 > 9 ? ".0" : ".00")) + n3 + ":" + string4 + " SUSPEND");
                    throw throwable;
                }
                this._print.println(string6 + (n3 > 99 ? "." : (n3 > 9 ? ".0" : ".00")) + n3 + ":" + string4 + " " + response.getStatus() + " " + response.getContentType() + " " + response.getContentCount() + (string5 == null ? "" : "/" + string5));
                throw throwable;
            }
        }
        thread.setName(string3);
        string2 = this._date.now();
        n2 = this._date.lastMs();
        if (bl) {
            this._print.println(string2 + (n2 > 99 ? "." : (n2 > 9 ? ".0" : ".00")) + n2 + ":" + string4 + " SUSPEND");
            return;
        }
        this._print.println(string2 + (n2 > 99 ? "." : (n2 > 9 ? ".0" : ".00")) + n2 + ":" + string4 + " " + response.getStatus() + " " + response.getContentType() + " " + response.getContentCount() + (string5 == null ? "" : "/" + string5));
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._out = outputStream;
    }
}

