/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.log.Log;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.IO;
import org.mortbay.util.StringUtil;

public class DefaultHandler
extends AbstractHandler {
    long _faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    byte[] _favicon;
    boolean _serveIcon = true;

    public DefaultHandler() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource("org/mortbay/jetty/favicon.ico");
            if (uRL != null) {
                this._favicon = IO.readBytes(uRL.openStream());
            }
        }
        catch (Exception exception) {
            Log.warn(exception);
        }
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        int n2;
        Request request;
        Request request2 = request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
        if (httpServletResponse.isCommitted() || request.isHandled()) {
            return;
        }
        request.setHandled(true);
        String string2 = httpServletRequest.getMethod();
        if (this._serveIcon && this._favicon != null && string2.equals("GET") && httpServletRequest.getRequestURI().equals("/favicon.ico")) {
            if (httpServletRequest.getDateHeader("If-Modified-Since") == this._faviconModified) {
                httpServletResponse.setStatus(304);
            } else {
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType("image/x-icon");
                httpServletResponse.setContentLength(this._favicon.length);
                httpServletResponse.setDateHeader("Last-Modified", this._faviconModified);
                httpServletResponse.getOutputStream().write(this._favicon);
            }
            return;
        }
        if (!string2.equals("GET") || !httpServletRequest.getRequestURI().equals("/")) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer(1500);
        String string3 = httpServletRequest.getRequestURI();
        string3 = StringUtil.replace(string3, "<", "&lt;");
        string3 = StringUtil.replace(string3, ">", "&gt;");
        byteArrayISO8859Writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        byteArrayISO8859Writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        byteArrayISO8859Writer.write("No context on this server matched or handled this request.<BR>");
        byteArrayISO8859Writer.write("Contexts known to this server are: <ul>");
        Server server = this.getServer();
        Handler[] handlerArray = server == null ? null : server.getChildHandlersByClass(ContextHandler.class);
        for (n2 = 0; handlerArray != null && n2 < handlerArray.length; ++n2) {
            ContextHandler contextHandler = (ContextHandler)handlerArray[n2];
            if (contextHandler.isRunning()) {
                byteArrayISO8859Writer.write("<li><a href=\"");
                if (contextHandler.getVirtualHosts() != null && contextHandler.getVirtualHosts().length > 0) {
                    byteArrayISO8859Writer.write("http://" + contextHandler.getVirtualHosts()[0] + ":" + httpServletRequest.getLocalPort());
                }
                byteArrayISO8859Writer.write(contextHandler.getContextPath());
                if (contextHandler.getContextPath().length() > 1 && contextHandler.getContextPath().endsWith("/")) {
                    byteArrayISO8859Writer.write("/");
                }
                byteArrayISO8859Writer.write("\">");
                byteArrayISO8859Writer.write(contextHandler.getContextPath());
                if (contextHandler.getVirtualHosts() != null && contextHandler.getVirtualHosts().length > 0) {
                    byteArrayISO8859Writer.write("&nbsp;@&nbsp;" + contextHandler.getVirtualHosts()[0] + ":" + httpServletRequest.getLocalPort());
                }
                byteArrayISO8859Writer.write("&nbsp;--->&nbsp;");
                byteArrayISO8859Writer.write(contextHandler.toString());
                byteArrayISO8859Writer.write("</a></li>\n");
                continue;
            }
            byteArrayISO8859Writer.write("<li>");
            byteArrayISO8859Writer.write(contextHandler.getContextPath());
            if (contextHandler.getVirtualHosts() != null && contextHandler.getVirtualHosts().length > 0) {
                byteArrayISO8859Writer.write("&nbsp;@&nbsp;" + contextHandler.getVirtualHosts()[0] + ":" + httpServletRequest.getLocalPort());
            }
            byteArrayISO8859Writer.write("&nbsp;--->&nbsp;");
            byteArrayISO8859Writer.write(contextHandler.toString());
            if (contextHandler.isFailed()) {
                byteArrayISO8859Writer.write(" [failed]");
            }
            if (contextHandler.isStopped()) {
                byteArrayISO8859Writer.write(" [stopped]");
            }
            byteArrayISO8859Writer.write("</li>\n");
        }
        for (n2 = 0; n2 < 10; ++n2) {
            byteArrayISO8859Writer.write("\n<!-- Padding for IE                  -->");
        }
        byteArrayISO8859Writer.write("\n</BODY>\n</HTML>\n");
        byteArrayISO8859Writer.flush();
        httpServletResponse.setContentLength(byteArrayISO8859Writer.size());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byteArrayISO8859Writer.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.close();
    }

    public boolean getServeIcon() {
        return this._serveIcon;
    }

    public void setServeIcon(boolean bl) {
        this._serveIcon = bl;
    }
}

