/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.util.ByteArrayISO8859Writer;

public class ErrorHandler
extends AbstractHandler {
    boolean _showStacks = true;

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException {
        HttpConnection httpConnection = HttpConnection.getCurrentConnection();
        httpConnection.getRequest().setHandled(true);
        String string2 = httpServletRequest.getMethod();
        if (!(string2.equals("GET") || string2.equals("POST") || string2.equals("HEAD"))) {
            return;
        }
        httpServletResponse.setContentType("text/html; charset=iso-8859-1");
        httpServletResponse.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer(4096);
        this.handleErrorPage(httpServletRequest, byteArrayISO8859Writer, httpConnection.getResponse().getStatus(), httpConnection.getResponse().getReason());
        byteArrayISO8859Writer.flush();
        httpServletResponse.setContentLength(byteArrayISO8859Writer.size());
        byteArrayISO8859Writer.writeTo((OutputStream)httpServletResponse.getOutputStream());
        byteArrayISO8859Writer.destroy();
    }

    protected void handleErrorPage(HttpServletRequest httpServletRequest, Writer writer, int n, String string) throws IOException {
        this.writeErrorPage(httpServletRequest, writer, n, string, this._showStacks);
    }

    protected void writeErrorPage(HttpServletRequest httpServletRequest, Writer writer, int n, String string, boolean bl) throws IOException {
        if (string == null) {
            string = HttpGenerator.getReason(n);
        }
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(httpServletRequest, writer, n, string);
        writer.write("</head>\n<body>");
        this.writeErrorPageBody(httpServletRequest, writer, n, string, bl);
        writer.write("\n</body>\n</html>\n");
    }

    protected void writeErrorPageHead(HttpServletRequest httpServletRequest, Writer writer, int n, String string) throws IOException {
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\"/>\n");
        writer.write("<title>Error ");
        writer.write(Integer.toString(n));
        writer.write(32);
        this.write(writer, string);
        writer.write("</title>\n");
    }

    protected void writeErrorPageBody(HttpServletRequest httpServletRequest, Writer writer, int n, String string, boolean bl) throws IOException {
        String string2 = httpServletRequest.getRequestURI();
        this.writeErrorPageMessage(httpServletRequest, writer, n, string, string2);
        if (bl) {
            this.writeErrorPageStacks(httpServletRequest, writer);
        }
        writer.write("<hr /><i><small>Powered by Jetty://</small></i>");
        for (int i = 0; i < 20; ++i) {
            writer.write("<br/>                                                \n");
        }
    }

    protected void writeErrorPageMessage(HttpServletRequest httpServletRequest, Writer writer, int n, String string, String string2) throws IOException {
        writer.write("<h2>HTTP ERROR ");
        writer.write(Integer.toString(n));
        writer.write("</h2>\n<p>Problem accessing ");
        this.write(writer, string2);
        writer.write(". Reason:\n<pre>    ");
        this.write(writer, string);
        writer.write("</pre></p>");
    }

    protected void writeErrorPageStacks(HttpServletRequest httpServletRequest, Writer writer) throws IOException {
        for (Throwable throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception"); throwable != null; throwable = throwable.getCause()) {
            writer.write("<h3>Caused by:</h3><pre>");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            this.write(writer, stringWriter.getBuffer().toString());
            writer.write("</pre>\n");
        }
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean bl) {
        this._showStacks = bl;
    }

    protected void write(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    continue block5;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block5;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block5;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        writer.write(63);
                        continue block5;
                    }
                    writer.write(c);
                }
            }
        }
    }
}

