/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

public class HandlerCollection
extends AbstractHandlerContainer {
    private Handler[] _handlers;

    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlerArray) {
        int n;
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this._handlers == null ? null : (Handler[])this._handlers.clone();
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, objectArray, handlerArray, "handler");
        }
        Server server = this.getServer();
        MultiException multiException = new MultiException();
        for (n = 0; handlerArray != null && n < handlerArray.length; ++n) {
            if (handlerArray[n].getServer() == server) continue;
            handlerArray[n].setServer(server);
        }
        this._handlers = handlerArray;
        for (n = 0; objectArray != null && n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            try {
                if (!objectArray[n].isStarted()) continue;
                objectArray[n].stop();
                continue;
            }
            catch (Throwable throwable) {
                multiException.add(throwable);
            }
        }
        multiException.ifExceptionThrowRuntime();
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            MultiException multiException = null;
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].handle(string, httpServletRequest, httpServletResponse, n);
                    continue;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    if (multiException == null) {
                        multiException = new MultiException();
                    }
                    multiException.add(exception);
                }
            }
            if (multiException != null) {
                if (multiException.size() == 1) {
                    throw new ServletException(multiException.getThrowable(0));
                }
                throw new ServletException((Throwable)multiException);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        MultiException multiException = new MultiException();
        if (this._handlers != null) {
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].start();
                    continue;
                }
                catch (Throwable throwable) {
                    multiException.add(throwable);
                }
            }
        }
        super.doStart();
        multiException.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException multiException = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable throwable) {
            multiException.add(throwable);
        }
        if (this._handlers != null) {
            int n = this._handlers.length;
            while (n-- > 0) {
                try {
                    this._handlers[n].stop();
                }
                catch (Throwable throwable) {
                    multiException.add(throwable);
                }
            }
        }
        multiException.ifExceptionThrow();
    }

    @Override
    public void setServer(Server server) {
        Server server2 = this.getServer();
        super.setServer(server);
        Handler[] handlerArray = this.getHandlers();
        for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
            handlerArray[i].setServer(server);
        }
        if (server != null && server != server2) {
            server.getContainer().update((Object)this, null, this._handlers, "handler");
        }
    }

    @Override
    public void addHandler(Handler handler) {
        this.setHandlers((Handler[])LazyList.addToArray(this.getHandlers(), handler, Handler.class));
    }

    @Override
    public void removeHandler(Handler handler) {
        Object[] objectArray = this.getHandlers();
        if (objectArray != null && objectArray.length > 0) {
            this.setHandlers((Handler[])LazyList.removeFromArray(objectArray, handler));
        }
    }

    @Override
    protected Object expandChildren(Object object, Class clazz) {
        Handler[] handlerArray = this.getHandlers();
        for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
            object = this.expandHandler(handlerArray[i], object, clazz);
        }
        return object;
    }
}

