/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandlerContainer;

public class HandlerWrapper
extends AbstractHandlerContainer {
    private Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        try {
            Handler handler2 = this._handler;
            if (this.getServer() != null) {
                this.getServer().getContainer().update((Object)this, handler2, handler, "handler");
            }
            if (handler != null) {
                handler.setServer(this.getServer());
            }
            this._handler = handler;
            if (handler2 != null && handler2.isStarted()) {
                handler2.stop();
            }
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    @Override
    public void addHandler(Handler handler) {
        Handler handler2 = this.getHandler();
        if (handler2 != null && !(handler instanceof HandlerContainer)) {
            throw new IllegalArgumentException("Cannot add");
        }
        this.setHandler(handler);
        if (handler2 != null) {
            ((HandlerContainer)((Object)handler)).addHandler(handler2);
        }
    }

    @Override
    public void removeHandler(Handler handler) {
        Handler handler2 = this.getHandler();
        if (handler2 != null && handler2 instanceof HandlerContainer) {
            ((HandlerContainer)((Object)handler2)).removeHandler(handler);
        } else if (handler2 != null && handler.equals(handler2)) {
            this.setHandler(null);
        } else {
            throw new IllegalStateException("Cannot remove");
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this._handler != null) {
            this._handler.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(string, httpServletRequest, httpServletResponse, n);
        }
    }

    @Override
    public void setServer(Server server) {
        Server server2 = this.getServer();
        super.setServer(server);
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.setServer(server);
        }
        if (server != null && server != server2) {
            server.getContainer().update((Object)this, null, this._handler, "handler");
        }
    }

    @Override
    protected Object expandChildren(Object object, Class clazz) {
        return this.expandHandler(this._handler, object, clazz);
    }
}

