/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.URIUtil;

public class MovedContextHandler
extends ContextHandler {
    String _newContextURL;
    boolean _discardPathInfo;
    boolean _discardQuery;
    boolean _permanent;
    Redirector _redirector;

    public MovedContextHandler() {
        this._redirector = new Redirector();
        this.addHandler(this._redirector);
    }

    public MovedContextHandler(HandlerContainer handlerContainer, String string, String string2) {
        super(handlerContainer, string);
        this._newContextURL = string2;
        this._redirector = new Redirector();
        this.addHandler(this._redirector);
    }

    public boolean isDiscardPathInfo() {
        return this._discardPathInfo;
    }

    public void setDiscardPathInfo(boolean bl) {
        this._discardPathInfo = bl;
    }

    public String getNewContextURL() {
        return this._newContextURL;
    }

    public void setNewContextURL(String string) {
        this._newContextURL = string;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    public void setPermanent(boolean bl) {
        this._permanent = bl;
    }

    public boolean isDiscardQuery() {
        return this._discardQuery;
    }

    public void setDiscardQuery(boolean bl) {
        this._discardQuery = bl;
    }

    private class Redirector
    extends AbstractHandler {
        private Redirector() {
        }

        @Override
        public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
            if (MovedContextHandler.this._newContextURL == null) {
                return;
            }
            Request request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
            String string2 = MovedContextHandler.this._newContextURL;
            if (!MovedContextHandler.this._discardPathInfo && httpServletRequest.getPathInfo() != null) {
                string2 = URIUtil.addPaths(string2, httpServletRequest.getPathInfo());
            }
            if (!MovedContextHandler.this._discardQuery && httpServletRequest.getQueryString() != null) {
                string2 = string2 + "?" + httpServletRequest.getQueryString();
            }
            httpServletResponse.sendRedirect(string2);
            if (MovedContextHandler.this._permanent) {
                httpServletResponse.setStatus(301);
            }
            request.setHandled(true);
        }
    }
}

