/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.log.Log;
import org.mortbay.resource.FileResource;
import org.mortbay.resource.Resource;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;

public class ResourceHandler
extends AbstractHandler {
    ContextHandler _context;
    Resource _baseResource;
    String[] _welcomeFiles = new String[]{"index.html"};
    MimeTypes _mimeTypes = new MimeTypes();
    ByteArrayBuffer _cacheControl;
    boolean _aliases;

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public boolean isAliases() {
        return this._aliases;
    }

    public void setAliases(boolean bl) {
        this._aliases = bl;
    }

    @Override
    public void doStart() throws Exception {
        ContextHandler.SContext sContext = ContextHandler.getCurrentContext();
        ContextHandler contextHandler = this._context = sContext == null ? null : sContext.getContextHandler();
        if (!this._aliases && !FileResource.getCheckAliases()) {
            throw new IllegalStateException("Alias checking disabled");
        }
        super.doStart();
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource resource) {
        this._baseResource = resource;
    }

    public void setResourceBase(String string) {
        try {
            this.setBaseResource(Resource.newResource(string));
        }
        catch (Exception exception) {
            Log.warn(exception.toString());
            Log.debug(exception);
            throw new IllegalArgumentException(string);
        }
    }

    public String getCacheControl() {
        return this._cacheControl.toString();
    }

    public void setCacheControl(String string) {
        this._cacheControl = string == null ? null : new ByteArrayBuffer(string);
    }

    public Resource getResource(String string) throws MalformedURLException {
        if (string == null || !string.startsWith("/")) {
            throw new MalformedURLException(string);
        }
        Resource resource = this._baseResource;
        if (resource == null) {
            if (this._context == null) {
                return null;
            }
            resource = this._context.getBaseResource();
            if (resource == null) {
                return null;
            }
        }
        try {
            string = URIUtil.canonicalPath(string);
            Resource resource2 = resource.addPath(string);
            return resource2;
        }
        catch (Exception exception) {
            Log.ignore(exception);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest httpServletRequest) throws MalformedURLException {
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            return null;
        }
        return this.getResource(string);
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public void setWelcomeFiles(String[] stringArray) {
        this._welcomeFiles = stringArray;
    }

    protected Resource getWelcome(Resource resource) throws MalformedURLException, IOException {
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            Resource resource2 = resource.addPath(this._welcomeFiles[i]);
            if (!resource2.exists() || resource2.isDirectory()) continue;
            return resource2;
        }
        return null;
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        long l;
        long l2;
        Resource resource;
        Request request;
        Request request2 = request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
        if (request.isHandled()) {
            return;
        }
        boolean bl = false;
        if (!"GET".equals(httpServletRequest.getMethod())) {
            if (!"HEAD".equals(httpServletRequest.getMethod())) {
                return;
            }
            bl = true;
        }
        if ((resource = this.getResource(httpServletRequest)) == null || !resource.exists()) {
            return;
        }
        if (!this._aliases && resource.getAlias() != null) {
            Log.info(resource + " aliased to " + resource.getAlias());
            return;
        }
        request.setHandled(true);
        if (resource.isDirectory()) {
            if (!httpServletRequest.getPathInfo().endsWith("/")) {
                httpServletResponse.sendRedirect(URIUtil.addPaths(httpServletRequest.getRequestURI(), "/"));
                return;
            }
            if ((resource = this.getWelcome(resource)) == null || !resource.exists() || resource.isDirectory()) {
                httpServletResponse.sendError(403);
                return;
            }
        }
        if ((l2 = resource.lastModified()) > 0L && (l = httpServletRequest.getDateHeader("If-Modified-Since")) > 0L && l2 / 1000L <= l / 1000L) {
            httpServletResponse.setStatus(304);
            return;
        }
        Buffer buffer = this._mimeTypes.getMimeByExtension(resource.toString());
        if (buffer == null) {
            buffer = this._mimeTypes.getMimeByExtension(httpServletRequest.getPathInfo());
        }
        this.doResponseHeaders(httpServletResponse, resource, buffer != null ? buffer.toString() : null);
        httpServletResponse.setDateHeader("Last-Modified", l2);
        if (bl) {
            return;
        }
        Object object = null;
        try {
            object = httpServletResponse.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            object = new WriterOutputStream(httpServletResponse.getWriter());
        }
        if (object instanceof HttpConnection.Output) {
            ((HttpConnection.Output)((Object)object)).sendContent(resource.getInputStream());
        } else {
            resource.writeTo((OutputStream)object, 0L, resource.length());
        }
    }

    protected void doResponseHeaders(HttpServletResponse httpServletResponse, Resource resource, String string) {
        if (string != null) {
            httpServletResponse.setContentType(string);
        }
        long l = resource.length();
        if (httpServletResponse instanceof Response) {
            HttpFields httpFields = ((Response)httpServletResponse).getHttpFields();
            if (l > 0L) {
                httpFields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, l);
            }
            if (this._cacheControl != null) {
                httpFields.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
            }
        } else {
            if (l > 0L) {
                httpServletResponse.setHeader("Content-Length", TypeUtil.toString(l));
            }
            if (this._cacheControl != null) {
                httpServletResponse.setHeader("Cache-Control", this._cacheControl.toString());
            }
        }
    }
}

