/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.util.URIUtil;

public class RewriteHandler
extends HandlerWrapper {
    private boolean _rewriteRequestURI = true;
    private boolean _rewritePathInfo = true;
    private String _originalPathAttribute;
    private PathMap _rewrite = new PathMap(true);

    public boolean isRewriteRequestURI() {
        return this._rewriteRequestURI;
    }

    public void setRewriteRequestURI(boolean bl) {
        this._rewriteRequestURI = bl;
    }

    public boolean isRewritePathInfo() {
        return this._rewritePathInfo;
    }

    public void setRewritePathInfo(boolean bl) {
        this._rewritePathInfo = bl;
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String string) {
        this._originalPathAttribute = string;
    }

    public PathMap getRewrite() {
        return this._rewrite;
    }

    public void setRewrite(PathMap pathMap) {
        this._rewrite = pathMap;
    }

    public void addRewriteRule(String string, String string2) {
        if (string == null || string.length() == 0 || !string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        if (this._rewrite == null) {
            this._rewrite = new PathMap(true);
        }
        this._rewrite.put(string, string2);
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        PathMap.Entry entry;
        if (this.isStarted() && this._rewrite != null && (entry = this._rewrite.getMatch(string)) != null && entry.getValue() != null) {
            if (this._originalPathAttribute != null) {
                httpServletRequest.setAttribute(this._originalPathAttribute, (Object)string);
            }
            string = URIUtil.addPaths(entry.getValue().toString(), PathMap.pathInfo(entry.getKey().toString(), string));
            if (this._rewriteRequestURI) {
                ((Request)httpServletRequest).setRequestURI(string);
            }
            if (this._rewritePathInfo) {
                ((Request)httpServletRequest).setPathInfo(string);
            }
        }
        super.handle(string, httpServletRequest, httpServletResponse, n);
    }
}

