/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.AbstractStatisticsHandler;

public class StatisticsHandler
extends AbstractStatisticsHandler {
    private transient long _statsStartedAt;
    private transient int _requests;
    private transient long _minRequestTime;
    private transient long _maxRequestTime;
    private transient long _totalRequestTime;
    private transient int _requestsActive;
    private transient int _requestsActiveMax;
    private transient int _responses1xx;
    private transient int _responses2xx;
    private transient int _responses3xx;
    private transient int _responses4xx;
    private transient int _responses5xx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            ++this._requests;
            ++this._requestsActive;
            if (this._requestsActive > this._requestsActiveMax) {
                this._requestsActiveMax = this._requestsActive;
            }
        }
        long l = System.currentTimeMillis();
        try {
            super.handle(string, httpServletRequest, httpServletResponse, n);
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis() - l;
            StatisticsHandler statisticsHandler2 = this;
            synchronized (statisticsHandler2) {
                --this._requestsActive;
                if (this._requestsActive < 0) {
                    this._requestsActive = 0;
                }
                this._totalRequestTime += l2;
                if (l2 < this._minRequestTime || this._minRequestTime == 0L) {
                    this._minRequestTime = l2;
                }
                if (l2 > this._maxRequestTime) {
                    this._maxRequestTime = l2;
                }
                Response response = httpServletResponse instanceof Response ? (Response)httpServletResponse : HttpConnection.getCurrentConnection().getResponse();
                switch (response.getStatus() / 100) {
                    case 1: {
                        ++this._responses1xx;
                        break;
                    }
                    case 2: {
                        ++this._responses2xx;
                        break;
                    }
                    case 3: {
                        ++this._responses3xx;
                        break;
                    }
                    case 4: {
                        ++this._responses4xx;
                        break;
                    }
                    case 5: {
                        ++this._responses5xx;
                        break;
                    }
                }
            }
            throw throwable;
        }
        long l3 = System.currentTimeMillis() - l;
        StatisticsHandler statisticsHandler3 = this;
        synchronized (statisticsHandler3) {
            --this._requestsActive;
            if (this._requestsActive < 0) {
                this._requestsActive = 0;
            }
            this._totalRequestTime += l3;
            if (l3 < this._minRequestTime || this._minRequestTime == 0L) {
                this._minRequestTime = l3;
            }
            if (l3 > this._maxRequestTime) {
                this._maxRequestTime = l3;
            }
            Response response = httpServletResponse instanceof Response ? (Response)httpServletResponse : HttpConnection.getCurrentConnection().getResponse();
            switch (response.getStatus() / 100) {
                case 1: {
                    ++this._responses1xx;
                    break;
                }
                case 2: {
                    ++this._responses2xx;
                    break;
                }
                case 3: {
                    ++this._responses3xx;
                    break;
                }
                case 4: {
                    ++this._responses4xx;
                    break;
                }
                case 5: {
                    ++this._responses5xx;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statsReset() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            this._statsStartedAt = System.currentTimeMillis();
            this._requests = 0;
            this._minRequestTime = 0L;
            this._maxRequestTime = 0L;
            this._totalRequestTime = 0L;
            this._requestsActiveMax = this._requestsActive;
            this._requestsActive = 0;
            this._responses1xx = 0;
            this._responses2xx = 0;
            this._responses3xx = 0;
            this._responses4xx = 0;
            this._responses5xx = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequests() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestsActive() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requestsActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestsActiveMax() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requestsActiveMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponses1xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses1xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponses2xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses2xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponses3xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses3xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponses4xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses4xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponses5xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses5xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStatsOnMs() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return System.currentTimeMillis() - this._statsStartedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequestTimeMin() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._minRequestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequestTimeMax() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._maxRequestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequestTimeTotal() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._totalRequestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequestTimeAverage() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requests == 0 ? 0L : this._totalRequestTime / (long)this._requests;
        }
    }
}

