/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.nio.AbstractNIOConnector;
import org.mortbay.log.Log;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;

    @Override
    public Object getConnection() {
        return this._acceptChannel;
    }

    @Override
    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress inetSocketAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(inetSocketAddress, this.getAcceptQueueSize());
    }

    @Override
    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    @Override
    public void accept(int n) throws IOException, InterruptedException {
        SocketChannel socketChannel = this._acceptChannel.accept();
        socketChannel.configureBlocking(true);
        Socket socket = socketChannel.socket();
        this.configure(socket);
        Connection connection = new Connection(socketChannel);
        connection.dispatch();
    }

    @Override
    public void customize(EndPoint endPoint, Request request) throws IOException {
        Connection connection = (Connection)endPoint;
        if (connection._sotimeout != this._maxIdleTime) {
            connection._sotimeout = this._maxIdleTime;
            ((SocketChannel)endPoint.getTransport()).socket().setSoTimeout(this._maxIdleTime);
        }
        super.customize(endPoint, request);
        this.configure(((SocketChannel)endPoint.getTransport()).socket());
    }

    @Override
    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    private class Connection
    extends ChannelEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;

        Connection(ByteChannel byteChannel) {
            super(byteChannel);
            this._dispatched = false;
            this._connection = new HttpConnection(BlockingChannelConnector.this, this, BlockingChannelConnector.this.getServer());
        }

        void dispatch() throws IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for  {}", this._connection);
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BlockingChannelConnector.this.connectionOpened(this._connection);
                while (this.isOpen()) {
                    int n;
                    if (this._connection.isIdle() && BlockingChannelConnector.this.getServer().getThreadPool().isLowOnThreads() && (n = BlockingChannelConnector.this.getLowResourceMaxIdleTime()) >= 0 && this._sotimeout != n) {
                        this._sotimeout = n;
                        ((SocketChannel)this.getTransport()).socket().setSoTimeout(this._sotimeout);
                    }
                    this._connection.handle();
                }
            }
            catch (EofException eofException) {
                Log.debug("EOF", eofException);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            catch (HttpException httpException) {
                Log.debug("BAD", httpException);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            catch (Throwable throwable) {
                Log.warn("handle failed", throwable);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            finally {
                BlockingChannelConnector.this.connectionClosed(this._connection);
            }
        }
    }
}

