/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.nio.AbstractNIOConnector;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;
import org.mortbay.util.ajax.Continuation;

public class SelectChannelConnector
extends AbstractNIOConnector {
    protected transient ServerSocketChannel _acceptChannel;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private SelectorManager _manager = new SelectorManager(){

        @Override
        protected SocketChannel acceptChannel(SelectionKey selectionKey) throws IOException {
            SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
            if (socketChannel == null) {
                return null;
            }
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            SelectChannelConnector.this.configure(socket);
            return socketChannel;
        }

        @Override
        public boolean dispatch(Runnable runnable) throws IOException {
            return SelectChannelConnector.this.getThreadPool().dispatch(runnable);
        }

        @Override
        protected void endPointClosed(SelectChannelEndPoint selectChannelEndPoint) {
            SelectChannelConnector.this.connectionClosed((HttpConnection)selectChannelEndPoint.getConnection());
        }

        @Override
        protected void endPointOpened(SelectChannelEndPoint selectChannelEndPoint) {
            SelectChannelConnector.this.connectionOpened((HttpConnection)selectChannelEndPoint.getConnection());
        }

        @Override
        protected Connection newConnection(SocketChannel socketChannel, SelectChannelEndPoint selectChannelEndPoint) {
            return SelectChannelConnector.this.newConnection(socketChannel, selectChannelEndPoint);
        }

        @Override
        protected SelectChannelEndPoint newEndPoint(SocketChannel socketChannel, SelectorManager.SelectSet selectSet, SelectionKey selectionKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(socketChannel, selectSet, selectionKey);
        }
    };

    @Override
    public void accept(int n) throws IOException {
        this._manager.doSelect(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._manager.isRunning()) {
                try {
                    this._manager.stop();
                }
                catch (Exception exception) {
                    Log.warn(exception);
                }
            }
            if (this._acceptChannel != null) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
        }
    }

    @Override
    public void customize(EndPoint endPoint, Request request) throws IOException {
        ConnectorEndPoint connectorEndPoint = (ConnectorEndPoint)endPoint;
        connectorEndPoint.cancelIdle();
        request.setTimeStamp(connectorEndPoint.getSelectSet().getNow());
        super.customize(endPoint, request);
    }

    @Override
    public void persist(EndPoint endPoint) throws IOException {
        ((ConnectorEndPoint)endPoint).scheduleIdle();
        super.persist(endPoint);
    }

    @Override
    public Object getConnection() {
        return this._acceptChannel;
    }

    public boolean getDelaySelectKeyUpdate() {
        return this._manager.isDelaySelectKeyUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
                return -1;
            }
            return this._acceptChannel.socket().getLocalPort();
        }
    }

    @Override
    public Continuation newContinuation() {
        return new RetryContinuation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                this._acceptChannel.socket().setReuseAddress(this.getReuseAddress());
                InetSocketAddress inetSocketAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                this._acceptChannel.socket().bind(inetSocketAddress, this.getAcceptQueueSize());
                this._acceptChannel.configureBlocking(false);
            }
        }
    }

    public void setDelaySelectKeyUpdate(boolean bl) {
        this._manager.setDelaySelectKeyUpdate(bl);
    }

    @Override
    public void setMaxIdleTime(int n) {
        this._manager.setMaxIdleTime(n);
        super.setMaxIdleTime(n);
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections;
    }

    public void setLowResourcesConnections(long l) {
        this._lowResourcesConnections = l;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long l) {
        this._lowResourcesMaxIdleTime = l;
        super.setLowResourceMaxIdleTime((int)l);
    }

    @Override
    public void setLowResourceMaxIdleTime(int n) {
        this._lowResourcesMaxIdleTime = n;
        super.setLowResourceMaxIdleTime(n);
    }

    @Override
    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this._manager.setLowResourcesConnections(this.getLowResourcesConnections());
        this._manager.setLowResourcesMaxIdleTime(this.getLowResourcesMaxIdleTime());
        this._manager.start();
        this.open();
        this._manager.register(this._acceptChannel);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel socketChannel, SelectorManager.SelectSet selectSet, SelectionKey selectionKey) throws IOException {
        return new ConnectorEndPoint(socketChannel, selectSet, selectionKey);
    }

    protected Connection newConnection(SocketChannel socketChannel, SelectChannelEndPoint selectChannelEndPoint) {
        return new HttpConnection(this, selectChannelEndPoint, this.getServer());
    }

    public static class RetryContinuation
    extends Timeout.Task
    implements Continuation,
    Runnable {
        SelectChannelEndPoint _endPoint = (SelectChannelEndPoint)HttpConnection.getCurrentConnection().getEndPoint();
        boolean _new = true;
        Object _object;
        boolean _pending = false;
        boolean _resumed = false;
        boolean _parked = false;
        RetryRequest _retry;
        long _timeout;

        @Override
        public Object getObject() {
            return this._object;
        }

        public long getTimeout() {
            return this._timeout;
        }

        @Override
        public boolean isNew() {
            return this._new;
        }

        @Override
        public boolean isPending() {
            return this._pending;
        }

        @Override
        public boolean isResumed() {
            return this._resumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Object object = this;
            synchronized (object) {
                this._resumed = false;
                this._pending = false;
                this._parked = false;
            }
            object = this._endPoint.getSelectSet();
            synchronized (object) {
                this.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend(long l) {
            boolean bl = false;
            Object object = this;
            synchronized (object) {
                bl = this._resumed;
                this._resumed = false;
                this._new = false;
                if (!this._pending && !bl && l >= 0L) {
                    this._pending = true;
                    this._parked = false;
                    this._timeout = l;
                    if (this._retry == null) {
                        this._retry = new RetryRequest();
                    }
                    throw this._retry;
                }
                this._resumed = false;
                this._pending = false;
                this._parked = false;
            }
            object = this._endPoint.getSelectSet();
            synchronized (object) {
                this.cancel();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume() {
            boolean bl = false;
            Object object = this;
            synchronized (object) {
                if (this._pending && !this.isExpired()) {
                    this._resumed = true;
                    bl = this._parked;
                    this._parked = false;
                }
            }
            if (bl) {
                Object object2 = object = this._endPoint.getSelectSet();
                synchronized (object2) {
                    this.cancel();
                }
                this._endPoint.scheduleIdle();
                ((SelectorManager.SelectSet)object).addChange(this);
                ((SelectorManager.SelectSet)object).wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void expire() {
            boolean bl = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                bl = this._parked && this._pending && !this._resumed;
                this._parked = false;
            }
            if (bl) {
                this._endPoint.scheduleIdle();
                this._endPoint.getSelectSet().addChange(this);
                this._endPoint.getSelectSet().wakeup();
            }
        }

        @Override
        public void run() {
            this._endPoint.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean undispatch() {
            boolean bl = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (!this._pending) {
                    return true;
                }
                bl = this.isExpired() || this._resumed;
                this._parked = !bl;
            }
            if (bl) {
                this._endPoint.scheduleIdle();
                this._endPoint.getSelectSet().addChange(this);
            } else if (this._timeout > 0L) {
                this._endPoint.getSelectSet().scheduleTimeout(this, this._timeout);
            }
            this._endPoint.getSelectSet().wakeup();
            return false;
        }

        @Override
        public void setObject(Object object) {
            this._object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                return "RetryContinuation@" + this.hashCode() + (this._new ? ",new" : "") + (this._pending ? ",pending" : "") + (this._resumed ? ",resumed" : "") + (this.isExpired() ? ",expired" : "") + (this._parked ? ",parked" : "");
            }
        }
    }

    public static class ConnectorEndPoint
    extends SelectChannelEndPoint {
        public ConnectorEndPoint(SocketChannel socketChannel, SelectorManager.SelectSet selectSet, SelectionKey selectionKey) {
            super(socketChannel, selectSet, selectionKey);
            this.scheduleIdle();
        }

        @Override
        public void close() throws IOException {
            RetryContinuation retryContinuation;
            Connection connection = this.getConnection();
            if (connection instanceof HttpConnection && (retryContinuation = (RetryContinuation)((HttpConnection)this.getConnection()).getRequest().getContinuation()) != null && retryContinuation.isPending()) {
                retryContinuation.reset();
            }
            super.close();
        }

        @Override
        public void undispatch() {
            Connection connection = this.getConnection();
            if (connection instanceof HttpConnection) {
                RetryContinuation retryContinuation = (RetryContinuation)((HttpConnection)this.getConnection()).getRequest().getContinuation();
                if (retryContinuation != null) {
                    Log.debug("continuation {}", retryContinuation);
                    if (retryContinuation.undispatch()) {
                        super.undispatch();
                    }
                } else {
                    super.undispatch();
                }
            } else {
                super.undispatch();
            }
        }
    }
}

