/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.StringUtil;

public class B64Code {
    static final char pad = '=';
    static final char[] nibble2code;
    static byte[] code2nibble;

    public static String encode(String string) {
        try {
            return B64Code.encode(string, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.toString());
        }
    }

    public static String encode(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string2 == null ? string.getBytes(StringUtil.__ISO_8859_1) : string.getBytes(string2);
        return new String(B64Code.encode(byArray));
    }

    public static char[] encode(byte[] byArray) {
        byte by;
        byte by2;
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 3 * 3;
        while (n3 < n4) {
            by2 = byArray[n3++];
            by = byArray[n3++];
            byte by3 = byArray[n3++];
            cArray[n2++] = nibble2code[by2 >>> 2 & 0x3F];
            cArray[n2++] = nibble2code[by2 << 4 & 0x3F | by >>> 4 & 0xF];
            cArray[n2++] = nibble2code[by << 2 & 0x3F | by3 >>> 6 & 3];
            cArray[n2++] = nibble2code[by3 & 0x3F];
        }
        if (n != n3) {
            switch (n % 3) {
                case 2: {
                    by2 = byArray[n3++];
                    by = byArray[n3++];
                    cArray[n2++] = nibble2code[by2 >>> 2 & 0x3F];
                    cArray[n2++] = nibble2code[by2 << 4 & 0x3F | by >>> 4 & 0xF];
                    cArray[n2++] = nibble2code[by << 2 & 0x3F];
                    cArray[n2++] = 61;
                    break;
                }
                case 1: {
                    by2 = byArray[n3++];
                    cArray[n2++] = nibble2code[by2 >>> 2 & 0x3F];
                    cArray[n2++] = nibble2code[by2 << 4 & 0x3F];
                    cArray[n2++] = 61;
                    cArray[n2++] = 61;
                    break;
                }
            }
        }
        return cArray;
    }

    public static String decode(String string) {
        try {
            return B64Code.decode(string, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.toString());
        }
    }

    public static String decode(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = B64Code.decode(string.toCharArray());
        if (string2 == null) {
            return new String(byArray);
        }
        return new String(byArray, string2);
    }

    public static byte[] decode(char[] cArray) {
        int n;
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        if (n2 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        for (n = n2 - 1; n >= 0 && cArray[n] == '='; --n) {
        }
        if (n < 0) {
            return new byte[0];
        }
        int n3 = (n + 1) * 3 / 4;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 / 3 * 3;
        try {
            byte by;
            byte by2;
            byte by3;
            while (n4 < n6) {
                by3 = code2nibble[cArray[n5++]];
                by2 = code2nibble[cArray[n5++]];
                by = code2nibble[cArray[n5++]];
                byte by4 = code2nibble[cArray[n5++]];
                if (by3 < 0 || by2 < 0 || by < 0 || by4 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                byArray[n4++] = (byte)(by3 << 2 | by2 >>> 4);
                byArray[n4++] = (byte)(by2 << 4 | by >>> 2);
                byArray[n4++] = (byte)(by << 6 | by4);
            }
            if (n3 != n4) {
                switch (n3 % 3) {
                    case 2: {
                        by3 = code2nibble[cArray[n5++]];
                        by2 = code2nibble[cArray[n5++]];
                        by = code2nibble[cArray[n5++]];
                        if (by3 < 0 || by2 < 0 || by < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by3 << 2 | by2 >>> 4);
                        byArray[n4++] = (byte)(by2 << 4 | by >>> 2);
                        break;
                    }
                    case 1: {
                        by3 = code2nibble[cArray[n5++]];
                        by2 = code2nibble[cArray[n5++]];
                        if (by3 < 0 || by2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by3 << 2 | by2 >>> 4);
                        break;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("char " + n5 + " was not B64 encoded");
        }
        return byArray;
    }

    static {
        int n;
        nibble2code = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        code2nibble = null;
        code2nibble = new byte[256];
        for (n = 0; n < 256; ++n) {
            B64Code.code2nibble[n] = -1;
        }
        for (n = 0; n < 64; n = (int)((byte)(n + 1))) {
            B64Code.code2nibble[(byte)B64Code.nibble2code[n]] = n;
        }
        B64Code.code2nibble[61] = 0;
    }
}

