/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;

public class BasicAuthenticator
implements Authenticator {
    @Override
    public Principal authenticate(UserRealm userRealm, String string, Request request, Response response) throws IOException {
        Principal principal = null;
        String string2 = request.getHeader("Authorization");
        if (string2 != null) {
            try {
                String string3;
                int n;
                if (Log.isDebugEnabled()) {
                    Log.debug("Credentials: " + string2);
                }
                string2 = string2.substring(string2.indexOf(32) + 1);
                String string4 = (string2 = B64Code.decode(string2, StringUtil.__ISO_8859_1)).substring(0, n = string2.indexOf(58));
                principal = userRealm.authenticate(string4, string3 = string2.substring(n + 1), request);
                if (principal == null) {
                    Log.warn("AUTH FAILURE: user {}", StringUtil.printable(string4));
                } else {
                    request.setAuthType("BASIC");
                    request.setUserPrincipal(principal);
                }
            }
            catch (Exception exception) {
                Log.warn("AUTH FAILURE: " + exception.toString());
                Log.ignore(exception);
            }
        }
        if (principal == null && response != null) {
            this.sendChallenge(userRealm, response);
        }
        return principal;
    }

    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm userRealm, Response response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + userRealm.getName() + '\"');
        response.sendError(401);
    }
}

