/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.UserRealm;

public class ClientCertAuthenticator
implements Authenticator {
    private int _maxHandShakeSeconds = 60;

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int n) {
        this._maxHandShakeSeconds = n;
    }

    @Override
    public Principal authenticate(UserRealm userRealm, String string, Request request, Response response) throws IOException {
        String string2;
        Principal principal;
        X509Certificate[] x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray[0] == null) {
            if (response != null) {
                response.sendError(403, "A client certificate is required for accessing this web application but the server's listener is not configured for mutual authentication (or the client did not provide a certificate).");
            }
            return null;
        }
        Principal principal2 = x509CertificateArray[0].getSubjectDN();
        if (principal2 == null) {
            principal2 = x509CertificateArray[0].getIssuerDN();
        }
        if ((principal = userRealm.authenticate(string2 = principal2 == null ? "clientcert" : principal2.getName(), x509CertificateArray, request)) == null) {
            if (response != null) {
                response.sendError(403, "The provided client certificate does not correspond to a trusted user.");
            }
            return null;
        }
        request.setAuthType("CLIENT_CERT");
        request.setUserPrincipal(principal);
        return principal;
    }

    @Override
    public String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

