/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.security.MessageDigest;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.UnixCrypt;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public abstract class Credential {
    public abstract boolean check(Object var1);

    public static Credential getCredential(String string) {
        if (string.startsWith("CRYPT:")) {
            return new Crypt(string);
        }
        if (string.startsWith("MD5:")) {
            return new MD5(string);
        }
        return new Password(string);
    }

    public static class MD5
    extends Credential {
        public static final String __TYPE = "MD5:";
        public static final Object __md5Lock = new Object();
        private static MessageDigest __md;
        private byte[] _digest;

        MD5(String string) {
            string = string.startsWith(__TYPE) ? string.substring(__TYPE.length()) : string;
            this._digest = TypeUtil.parseBytes(string, 16);
        }

        public byte[] getDigest() {
            return this._digest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean check(Object object) {
            try {
                byte[] byArray = null;
                if (object instanceof Password || object instanceof String) {
                    Object object2 = __md5Lock;
                    synchronized (object2) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(object.toString().getBytes(StringUtil.__ISO_8859_1));
                        byArray = __md.digest();
                    }
                    if (byArray == null || byArray.length != this._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] == this._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (object instanceof MD5) {
                    MD5 mD5 = (MD5)object;
                    if (this._digest.length != mD5._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < this._digest.length; ++i) {
                        if (this._digest[i] == mD5._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (object instanceof Credential) {
                    return ((Credential)object).check(this);
                }
                Log.warn("Can't check " + object.getClass() + " against MD5");
                return false;
            }
            catch (Exception exception) {
                Log.warn(exception);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String string) {
            try {
                byte[] byArray;
                Object object = __md5Lock;
                synchronized (object) {
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception exception) {
                            Log.warn(exception);
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(string.getBytes(StringUtil.__ISO_8859_1));
                    byArray = __md.digest();
                }
                return __TYPE + TypeUtil.toString(byArray, 16);
            }
            catch (Exception exception) {
                Log.warn(exception);
                return null;
            }
        }
    }

    public static class Crypt
    extends Credential {
        public static final String __TYPE = "CRYPT:";
        private String _cooked;

        Crypt(String string) {
            this._cooked = string.startsWith(__TYPE) ? string.substring(__TYPE.length()) : string;
        }

        @Override
        public boolean check(Object object) {
            if (!(object instanceof String) && !(object instanceof Password)) {
                Log.warn("Can't check " + object.getClass() + " against CRYPT");
            }
            String string = object.toString();
            return this._cooked.equals(UnixCrypt.crypt(string, this._cooked));
        }

        public static String crypt(String string, String string2) {
            return __TYPE + UnixCrypt.crypt(string2, string);
        }
    }
}

