/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.Principal;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class DigestAuthenticator
implements Authenticator {
    protected long maxNonceAge = 0L;
    protected long nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean useStale = false;

    @Override
    public Principal authenticate(UserRealm userRealm, String string, Request request, Response response) throws IOException {
        boolean bl = false;
        Principal principal = null;
        String string2 = request.getHeader("Authorization");
        if (string2 != null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Credentials: " + string2);
            }
            QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string2, "=, ", true, false);
            Digest digest = new Digest(request.getMethod());
            String string3 = null;
            String string4 = null;
            block5: while (quotedStringTokenizer.hasMoreTokens()) {
                String string5 = quotedStringTokenizer.nextToken();
                char c = string5.length() == 1 ? string5.charAt(0) : (char)'\u0000';
                switch (c) {
                    case '=': {
                        string4 = string3;
                        string3 = string5;
                        continue block5;
                    }
                    case ',': {
                        string4 = null;
                    }
                    case ' ': {
                        continue block5;
                    }
                }
                string3 = string5;
                if (string4 == null) continue;
                if ("username".equalsIgnoreCase(string4)) {
                    digest.username = string5;
                    continue;
                }
                if ("realm".equalsIgnoreCase(string4)) {
                    digest.realm = string5;
                    continue;
                }
                if ("nonce".equalsIgnoreCase(string4)) {
                    digest.nonce = string5;
                    continue;
                }
                if ("nc".equalsIgnoreCase(string4)) {
                    digest.nc = string5;
                    continue;
                }
                if ("cnonce".equalsIgnoreCase(string4)) {
                    digest.cnonce = string5;
                    continue;
                }
                if ("qop".equalsIgnoreCase(string4)) {
                    digest.qop = string5;
                    continue;
                }
                if ("uri".equalsIgnoreCase(string4)) {
                    digest.uri = string5;
                    continue;
                }
                if (!"response".equalsIgnoreCase(string4)) continue;
                digest.response = string5;
            }
            int n = this.checkNonce(digest.nonce, request);
            if (n > 0) {
                principal = userRealm.authenticate(digest.username, digest, request);
            } else if (n == 0) {
                bl = true;
            }
            if (principal == null) {
                Log.warn("AUTH FAILURE: user " + StringUtil.printable(digest.username));
            } else {
                request.setAuthType("DIGEST");
                request.setUserPrincipal(principal);
            }
        }
        if (principal == null && response != null) {
            this.sendChallenge(userRealm, request, response, bl);
        }
        return principal;
    }

    @Override
    public String getAuthMethod() {
        return "DIGEST";
    }

    public void sendChallenge(UserRealm userRealm, Request request, Response response, boolean bl) throws IOException {
        String string = request.getContextPath();
        if (string == null) {
            string = "/";
        }
        response.setHeader("WWW-Authenticate", "Digest realm=\"" + userRealm.getName() + "\", domain=\"" + string + "\", nonce=\"" + this.newNonce(request) + "\", algorithm=MD5, qop=\"auth\"" + (this.useStale ? " stale=" + bl : ""));
        response.sendError(401);
    }

    public String newNonce(Request request) {
        long l = request.getTimeStamp();
        long l2 = this.nonceSecret;
        byte[] byArray = new byte[24];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
            byArray[8 + i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(byArray, 0, 16);
            byArray2 = messageDigest.digest();
        }
        catch (Exception exception) {
            Log.warn(exception);
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[8 + i] = byArray2[i];
            if (i == 23) break;
        }
        return new String(B64Code.encode(byArray));
    }

    public int checkNonce(String string, Request request) {
        try {
            byte[] byArray = B64Code.decode(string.toCharArray());
            if (byArray.length != 24) {
                return -1;
            }
            long l = 0L;
            long l2 = this.nonceSecret;
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            for (int i = 0; i < 8; ++i) {
                byArray2[8 + i] = (byte)(l2 & 0xFFL);
                l2 >>= 8;
                l = (l << 8) + (0xFFL & (long)byArray[7 - i]);
            }
            long l3 = request.getTimeStamp() - l;
            if (Log.isDebugEnabled()) {
                Log.debug("age=" + l3);
            }
            byte[] byArray3 = null;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.reset();
                messageDigest.update(byArray2, 0, 16);
                byArray3 = messageDigest.digest();
            }
            catch (Exception exception) {
                Log.warn(exception);
            }
            for (int i = 0; i < 16; ++i) {
                if (byArray[i + 8] == byArray3[i]) continue;
                return -1;
            }
            if (this.maxNonceAge > 0L && (l3 < 0L || l3 > this.maxNonceAge)) {
                return 0;
            }
            return 1;
        }
        catch (Exception exception) {
            Log.ignore(exception);
            return -1;
        }
    }

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long l) {
        this.maxNonceAge = l;
    }

    public long getNonceSecret() {
        return this.nonceSecret;
    }

    public void setNonceSecret(long l) {
        this.nonceSecret = l;
    }

    public void setUseStale(boolean bl) {
        this.useStale = bl;
    }

    public boolean getUseStale() {
        return this.useStale;
    }

    private static class Digest
    extends Credential {
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String string) {
            this.method = string;
        }

        @Override
        public boolean check(Object object) {
            String string = object instanceof String ? (String)object : object.toString();
            try {
                byte[] byArray;
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (object instanceof Credential.MD5) {
                    byArray = ((Credential.MD5)object).getDigest();
                } else {
                    messageDigest.update(this.username.getBytes(StringUtil.__ISO_8859_1));
                    messageDigest.update((byte)58);
                    messageDigest.update(this.realm.getBytes(StringUtil.__ISO_8859_1));
                    messageDigest.update((byte)58);
                    messageDigest.update(string.getBytes(StringUtil.__ISO_8859_1));
                    byArray = messageDigest.digest();
                }
                messageDigest.reset();
                messageDigest.update(this.method.getBytes(StringUtil.__ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.uri.getBytes(StringUtil.__ISO_8859_1));
                byte[] byArray2 = messageDigest.digest();
                messageDigest.update(TypeUtil.toString(byArray, 16).getBytes(StringUtil.__ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.nonce.getBytes(StringUtil.__ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.nc.getBytes(StringUtil.__ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.cnonce.getBytes(StringUtil.__ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.qop.getBytes(StringUtil.__ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(TypeUtil.toString(byArray2, 16).getBytes(StringUtil.__ISO_8859_1));
                byte[] byArray3 = messageDigest.digest();
                return TypeUtil.toString(byArray3, 16).equalsIgnoreCase(this.response);
            }
            catch (Exception exception) {
                Log.warn(exception);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

