/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public class FormAuthenticator
implements Authenticator {
    public static final String __J_URI = "org.mortbay.jetty.URI";
    public static final String __J_AUTHENTICATED = "org.mortbay.jetty.Auth";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;

    @Override
    public String getAuthMethod() {
        return "FORM";
    }

    public void setLoginPage(String string) {
        if (!string.startsWith("/")) {
            Log.warn("form-login-page must start with /");
            string = "/" + string;
        }
        this._formLoginPage = string;
        this._formLoginPath = string;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    public String getLoginPage() {
        return this._formLoginPage;
    }

    public void setErrorPage(String string) {
        if (string == null || string.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!string.startsWith("/")) {
                Log.warn("form-error-page must start with /");
                string = "/" + string;
            }
            this._formErrorPage = string;
            this._formErrorPath = string;
            if (this._formErrorPath != null && this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    public String getErrorPage() {
        return this._formErrorPage;
    }

    @Override
    public Principal authenticate(UserRealm userRealm, String string, Request request, Response response) throws IOException {
        String string2 = string;
        HttpSession httpSession = request.getSession(response != null);
        if (httpSession == null) {
            return null;
        }
        if (string2.endsWith(__J_SECURITY_CHECK)) {
            FormCredential formCredential = new FormCredential();
            formCredential.authenticate(userRealm, request.getParameter(__J_USERNAME), request.getParameter(__J_PASSWORD), request);
            String string3 = (String)httpSession.getAttribute(__J_URI);
            if ((string3 == null || string3.length() == 0) && (string3 = request.getContextPath()).length() == 0) {
                string3 = "/";
            }
            if (formCredential._userPrincipal != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Form authentication OK for " + formCredential._jUserName);
                }
                httpSession.removeAttribute(__J_URI);
                request.setAuthType("FORM");
                request.setUserPrincipal(formCredential._userPrincipal);
                httpSession.setAttribute(__J_AUTHENTICATED, (Object)formCredential);
                if (userRealm instanceof SSORealm) {
                    ((SSORealm)((Object)userRealm)).setSingleSignOn(request, response, formCredential._userPrincipal, new Password(formCredential._jPassword));
                }
                if (response != null) {
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(string3));
                }
            } else {
                if (Log.isDebugEnabled()) {
                    Log.debug("Form authentication FAILED for " + StringUtil.printable(formCredential._jUserName));
                }
                if (this._formErrorPage == null) {
                    if (response != null) {
                        response.sendError(403);
                    }
                } else {
                    if (response != null) {
                        response.setContentLength(0);
                    }
                    response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formErrorPage)));
                }
            }
            return null;
        }
        FormCredential formCredential = (FormCredential)httpSession.getAttribute(__J_AUTHENTICATED);
        if (formCredential != null) {
            if (formCredential._userPrincipal == null) {
                formCredential.authenticate(userRealm, request);
                if (formCredential._userPrincipal != null && userRealm instanceof SSORealm) {
                    ((SSORealm)((Object)userRealm)).setSingleSignOn(request, response, formCredential._userPrincipal, new Password(formCredential._jPassword));
                }
            } else if (!userRealm.reauthenticate(formCredential._userPrincipal)) {
                formCredential._userPrincipal = null;
            }
            if (formCredential._userPrincipal != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("FORM Authenticated for " + formCredential._userPrincipal.getName());
                }
                request.setAuthType("FORM");
                request.setUserPrincipal(formCredential._userPrincipal);
                return formCredential._userPrincipal;
            }
            httpSession.setAttribute(__J_AUTHENTICATED, null);
        } else if (userRealm instanceof SSORealm) {
            Credential credential = ((SSORealm)((Object)userRealm)).getSingleSignOn(request, response);
            if (request.getUserPrincipal() != null) {
                formCredential = new FormCredential();
                formCredential._userPrincipal = request.getUserPrincipal();
                formCredential._jUserName = formCredential._userPrincipal.getName();
                if (credential != null) {
                    formCredential._jPassword = credential.toString();
                }
                if (Log.isDebugEnabled()) {
                    Log.debug("SSO for " + formCredential._userPrincipal);
                }
                request.setAuthType("FORM");
                httpSession.setAttribute(__J_AUTHENTICATED, (Object)formCredential);
                return formCredential._userPrincipal;
            }
        }
        if (this.isLoginOrErrorPage(string)) {
            return SecurityHandler.__NOBODY;
        }
        if (response != null) {
            if (request.getQueryString() != null) {
                string2 = string2 + "?" + request.getQueryString();
            }
            httpSession.setAttribute(__J_URI, (Object)(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + URIUtil.addPaths(request.getContextPath(), string2)));
            response.setContentLength(0);
            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formLoginPage)));
        }
        return null;
    }

    public boolean isLoginOrErrorPage(String string) {
        return string != null && (string.equals(this._formErrorPath) || string.equals(this._formLoginPath));
    }

    private static class FormCredential
    implements Serializable,
    HttpSessionBindingListener {
        String _jUserName;
        String _jPassword;
        transient Principal _userPrincipal;
        transient UserRealm _realm;

        private FormCredential() {
        }

        void authenticate(UserRealm userRealm, String string, String string2, Request request) {
            this._jUserName = string;
            this._jPassword = string2;
            this._userPrincipal = userRealm.authenticate(string, string2, request);
            if (this._userPrincipal != null) {
                this._realm = userRealm;
            } else {
                Log.warn("AUTH FAILURE: user {}", StringUtil.printable(string));
                request.setUserPrincipal(null);
            }
        }

        void authenticate(UserRealm userRealm, Request request) {
            this._userPrincipal = userRealm.authenticate(this._jUserName, this._jPassword, request);
            if (this._userPrincipal != null) {
                this._realm = userRealm;
            } else {
                Log.warn("AUTH FAILURE: user {}", StringUtil.printable(this._jUserName));
                request.setUserPrincipal(null);
            }
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            if (Log.isDebugEnabled()) {
                Log.debug("Logout " + this._jUserName);
            }
            if (this._realm instanceof SSORealm) {
                ((SSORealm)((Object)this._realm)).clearSingleSignOn(this._jUserName);
            }
            if (this._realm != null && this._userPrincipal != null) {
                this._realm.logout(this._userPrincipal);
            }
        }

        public int hashCode() {
            return this._jUserName.hashCode() + this._jPassword.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FormCredential)) {
                return false;
            }
            FormCredential formCredential = (FormCredential)object;
            return this._jUserName.equals(formCredential._jUserName) && this._jPassword.equals(formCredential._jPassword);
        }

        public String toString() {
            return "Cred[" + this._jUserName + "]";
        }
    }
}

