/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UnixCrypt;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.resource.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public class HTAccessHandler
extends SecurityHandler {
    private Handler protegee;
    private static Logger log = Log.getLogger(HTAccessHandler.class.getName());
    String _default = null;
    String _accessFile = ".htaccess";
    transient HashMap _htCache = new HashMap();

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        block22: {
            String string2;
            Request request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
            Response response = httpServletResponse instanceof Response ? (Response)httpServletResponse : HttpConnection.getCurrentConnection().getResponse();
            String string3 = string;
            String string4 = null;
            String string5 = null;
            boolean bl = true;
            if (log.isDebugEnabled()) {
                log.debug("HTAccessHandler pathInContext=" + string3, null, null);
            }
            if ((string2 = httpServletRequest.getHeader("Authorization")) != null) {
                string2 = string2.substring(string2.indexOf(32) + 1);
                string2 = B64Code.decode(string2, StringUtil.__ISO_8859_1);
                int n2 = string2.indexOf(58);
                string4 = string2.substring(0, n2);
                string5 = string2.substring(n2 + 1);
                if (log.isDebugEnabled()) {
                    log.debug("User=" + string4 + ", password=" + "******************************".substring(0, string5.length()), null, null);
                }
            }
            HTAccess hTAccess = null;
            try {
                String string6;
                Resource resource = null;
                String string7 = string6 = string3.endsWith("/") ? string3 : URIUtil.parentPath(string3);
                while (string6 != null) {
                    String string8 = string6 + this._accessFile;
                    resource = ((ContextHandler)this.getProtegee()).getResource(string8);
                    if (log.isDebugEnabled()) {
                        log.debug("directory=" + string6 + " resource=" + resource, null, null);
                    }
                    if (resource != null && resource.exists() && !resource.isDirectory()) break;
                    resource = null;
                    string6 = URIUtil.parentPath(string6);
                }
                boolean bl2 = true;
                if (resource == null && this._default != null && (!(resource = Resource.newResource(this._default)).exists() || resource.isDirectory())) {
                    bl2 = false;
                }
                if (resource == null) {
                    bl2 = false;
                }
                if (string3.endsWith(this._accessFile) || string3.endsWith(this._accessFile + "~") || string3.endsWith(this._accessFile + ".bak")) {
                    httpServletResponse.sendError(403);
                    request.setHandled(true);
                    return;
                }
                if (bl2) {
                    if (log.isDebugEnabled()) {
                        log.debug("HTACCESS=" + resource, null, null);
                    }
                    if ((hTAccess = (HTAccess)this._htCache.get(resource)) == null || hTAccess.getLastModified() != resource.lastModified()) {
                        hTAccess = new HTAccess(resource);
                        this._htCache.put(resource, hTAccess);
                        if (log.isDebugEnabled()) {
                            log.debug("HTCache loaded " + hTAccess, null, null);
                        }
                    }
                    if (hTAccess.isForbidden()) {
                        log.warn("Mis-configured htaccess: " + hTAccess, null, null);
                        httpServletResponse.sendError(403);
                        request.setHandled(true);
                        return;
                    }
                    HashMap hashMap = hTAccess.getMethods();
                    if (hashMap.size() > 0 && !hashMap.containsKey(httpServletRequest.getMethod())) {
                        return;
                    }
                    int n3 = hTAccess.getSatisfy();
                    bl = hTAccess.checkAccess("", httpServletRequest.getRemoteAddr());
                    if (log.isDebugEnabled()) {
                        log.debug("IPValid = " + bl, null, null);
                    }
                    if (bl && n3 == 0) {
                        return;
                    }
                    if (!bl && n3 == 1) {
                        httpServletResponse.sendError(403);
                        request.setHandled(true);
                        return;
                    }
                    if (!hTAccess.checkAuth(string4, string5, this.getUserRealm(), request)) {
                        log.debug("Auth Failed", null, null);
                        httpServletResponse.setHeader("WWW-Authenticate", "basic realm=" + hTAccess.getName());
                        httpServletResponse.sendError(401);
                        response.complete();
                        request.setHandled(true);
                        return;
                    }
                    if (string4 != null) {
                        request.setAuthType("BASIC");
                        request.setUserPrincipal(this.getPrincipal(string4, this.getUserRealm()));
                    }
                }
                if (this.getHandler() != null) {
                    this.getHandler().handle(string, httpServletRequest, httpServletResponse, n);
                }
            }
            catch (Exception exception) {
                log.warn("Exception", exception);
                if (hTAccess == null) break block22;
                httpServletResponse.sendError(500);
                request.setHandled(true);
            }
        }
    }

    public Principal getPrincipal(String string, UserRealm userRealm) {
        if (userRealm == null) {
            return new DummyPrincipal(string);
        }
        return userRealm.getPrincipal(string);
    }

    public void setDefault(String string) {
        this._default = string;
    }

    public void setAccessFile(String string) {
        this._accessFile = string == null ? ".htaccess" : string;
    }

    protected Handler getProtegee() {
        return this.protegee;
    }

    public void setProtegee(Handler handler) {
        this.protegee = handler;
    }

    private static class HTAccess {
        static final int ANY = 0;
        static final int ALL = 1;
        static final String USER = "user";
        static final String GROUP = "group";
        static final String VALID_USER = "valid-user";
        String _userFile;
        Resource _userResource;
        HashMap _users = null;
        long _userModified;
        String _groupFile;
        Resource _groupResource;
        HashMap _groups = null;
        long _groupModified;
        int _satisfy = 0;
        String _type;
        String _name;
        HashMap _methods = new HashMap();
        HashSet _requireEntities = new HashSet();
        String _requireName;
        int _order;
        ArrayList _allowList = new ArrayList();
        ArrayList _denyList = new ArrayList();
        long _lastModified;
        boolean _forbidden = false;

        public HTAccess(Resource resource) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
                this.parse(bufferedReader);
                this._lastModified = resource.lastModified();
                if (this._userFile != null) {
                    this._userResource = Resource.newResource(this._userFile);
                    if (!this._userResource.exists()) {
                        this._forbidden = true;
                        log.warn("Could not find ht user file: " + this._userFile, null, null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("user file: " + this._userResource, null, null);
                    }
                }
                if (this._groupFile != null) {
                    this._groupResource = Resource.newResource(this._groupFile);
                    if (!this._groupResource.exists()) {
                        this._forbidden = true;
                        log.warn("Could not find ht group file: " + this._groupResource, null, null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("group file: " + this._groupResource, null, null);
                    }
                }
            }
            catch (IOException iOException) {
                this._forbidden = true;
                log.warn("LogSupport.EXCEPTION", iOException);
            }
        }

        public boolean isForbidden() {
            return this._forbidden;
        }

        public HashMap getMethods() {
            return this._methods;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Resource getUserResource() {
            return this._userResource;
        }

        public Resource getGroupResource() {
            return this._groupResource;
        }

        public int getSatisfy() {
            return this._satisfy;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public boolean checkAccess(String string, String string2) {
            char c;
            String string3;
            int n;
            boolean bl = false;
            boolean bl2 = false;
            if (this._allowList.size() == 0 && this._denyList.size() == 0) {
                return true;
            }
            for (n = 0; n < this._allowList.size(); ++n) {
                string3 = (String)this._allowList.get(n);
                if (string3.equals("all")) {
                    bl = true;
                    break;
                }
                c = string3.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (!string2.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (!string.endsWith(string3)) continue;
                bl = true;
                break;
            }
            for (n = 0; n < this._denyList.size(); ++n) {
                string3 = (String)this._denyList.get(n);
                if (string3.equals("all")) {
                    bl2 = true;
                    break;
                }
                c = string3.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (!string2.startsWith(string3)) continue;
                    bl2 = true;
                    break;
                }
                if (!string.endsWith(string3)) continue;
                bl2 = true;
                break;
            }
            if (this._order < 0) {
                return !bl2 || bl;
            }
            return bl && !bl2;
        }

        public boolean checkAuth(String string, String string2, UserRealm userRealm, Request request) {
            Object object;
            Principal principal;
            if (this._requireName == null) {
                return true;
            }
            Principal principal2 = principal = userRealm == null ? null : userRealm.authenticate(string, string2, request);
            if (principal == null) {
                String string3;
                object = this.getUserCode(string);
                String string4 = object != null ? ((String)object).substring(0, 2) : string;
                String string5 = string3 = string != null && string2 != null ? UnixCrypt.crypt(string2, string4) : null;
                if (object == null || ((String)object).equals("") && !string2.equals("") || !((String)object).equals(string3)) {
                    return false;
                }
            }
            if (this._requireName.equalsIgnoreCase(USER)) {
                if (this._requireEntities.contains(string)) {
                    return true;
                }
            } else if (this._requireName.equalsIgnoreCase(GROUP)) {
                object = this.getUserGroups(string);
                if (object != null) {
                    int n = ((ArrayList)object).size();
                    while (n-- > 0) {
                        if (!this._requireEntities.contains(((ArrayList)object).get(n))) continue;
                        return true;
                    }
                }
            } else if (this._requireName.equalsIgnoreCase(VALID_USER)) {
                return true;
            }
            return false;
        }

        public boolean isAccessLimited() {
            return this._allowList.size() > 0 || this._denyList.size() > 0;
        }

        public boolean isAuthLimited() {
            return this._requireName != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getUserCode(String string) {
            if (this._userResource == null) {
                return null;
            }
            if (this._users == null || this._userModified != this._userResource.lastModified()) {
                if (log.isDebugEnabled()) {
                    log.debug("LOAD " + this._userResource, null, null);
                }
                this._users = new HashMap();
                BufferedReader bufferedReader = null;
                try {
                    String string2;
                    bufferedReader = new BufferedReader(new InputStreamReader(this._userResource.getInputStream()));
                    this._userModified = this._userResource.lastModified();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n;
                        if ((string2 = string2.trim()).startsWith("#") || (n = string2.indexOf(58)) < 0) continue;
                        String string3 = string2.substring(0, n).trim();
                        String string4 = string2.substring(n + 1).trim();
                        this._users.put(string3, string4);
                    }
                }
                catch (IOException iOException) {
                    log.warn("LogSupport.EXCEPTION", iOException);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        log.warn("LogSupport.EXCEPTION", iOException);
                    }
                }
            }
            return (String)this._users.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList getUserGroups(String string) {
            if (this._groupResource == null) {
                return null;
            }
            if (this._groups == null || this._groupModified != this._groupResource.lastModified()) {
                if (log.isDebugEnabled()) {
                    log.debug("LOAD " + this._groupResource, null, null);
                }
                this._groups = new HashMap();
                BufferedReader bufferedReader = null;
                try {
                    String string2;
                    bufferedReader = new BufferedReader(new InputStreamReader(this._groupResource.getInputStream()));
                    this._groupModified = this._groupResource.lastModified();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer;
                        if ((string2 = string2.trim()).startsWith("#") || string2.length() == 0 || !(stringTokenizer = new StringTokenizer(string2, ": \t")).hasMoreTokens()) continue;
                        String string3 = stringTokenizer.nextToken();
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken();
                            ArrayList<String> arrayList = (ArrayList<String>)this._groups.get(string4);
                            if (arrayList == null) {
                                arrayList = new ArrayList<String>();
                                this._groups.put(string4, arrayList);
                            }
                            arrayList.add(string3);
                        }
                    }
                }
                catch (IOException iOException) {
                    log.warn("LogSupport.EXCEPTION", iOException);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        log.warn("LogSupport.EXCEPTION", iOException);
                    }
                }
            }
            return (ArrayList)this._groups.get(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("AuthUserFile=");
            stringBuffer.append(this._userFile);
            stringBuffer.append(", AuthGroupFile=");
            stringBuffer.append(this._groupFile);
            stringBuffer.append(", AuthName=");
            stringBuffer.append(this._name);
            stringBuffer.append(", AuthType=");
            stringBuffer.append(this._type);
            stringBuffer.append(", Methods=");
            stringBuffer.append(this._methods);
            stringBuffer.append(", satisfy=");
            stringBuffer.append(this._satisfy);
            if (this._order < 0) {
                stringBuffer.append(", order=deny,allow");
            } else if (this._order > 0) {
                stringBuffer.append(", order=allow,deny");
            } else {
                stringBuffer.append(", order=mutual-failure");
            }
            stringBuffer.append(", Allow from=");
            stringBuffer.append(this._allowList);
            stringBuffer.append(", deny from=");
            stringBuffer.append(this._denyList);
            stringBuffer.append(", requireName=");
            stringBuffer.append(this._requireName);
            stringBuffer.append(" ");
            stringBuffer.append(this._requireEntities);
            return stringBuffer.toString();
        }

        private void parse(BufferedReader bufferedReader) throws IOException {
            String string;
            block0: while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#")) continue;
                if (string.startsWith("AuthUserFile")) {
                    this._userFile = string.substring(13).trim();
                    continue;
                }
                if (string.startsWith("AuthGroupFile")) {
                    this._groupFile = string.substring(14).trim();
                    continue;
                }
                if (string.startsWith("AuthName")) {
                    this._name = string.substring(8).trim();
                    continue;
                }
                if (string.startsWith("AuthType")) {
                    this._type = string.substring(8).trim();
                    continue;
                }
                if (!string.startsWith("<Limit")) continue;
                int n = string.length();
                int n2 = string.indexOf(62);
                if (n2 < 0) {
                    n2 = n;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(6, n2));
                while (stringTokenizer.hasMoreTokens()) {
                    this._methods.put(stringTokenizer.nextToken(), Boolean.TRUE);
                }
                while ((string = bufferedReader.readLine()) != null) {
                    int n3;
                    int n4;
                    if ((string = string.trim()).startsWith("#")) continue;
                    if (string.startsWith("satisfy")) {
                        n = string.length();
                        for (n4 = 7; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        for (n3 = n4; n3 < n && string.charAt(n3) > ' '; ++n3) {
                        }
                        String string2 = string.substring(n4, n3);
                        if (string2.equals("all")) {
                            this._satisfy = 1;
                            continue;
                        }
                        if (!string2.equals("any")) continue;
                        this._satisfy = 0;
                        continue;
                    }
                    if (string.startsWith("require")) {
                        n = string.length();
                        for (n4 = 7; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        for (n3 = n4; n3 < n && string.charAt(n3) > ' '; ++n3) {
                        }
                        this._requireName = string.substring(n4, n3).toLowerCase();
                        if (USER.equals(this._requireName)) {
                            this._requireName = USER;
                        } else if (GROUP.equals(this._requireName)) {
                            this._requireName = GROUP;
                        } else if (VALID_USER.equals(this._requireName)) {
                            this._requireName = VALID_USER;
                        }
                        if ((n4 = n3 + 1) >= n) continue;
                        while (n4 < n && string.charAt(n4) <= ' ') {
                            ++n4;
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n4));
                        while (stringTokenizer.hasMoreTokens()) {
                            this._requireEntities.add(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (string.startsWith("order")) {
                        if (log.isDebugEnabled()) {
                            log.debug("orderline=" + string + "order=" + this._order, null, null);
                        }
                        if (string.indexOf("allow,deny") > 0) {
                            log.debug("==>allow+deny", null, null);
                            this._order = 1;
                            continue;
                        }
                        if (string.indexOf("deny,allow") > 0) {
                            log.debug("==>deny,allow", null, null);
                            this._order = -1;
                            continue;
                        }
                        if (string.indexOf("mutual-failure") <= 0) continue;
                        log.debug("==>mutual", null, null);
                        this._order = 0;
                        continue;
                    }
                    if (string.startsWith("allow from")) {
                        n = string.length();
                        for (n4 = 10; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("allow process:" + string.substring(n4), null, null);
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n4));
                        while (stringTokenizer.hasMoreTokens()) {
                            this._allowList.add(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (string.startsWith("deny from")) {
                        n = string.length();
                        for (n4 = 9; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("deny process:" + string.substring(n4), null, null);
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n4));
                        while (stringTokenizer.hasMoreTokens()) {
                            this._denyList.add(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (!string.startsWith("</Limit>")) continue;
                    continue block0;
                }
            }
        }
    }

    class DummyPrincipal
    implements Principal {
        private String _userName;

        public DummyPrincipal(String string) {
            this._userName = string;
        }

        @Override
        public String getName() {
            return this._userName;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

