/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.security.Principal;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;

public class HashSSORealm
implements SSORealm {
    public static final String SSO_COOKIE_NAME = "SSO_ID";
    private HashMap _ssoId2Principal = new HashMap();
    private HashMap _ssoUsername2Id = new HashMap();
    private HashMap _ssoPrincipal2Credential = new HashMap();
    private transient Random _random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential getSingleSignOn(Request request, Response response) {
        String string = null;
        Cookie[] cookieArray = request.getCookies();
        for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(SSO_COOKIE_NAME)) continue;
            string = cookieArray[i].getValue();
            break;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("get ssoID=" + string);
        }
        Principal principal = null;
        Credential credential = null;
        Object object = this._ssoId2Principal;
        synchronized (object) {
            principal = (Principal)this._ssoId2Principal.get(string);
            credential = (Credential)this._ssoPrincipal2Credential.get(principal);
        }
        if (Log.isDebugEnabled()) {
            Log.debug("SSO principal=" + principal);
        }
        if (principal != null && credential != null) {
            object = ((WebAppContext)request.getContext().getContextHandler()).getSecurityHandler().getUserRealm();
            Principal principal2 = object.authenticate(principal.getName(), credential, request);
            if (principal2 != null) {
                request.setUserPrincipal(principal2);
                return credential;
            }
            HashMap hashMap = this._ssoId2Principal;
            synchronized (hashMap) {
                this._ssoId2Principal.remove(string);
                this._ssoPrincipal2Credential.remove(principal);
                this._ssoUsername2Id.remove(principal.getName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSingleSignOn(Request request, Response response, Principal principal, Credential credential) {
        String string = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            while (this._ssoId2Principal.containsKey(string = Long.toString(Math.abs(this._random.nextLong()), 30 + (int)(System.currentTimeMillis() % 7L)))) {
            }
            if (Log.isDebugEnabled()) {
                Log.debug("set ssoID=" + string);
            }
            this._ssoId2Principal.put(string, principal);
            this._ssoPrincipal2Credential.put(principal, credential);
            this._ssoUsername2Id.put(principal.getName(), string);
        }
        hashMap = new Cookie(SSO_COOKIE_NAME, string);
        hashMap.setPath("/");
        response.addCookie((Cookie)hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSingleSignOn(String string) {
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            Object v = this._ssoUsername2Id.remove(string);
            Object v2 = this._ssoId2Principal.remove(v);
            this._ssoPrincipal2Credential.remove(v2);
        }
    }
}

