/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.Scanner;

public class HashUserRealm
extends AbstractLifeCycle
implements UserRealm,
SSORealm {
    public static final String __SSO = "org.mortbay.http.SSO";
    private String _realmName;
    private String _config;
    private Resource _configResource;
    protected HashMap _users = new HashMap();
    protected HashMap _roles = new HashMap(7);
    private SSORealm _ssoRealm;
    private Scanner _scanner;
    private int _refreshInterval = 0;

    public HashUserRealm() {
    }

    public HashUserRealm(String string) {
        this._realmName = string;
    }

    public HashUserRealm(String string, String string2) throws IOException {
        this._realmName = string;
        this.setConfig(string2);
    }

    public String getConfig() {
        return this._config;
    }

    public Resource getConfigResource() {
        return this._configResource;
    }

    public void setConfig(String string) throws IOException {
        this._config = string;
        this._configResource = Resource.newResource(this._config);
        this.loadConfig();
    }

    public void setRefreshInterval(int n) {
        this._refreshInterval = n;
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() throws IOException {
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            this._users.clear();
            this._roles.clear();
            if (Log.isDebugEnabled()) {
                Log.debug("Load " + this + " from " + this._config);
            }
            Properties properties = new Properties();
            properties.load(this._configResource.getInputStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = entry.getKey().toString().trim();
                String string2 = entry.getValue().toString().trim();
                String string3 = null;
                int n = string2.indexOf(44);
                if (n > 0) {
                    string3 = string2.substring(n + 1).trim();
                    string2 = string2.substring(0, n).trim();
                }
                if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
                this.put(string, string2);
                if (string3 == null || string3.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addUserToRole(string, stringTokenizer.nextToken());
                }
            }
        }
    }

    public void setName(String string) {
        this._realmName = string;
    }

    @Override
    public String getName() {
        return this._realmName;
    }

    @Override
    public Principal getPrincipal(String string) {
        return (Principal)this._users.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, Object object, Request request) {
        KnownUser knownUser;
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            knownUser = (KnownUser)this._users.get(string);
        }
        if (knownUser == null) {
            return null;
        }
        if (knownUser.authenticate(object)) {
            return knownUser;
        }
        return null;
    }

    @Override
    public void disassociate(Principal principal) {
    }

    @Override
    public Principal pushRole(Principal principal, String string) {
        if (principal == null) {
            principal = new User();
        }
        return new WrappedUser(principal, string);
    }

    @Override
    public Principal popRole(Principal principal) {
        WrappedUser wrappedUser = (WrappedUser)principal;
        return wrappedUser.getUserPrincipal();
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 instanceof Principal) {
            return this._users.put(object.toString(), object2);
        }
        if (object2 instanceof Password) {
            return this._users.put(object, new KnownUser(object.toString(), (Password)object2));
        }
        if (object2 != null) {
            return this._users.put(object, new KnownUser(object.toString(), Credential.getCredential(object2.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String string, String string2) {
        HashSet<String> hashSet = (HashSet<String>)this._roles.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<String>(11);
            this._roles.put(string2, hashSet);
        }
        hashSet.add(string);
    }

    @Override
    public boolean reauthenticate(Principal principal) {
        return ((User)principal).isAuthenticated();
    }

    @Override
    public synchronized boolean isUserInRole(Principal principal, String string) {
        if (principal instanceof WrappedUser) {
            return ((WrappedUser)principal).isUserInRole(string);
        }
        if (principal == null || !(principal instanceof User) || ((User)principal).getUserRealm() != this) {
            return false;
        }
        HashSet hashSet = (HashSet)this._roles.get(string);
        return hashSet != null && hashSet.contains(principal.getName());
    }

    @Override
    public void logout(Principal principal) {
    }

    public String toString() {
        return "Realm[" + this._realmName + "]==" + this._users.keySet();
    }

    public void dump(PrintStream printStream) {
        printStream.println(this + ":");
        printStream.println(super.toString());
        printStream.println(this._roles);
    }

    public SSORealm getSSORealm() {
        return this._ssoRealm;
    }

    public void setSSORealm(SSORealm sSORealm) {
        this._ssoRealm = sSORealm;
    }

    @Override
    public Credential getSingleSignOn(Request request, Response response) {
        if (this._ssoRealm != null) {
            return this._ssoRealm.getSingleSignOn(request, response);
        }
        return null;
    }

    @Override
    public void setSingleSignOn(Request request, Response response, Principal principal, Credential credential) {
        if (this._ssoRealm != null) {
            this._ssoRealm.setSingleSignOn(request, response, principal, credential);
        }
    }

    @Override
    public void clearSingleSignOn(String string) {
        if (this._ssoRealm != null) {
            this._ssoRealm.clearSingleSignOn(string);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._scanner != null) {
            this._scanner.stop();
        }
        if (this.getRefreshInterval() > 0) {
            this._scanner = new Scanner();
            this._scanner.setScanInterval(this.getRefreshInterval());
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(this._configResource.getFile());
            this._scanner.setScanDirs(arrayList);
            this._scanner.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    try {
                        if (file2.compareTo(HashUserRealm.this._configResource.getFile()) == 0) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    return false;
                }
            });
            this._scanner.addListener(new Scanner.BulkListener(){

                @Override
                public void filesChanged(List list) throws Exception {
                    if (list == null) {
                        return;
                    }
                    if (list.isEmpty()) {
                        return;
                    }
                    if (list.size() == 1 && list.get(0).equals(HashUserRealm.this._config)) {
                        HashUserRealm.this.loadConfig();
                    }
                }

                public String toString() {
                    return "HashUserRealm$Scanner";
                }
            });
            this._scanner.setReportExistingFilesOnStartup(false);
            this._scanner.setRecursive(false);
            this._scanner.start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this._scanner.stop();
        }
        this._scanner = null;
    }

    private class WrappedUser
    extends User {
        private Principal user;
        private String role;

        WrappedUser(Principal principal, String string) {
            this.user = principal;
            this.role = string;
        }

        Principal getUserPrincipal() {
            return this.user;
        }

        @Override
        public String getName() {
            return "role:" + this.role;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String string) {
            return this.role.equals(string);
        }
    }

    private class KnownUser
    extends User {
        private String _userName;
        private Credential _cred;

        KnownUser(String string, Credential credential) {
            this._userName = string;
            this._cred = credential;
        }

        boolean authenticate(Object object) {
            return this._cred != null && this._cred.check(object);
        }

        @Override
        public String getName() {
            return this._userName;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }
    }

    private class User
    implements Principal {
        List roles = null;

        private User() {
        }

        private UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        @Override
        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

