/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.Loader;

public class JDBCUserRealm
extends HashUserRealm
implements UserRealm {
    private String _jdbcDriver;
    private String _url;
    private String _userName;
    private String _password;
    private String _userTable;
    private String _userTableKey;
    private String _userTableUserField;
    private String _userTablePasswordField;
    private String _roleTable;
    private String _roleTableKey;
    private String _roleTableRoleField;
    private String _userRoleTable;
    private String _userRoleTableUserKey;
    private String _userRoleTableRoleKey;
    private int _cacheTime;
    private long _lastHashPurge;
    private Connection _con;
    private String _userSql;
    private String _roleSql;

    public JDBCUserRealm() {
    }

    public JDBCUserRealm(String string) {
        super(string);
    }

    public JDBCUserRealm(String string, String string2) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        super(string);
        this.setConfig(string2);
        Loader.loadClass(this.getClass(), this._jdbcDriver).newInstance();
    }

    @Override
    protected void loadConfig() throws IOException {
        Properties properties = new Properties();
        properties.load(this.getConfigResource().getInputStream());
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        this._userTable = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        this._userTableUserField = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        this._roleTable = properties.getProperty("roletable");
        this._roleTableKey = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        this._userRoleTable = properties.getProperty("userroletable");
        this._userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        this._userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        String string = properties.getProperty("cachetime");
        int n = this._cacheTime = string != null ? new Integer(string) : 30;
        if ((this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null || this._cacheTime < 0) && Log.isDebugEnabled()) {
            Log.debug("UserRealm " + this.getName() + " has not been properly configured");
        }
        this._cacheTime *= 1000;
        this._lastHashPurge = 0L;
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTable + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTable + " r, " + this._userRoleTable + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
    }

    @Override
    public void logout(Principal principal) {
    }

    public void connectDatabase() {
        try {
            Class.forName(this._jdbcDriver);
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
        }
        catch (SQLException sQLException) {
            Log.warn("UserRealm " + this.getName() + " could not connect to database; will try later", sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.warn("UserRealm " + this.getName() + " could not connect to database; will try later", classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, Object object, Request request) {
        JDBCUserRealm jDBCUserRealm = this;
        synchronized (jDBCUserRealm) {
            Principal principal;
            long l = System.currentTimeMillis();
            if (l - this._lastHashPurge > (long)this._cacheTime || this._cacheTime == 0) {
                this._users.clear();
                this._roles.clear();
                this._lastHashPurge = l;
                this.closeConnection();
            }
            if ((principal = super.getPrincipal(string)) == null) {
                this.loadUser(string);
                principal = super.getPrincipal(string);
            }
        }
        return super.authenticate(string, object, request);
    }

    @Override
    public synchronized boolean isUserInRole(Principal principal, String string) {
        if (super.getPrincipal(principal.getName()) == null) {
            this.loadUser(principal.getName());
        }
        return super.isUserInRole(principal, string);
    }

    private void loadUser(String string) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            PreparedStatement preparedStatement = this._con.prepareStatement(this._userSql);
            preparedStatement.setObject(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(this._userTableKey);
                this.put(string, resultSet.getString(this._userTablePasswordField));
                preparedStatement.close();
                preparedStatement = this._con.prepareStatement(this._roleSql);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.addUserToRole(string, resultSet.getString(this._roleTableRoleField));
                }
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            Log.warn("UserRealm " + this.getName() + " could not load user information from database", sQLException);
            this.closeConnection();
        }
    }

    private void closeConnection() {
        if (this._con != null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Closing db connection for JDBCUserRealm");
            }
            try {
                this._con.close();
            }
            catch (Exception exception) {
                Log.ignore(exception);
            }
        }
        this._con = null;
    }
}

