/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PKCS12Import {
    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length < 1) {
            System.err.println("usage: java PKCS12Import {pkcs12file} [newjksfile]");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = stringArray.length > 1 ? new File(stringArray[1]) : new File("newstore.jks");
        if (!file.canRead()) {
            System.err.println("Unable to access input keystore: " + file.getPath());
            System.exit(2);
        }
        if (file2.exists() && !file2.canWrite()) {
            System.err.println("Output file is not writable: " + file2.getPath());
            System.exit(2);
        }
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        KeyStore keyStore2 = KeyStore.getInstance("jks");
        System.out.print("Enter input keystore passphrase: ");
        char[] cArray = PKCS12Import.readPassphrase();
        System.out.print("Enter output keystore passphrase: ");
        char[] cArray2 = PKCS12Import.readPassphrase();
        keyStore.load(new FileInputStream(file), cArray);
        keyStore2.load(file2.exists() ? new FileInputStream(file2) : null, cArray2);
        Enumeration<String> enumeration = keyStore.aliases();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            System.err.println("Alias " + n++ + ": " + (String)object);
            if (!keyStore.isKeyEntry((String)object)) continue;
            System.err.println("Adding key for alias " + (String)object);
            Key key = keyStore.getKey((String)object, cArray);
            Certificate[] certificateArray = keyStore.getCertificateChain((String)object);
            keyStore2.setKeyEntry((String)object, key, cArray2, certificateArray);
        }
        object = new FileOutputStream(file2);
        keyStore2.store((OutputStream)object, cArray2);
        ((OutputStream)object).close();
    }

    static void dumpChain(Certificate[] certificateArray) {
        for (int i = 0; i < certificateArray.length; ++i) {
            Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
            System.err.println("subject: " + x509Certificate.getSubjectDN());
            System.err.println("issuer: " + x509Certificate.getIssuerDN());
        }
    }

    static char[] readPassphrase() throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        char[] cArray = new char[256];
        int n = 0;
        block4: while (n < cArray.length) {
            char c = (char)inputStreamReader.read();
            switch (c) {
                case '\r': {
                    break block4;
                }
                case '\n': {
                    break block4;
                }
                default: {
                    cArray[n++] = c;
                    continue block4;
                }
            }
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }
}

