/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.ClientCertAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;
import org.mortbay.util.StringUtil;

public class SecurityHandler
extends HandlerWrapper {
    private String _authMethod = "BASIC";
    private UserRealm _userRealm;
    private ConstraintMapping[] _constraintMappings;
    private PathMap _constraintMap = new PathMap();
    private Authenticator _authenticator;
    private NotChecked _notChecked = new NotChecked();
    private boolean _checkWelcomeFiles = false;
    public static Principal __NO_USER = new Principal(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "No User";
        }
    };
    public static Principal __NOBODY = new Principal(){

        @Override
        public String getName() {
            return "Nobody";
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public UserRealm getUserRealm() {
        return this._userRealm;
    }

    public void setUserRealm(UserRealm userRealm) {
        this._userRealm = userRealm;
    }

    public ConstraintMapping[] getConstraintMappings() {
        return this._constraintMappings;
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappingArray) {
        this._constraintMappings = constraintMappingArray;
        if (this._constraintMappings != null) {
            this._constraintMappings = constraintMappingArray;
            this._constraintMap.clear();
            for (int i = 0; i < this._constraintMappings.length; ++i) {
                Object object = this._constraintMap.get(this._constraintMappings[i].getPathSpec());
                object = LazyList.add(object, this._constraintMappings[i]);
                this._constraintMap.put(this._constraintMappings[i].getPathSpec(), object);
            }
        }
    }

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String string) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(string)) {
            throw new IllegalStateException("Handler started");
        }
        this._authMethod = string;
    }

    public boolean hasConstraints() {
        return this._constraintMappings != null && this._constraintMappings.length > 0;
    }

    public boolean isCheckWelcomeFiles() {
        return this._checkWelcomeFiles;
    }

    public void setCheckWelcomeFiles(boolean bl) {
        this._checkWelcomeFiles = bl;
    }

    @Override
    public void doStart() throws Exception {
        if (this._authenticator == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new ClientCertAuthenticator();
            } else if ("FORM".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new FormAuthenticator();
            } else {
                Log.warn("Unknown Authentication method:" + this._authMethod);
            }
        }
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        Request request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
        Response response = httpServletResponse instanceof Response ? (Response)httpServletResponse : HttpConnection.getCurrentConnection().getResponse();
        UserRealm userRealm = request.getUserRealm();
        try {
            request.setUserRealm(this.getUserRealm());
            if (n == 1 && !this.checkSecurityConstraints(string, request, response)) {
                request.setHandled(true);
                return;
            }
            if (n == 2 && this._checkWelcomeFiles && httpServletRequest.getAttribute("org.mortbay.jetty.welcome") != null) {
                httpServletRequest.removeAttribute("org.mortbay.jetty.welcome");
                if (!this.checkSecurityConstraints(string, request, response)) {
                    request.setHandled(true);
                    return;
                }
            }
            if (this._authenticator instanceof FormAuthenticator && string.endsWith("/j_security_check")) {
                this._authenticator.authenticate(this.getUserRealm(), string, request, response);
                request.setHandled(true);
                return;
            }
            if (this.getHandler() != null) {
                this.getHandler().handle(string, httpServletRequest, httpServletResponse, n);
            }
        }
        finally {
            if (this._userRealm != null && n == 1) {
                this._userRealm.disassociate(request.getUserPrincipal());
            }
            request.setUserRealm(userRealm);
        }
    }

    public boolean checkSecurityConstraints(String string, Request request, Response response) throws IOException {
        Object object = this._constraintMap.getLazyMatches(string);
        String string2 = null;
        Object object2 = null;
        if (object != null) {
            block0: for (int i = 0; i < LazyList.size(object); ++i) {
                Map.Entry entry = (Map.Entry)LazyList.get(object, i);
                Object v = entry.getValue();
                String string3 = (String)entry.getKey();
                for (int j = 0; j < LazyList.size(v); ++j) {
                    ConstraintMapping constraintMapping = (ConstraintMapping)LazyList.get(v, j);
                    if (constraintMapping.getMethod() != null && !constraintMapping.getMethod().equalsIgnoreCase(request.getMethod())) continue;
                    if (string2 != null && !string2.equals(string3)) break block0;
                    string2 = string3;
                    object2 = LazyList.add(object2, constraintMapping.getConstraint());
                }
            }
            return this.check(object2, this._authenticator, this._userRealm, string, request, response);
        }
        request.setUserPrincipal(this._notChecked);
        return true;
    }

    private boolean check(Object object, Authenticator authenticator, UserRealm userRealm, String string, Request request, Response response) throws IOException {
        Object object2;
        Object object3;
        int n = 0;
        Object object4 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < LazyList.size(object); ++i) {
            object3 = (Constraint)LazyList.get(object, i);
            if (n > -1 && ((Constraint)object3).hasDataConstraint()) {
                if (((Constraint)object3).getDataConstraint() > n) {
                    n = ((Constraint)object3).getDataConstraint();
                }
            } else {
                n = -1;
            }
            if (bl || bl2) continue;
            if (((Constraint)object3).getAuthenticate()) {
                if (((Constraint)object3).isAnyRole()) {
                    object4 = "*";
                    continue;
                }
                object2 = ((Constraint)object3).getRoles();
                if (object2 == null || ((String[])object2).length == 0) {
                    bl2 = true;
                    break;
                }
                if (object4 == "*") continue;
                int n2 = ((String[])object2).length;
                while (n2-- > 0) {
                    object4 = LazyList.add(object4, object2[n2]);
                }
                continue;
            }
            bl = true;
        }
        if (!(!bl2 || authenticator instanceof FormAuthenticator && ((FormAuthenticator)authenticator).isLoginOrErrorPage(string))) {
            response.sendError(403);
            return false;
        }
        if (n > 0) {
            HttpConnection httpConnection = HttpConnection.getCurrentConnection();
            object3 = httpConnection.getConnector();
            switch (n) {
                case 1: {
                    if (object3.isIntegral(request)) break;
                    if (object3.getConfidentialPort() > 0) {
                        object2 = object3.getIntegralScheme() + "://" + request.getServerName() + ":" + object3.getIntegralPort() + request.getRequestURI();
                        if (request.getQueryString() != null) {
                            object2 = (String)object2 + "?" + request.getQueryString();
                        }
                        response.setContentLength(0);
                        response.sendRedirect((String)object2);
                    } else {
                        response.sendError(403, null);
                    }
                    return false;
                }
                case 2: {
                    if (object3.isConfidential(request)) break;
                    if (object3.getConfidentialPort() > 0) {
                        object2 = object3.getConfidentialScheme() + "://" + request.getServerName() + ":" + object3.getConfidentialPort() + request.getRequestURI();
                        if (request.getQueryString() != null) {
                            object2 = (String)object2 + "?" + request.getQueryString();
                        }
                        response.setContentLength(0);
                        response.sendRedirect((String)object2);
                    } else {
                        response.sendError(403, null);
                    }
                    return false;
                }
                default: {
                    response.sendError(403, null);
                    return false;
                }
            }
        }
        if (!bl && object4 != null) {
            if (userRealm == null) {
                Log.warn("Request " + request.getRequestURI() + " failed - no realm");
                response.sendError(500, "No realm");
                return false;
            }
            Principal principal = null;
            if (request.getAuthType() != null && request.getRemoteUser() != null) {
                principal = request.getUserPrincipal();
                if (principal == null) {
                    principal = userRealm.authenticate(request.getRemoteUser(), null, request);
                }
                if (principal == null && authenticator != null) {
                    principal = authenticator.authenticate(userRealm, string, request, response);
                }
            } else if (authenticator != null) {
                principal = authenticator.authenticate(userRealm, string, request, response);
            } else {
                Log.warn("Mis-configured Authenticator for " + request.getRequestURI());
                response.sendError(500, "Configuration error");
            }
            if (principal == null) {
                return false;
            }
            if (principal == __NOBODY) {
                return true;
            }
            if (object4 != "*") {
                boolean bl3 = false;
                int n3 = LazyList.size(object4);
                while (n3-- > 0) {
                    if (!userRealm.isUserInRole(principal, (String)LazyList.get(object4, n3))) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    Log.warn("AUTH FAILURE: incorrect role for " + StringUtil.printable(principal.getName()));
                    response.sendError(403, "User not in required role");
                    return false;
                }
            }
        } else {
            request.setUserPrincipal(this._notChecked);
        }
        return true;
    }

    public class NotChecked
    implements Principal {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

