/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.ServletSSL;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class SslSocketConnector
extends SocketConnector {
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    private String[] _excludeCipherSuites = null;
    private String _keystore = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String _sslTrustManagerFactoryAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    private String _truststore;
    private String _truststoreType = "JKS";
    private boolean _wantClientAuth = false;
    private int _handshakeTimeout = 0;
    private boolean _allowRenegotiate = false;

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sSLSession) {
        try {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                return null;
            }
            int n = x509CertificateArray.length;
            java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[n];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < n; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            return x509CertificateArray2;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
            return null;
        }
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean bl) {
        this._allowRenegotiate = bl;
    }

    @Override
    public void accept(int n) throws IOException, InterruptedException {
        try {
            Socket socket = this._serverSocket.accept();
            this.configure(socket);
            SslConnection sslConnection = new SslConnection(socket);
            ((SocketConnector.Connection)sslConnection).dispatch();
        }
        catch (SSLException sSLException) {
            Log.warn(sSLException);
            try {
                this.stop();
            }
            catch (Exception exception) {
                Log.warn(exception);
                throw new IllegalStateException(exception.getMessage());
            }
        }
    }

    @Override
    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        if (this._truststore == null) {
            this._truststore = this._keystore;
            this._truststoreType = this._keystoreType;
        }
        KeyManager[] keyManagerArray = null;
        InputStream inputStream = null;
        if (this._keystore != null) {
            inputStream = Resource.newResource(this._keystore).getInputStream();
        }
        KeyStore keyStore = KeyStore.getInstance(this._keystoreType);
        keyStore.load(inputStream, this._password == null ? null : this._password.toString().toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, this._keyPassword == null ? null : this._keyPassword.toString().toCharArray());
        keyManagerArray = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagerArray = null;
        InputStream inputStream2 = null;
        if (this._truststore != null) {
            inputStream2 = Resource.newResource(this._truststore).getInputStream();
        }
        KeyStore keyStore2 = KeyStore.getInstance(this._truststoreType);
        keyStore2.load(inputStream2, this._trustPassword == null ? null : this._trustPassword.toString().toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
        trustManagerFactory.init(keyStore2);
        trustManagerArray = trustManagerFactory.getTrustManagers();
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        SSLContext sSLContext = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
        return sSLContext.getServerSocketFactory();
    }

    @Override
    public void customize(EndPoint endPoint, Request request) throws IOException {
        super.customize(endPoint, request);
        request.setScheme("https");
        SocketEndPoint socketEndPoint = (SocketEndPoint)endPoint;
        SSLSocket sSLSocket = (SSLSocket)socketEndPoint.getTransport();
        try {
            java.security.cert.X509Certificate[] x509CertificateArray;
            Integer n;
            SSLSession sSLSession = sSLSocket.getSession();
            String string = sSLSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sSLSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                n = cachedInfo.getKeySize();
                x509CertificateArray = cachedInfo.getCerts();
            } else {
                n = new Integer(ServletSSL.deduceKeyLength(string));
                x509CertificateArray = SslSocketConnector.getCertChain(sSLSession);
                cachedInfo = new CachedInfo(n, x509CertificateArray);
                sSLSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (x509CertificateArray != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
            } else if (this._needClientAuth) {
                throw new IllegalStateException("no client auth");
            }
            request.setAttribute("javax.servlet.request.cipher_suite", string);
            request.setAttribute("javax.servlet.request.key_size", n);
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
        }
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststore;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    @Override
    public boolean isConfidential(Request request) {
        int n = this.getConfidentialPort();
        return n == 0 || n == request.getServerPort();
    }

    @Override
    public boolean isIntegral(Request request) {
        int n = this.getIntegralPort();
        return n == 0 || n == request.getServerPort();
    }

    @Override
    protected ServerSocket newServerSocket(String string, int n, int n2) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        SSLServerSocket sSLServerSocket = null;
        try {
            sSLServerSocketFactory = this.createFactory();
            sSLServerSocket = (SSLServerSocket)(string == null ? sSLServerSocketFactory.createServerSocket(n, n2) : sSLServerSocketFactory.createServerSocket(n, n2, InetAddress.getByName(string)));
            if (this._wantClientAuth) {
                sSLServerSocket.setWantClientAuth(this._wantClientAuth);
            }
            if (this._needClientAuth) {
                sSLServerSocket.setNeedClientAuth(this._needClientAuth);
            }
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0) {
                List<String> list = Arrays.asList(this._excludeCipherSuites);
                String[] stringArray = sSLServerSocket.getEnabledCipherSuites();
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                for (String string2 : list) {
                    if (!arrayList.contains(string2)) continue;
                    arrayList.remove(string2);
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
                sSLServerSocket.setEnabledCipherSuites(stringArray);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Log.warn(exception.toString());
            Log.debug(exception);
            throw new IOException("!JsseListener: " + exception);
        }
        return sSLServerSocket;
    }

    public void setExcludeCipherSuites(String[] stringArray) {
        this._excludeCipherSuites = stringArray;
    }

    public void setKeyPassword(String string) {
        this._keyPassword = Password.getPassword(KEYPASSWORD_PROPERTY, string, null);
    }

    public void setKeystore(String string) {
        this._keystore = string;
    }

    public void setKeystoreType(String string) {
        this._keystoreType = string;
    }

    public void setNeedClientAuth(boolean bl) {
        this._needClientAuth = bl;
    }

    public void setPassword(String string) {
        this._password = Password.getPassword(PASSWORD_PROPERTY, string, null);
    }

    public void setTrustPassword(String string) {
        this._trustPassword = Password.getPassword(PASSWORD_PROPERTY, string, null);
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public void setProvider(String string) {
        this._provider = string;
    }

    public void setSecureRandomAlgorithm(String string) {
        this._secureRandomAlgorithm = string;
    }

    public void setSslKeyManagerFactoryAlgorithm(String string) {
        this._sslKeyManagerFactoryAlgorithm = string;
    }

    public void setSslTrustManagerFactoryAlgorithm(String string) {
        this._sslTrustManagerFactoryAlgorithm = string;
    }

    public void setTruststore(String string) {
        this._truststore = string;
    }

    public void setTruststoreType(String string) {
        this._truststoreType = string;
    }

    public void setWantClientAuth(boolean bl) {
        this._wantClientAuth = bl;
    }

    public void setHandshakeTimeout(int n) {
        this._handshakeTimeout = n;
    }

    public int getHandshakeTimeout() {
        return this._handshakeTimeout;
    }

    public class SslConnection
    extends SocketConnector.Connection {
        public SslConnection(Socket socket) throws IOException {
            super(socket);
        }

        @Override
        public void run() {
            try {
                int n = SslSocketConnector.this.getHandshakeTimeout();
                int n2 = this._socket.getSoTimeout();
                if (n > 0) {
                    this._socket.setSoTimeout(n);
                }
                final SSLSocket sSLSocket = (SSLSocket)this._socket;
                sSLSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){
                    boolean handshook = false;

                    @Override
                    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        if (this.handshook) {
                            if (!SslSocketConnector.this._allowRenegotiate) {
                                Log.warn("SSL renegotiate denied: " + sSLSocket);
                                try {
                                    sSLSocket.close();
                                }
                                catch (IOException iOException) {
                                    Log.warn(iOException);
                                }
                            }
                        } else {
                            this.handshook = true;
                        }
                    }
                });
                sSLSocket.startHandshake();
                if (n > 0) {
                    this._socket.setSoTimeout(n2);
                }
                super.run();
            }
            catch (SSLException sSLException) {
                Log.warn(sSLException);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            catch (IOException iOException) {
                Log.debug(iOException);
                try {
                    this.close();
                }
                catch (IOException iOException2) {
                    Log.ignore(iOException2);
                }
            }
        }
    }

    private class CachedInfo {
        private java.security.cert.X509Certificate[] _certs;
        private Integer _keySize;

        CachedInfo(Integer n, java.security.cert.X509Certificate[] x509CertificateArray) {
            this._keySize = n;
            this._certs = x509CertificateArray;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }
    }
}

