/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.log.Log;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    protected static final String SESSION_ID_RANDOM_ALGORITHM = "SHA1PRNG";
    protected static final String SESSION_ID_RANDOM_ALGORITHM_ALT = "IBMSecureRandom";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected Server _server;

    public AbstractSessionIdManager(Server server) {
        this._server = server;
    }

    public AbstractSessionIdManager(Server server, Random random) {
        this._random = random;
        this._server = server;
    }

    @Override
    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String string) {
        this._workerName = string;
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String newSessionId(HttpServletRequest httpServletRequest, long l) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            String string;
            String string2 = httpServletRequest.getRequestedSessionId();
            if (string2 != null && this.idInUse(string = this.getClusterId(string2))) {
                return string;
            }
            string = (String)httpServletRequest.getAttribute(__NEW_SESSION_ID);
            if (string != null && this.idInUse(string)) {
                return string;
            }
            String string3 = null;
            while (string3 == null || string3.length() == 0 || this.idInUse(string3)) {
                long l2 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)httpServletRequest.hashCode() << 32 : this._random.nextLong();
                l2 ^= l;
                if (httpServletRequest != null && httpServletRequest.getRemoteAddr() != null) {
                    l2 ^= (long)httpServletRequest.getRemoteAddr().hashCode();
                }
                if (l2 < 0L) {
                    l2 = -l2;
                }
                string3 = Long.toString(l2, 36);
                string3 = this._workerName + string3;
            }
            httpServletRequest.setAttribute(__NEW_SESSION_ID, (Object)string3);
            return string3;
        }
    }

    @Override
    public void doStart() {
        this.initRandom();
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM_ALT);
                    this._weakRandom = false;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    Log.warn("Could not generate SecureRandom for session-id randomness", noSuchAlgorithmException);
                    this._random = new Random();
                    this._weakRandom = true;
                }
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
    }
}

