/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.util.LazyList;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    public static final int __distantFuture = 628992000;
    private static final HttpSessionContext __nullSessionContext = new NullSessionContext();
    private boolean _usingCookies = true;
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected int _maxSessions = 0;
    protected int _minSessions = 0;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected Object _sessionAttributeListeners;
    protected Object _sessionListeners;
    protected ClassLoader _loader;
    protected ContextHandler.SContext _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionURL = "jsessionid";
    protected String _sessionURLPrefix = ";" + this._sessionURL + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;

    @Override
    public Cookie access(HttpSession httpSession, boolean bl) {
        long l = System.currentTimeMillis();
        Session session = ((SessionIf)httpSession).getSession();
        session.access(l);
        if (this.isUsingCookies() && (session.isIdChanged() || this.getMaxCookieAge() > 0 && this.getRefreshCookieAge() > 0 && (l - session.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            Cookie cookie = this.getSessionCookie(httpSession, this._context.getContextPath(), bl);
            session.cookieSet();
            session.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        if (eventListener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.add(this._sessionAttributeListeners, eventListener);
        }
        if (eventListener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.add(this._sessionListeners, eventListener);
        }
    }

    @Override
    public void clearEventListeners() {
        this._sessionAttributeListeners = null;
        this._sessionListeners = null;
    }

    @Override
    public void complete(HttpSession httpSession) {
        Session session = ((SessionIf)httpSession).getSession();
        session.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        Object object;
        Object object2;
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessionIdManager == null) {
            object = object2 = this.getSessionHandler().getServer();
            synchronized (object) {
                this._sessionIdManager = ((Server)object2).getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    ((Server)object2).setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if ((object2 = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionCookie")) != null) {
            this._sessionCookie = object2;
        }
        if ((object2 = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionURL")) != null) {
            this._sessionURL = object2 == null || "none".equals(object2) ? null : object2;
            String string = this._sessionURLPrefix = object2 == null || "none".equals(object2) ? null : ";" + this._sessionURL + "=";
        }
        if (this._maxCookieAge == -1 && this._context != null && (object = this._context.getInitParameter("org.mortbay.jetty.servlet.MaxAge")) != null) {
            this._maxCookieAge = Integer.parseInt(((String)object).trim());
        }
        if (this._sessionDomain == null && this._context != null) {
            this._sessionDomain = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
        }
        if (this._sessionPath == null && this._context != null) {
            this._sessionPath = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionPath");
        }
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.invalidateSessions();
        this._loader = null;
    }

    @Override
    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getHttpSession(String string) {
        String string2 = this.getIdManager().getClusterId(string);
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            Session session = this.getSession(string2);
            if (session != null && !session.getNodeId().equals(string)) {
                session.setIdChanged(true);
            }
            return session;
        }
    }

    @Override
    public SessionIdManager getIdManager() {
        return this._sessionIdManager;
    }

    @Override
    public int getMaxCookieAge() {
        return this._maxCookieAge;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    @Override
    public SessionIdManager getMetaManager() {
        return this.getIdManager();
    }

    public int getMinSessions() {
        return this._minSessions;
    }

    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @Override
    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    @Override
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    @Override
    public Cookie getSessionCookie(HttpSession httpSession, String string, boolean bl) {
        if (this.isUsingCookies()) {
            String string2 = this.getNodeId(httpSession);
            HttpOnlyCookie httpOnlyCookie = this.getHttpOnly() ? new HttpOnlyCookie(this._sessionCookie, string2) : new Cookie(this._sessionCookie, string2);
            httpOnlyCookie.setPath(string == null || string.length() == 0 ? "/" : string);
            httpOnlyCookie.setMaxAge(this.getMaxCookieAge());
            httpOnlyCookie.setSecure(bl && this.getSecureCookies());
            if (this._sessionDomain != null) {
                httpOnlyCookie.setDomain(this._sessionDomain);
            }
            if (this._sessionPath != null) {
                httpOnlyCookie.setPath(this._sessionPath);
            }
            return httpOnlyCookie;
        }
        return null;
    }

    @Override
    public String getSessionDomain() {
        return this._sessionDomain;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public abstract Map getSessionMap();

    @Override
    public String getSessionPath() {
        return this._sessionPath;
    }

    public abstract int getSessions();

    @Override
    public String getSessionURL() {
        return this._sessionURL;
    }

    @Override
    public String getSessionURLPrefix() {
        return this._sessionURLPrefix;
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public boolean isValid(HttpSession httpSession) {
        Session session = ((SessionIf)httpSession).getSession();
        return session.isValid();
    }

    @Override
    public String getClusterId(HttpSession httpSession) {
        Session session = ((SessionIf)httpSession).getSession();
        return session.getClusterId();
    }

    @Override
    public String getNodeId(HttpSession httpSession) {
        Session session = ((SessionIf)httpSession).getSession();
        return session.getNodeId();
    }

    @Override
    public HttpSession newHttpSession(HttpServletRequest httpServletRequest) {
        Session session = this.newSession(httpServletRequest);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        if (eventListener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.remove(this._sessionAttributeListeners, eventListener);
        }
        if (eventListener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.remove(this._sessionListeners, eventListener);
        }
    }

    public void resetStats() {
        this._minSessions = this.getSessions();
        this._maxSessions = this.getSessions();
    }

    public void setHttpOnly(boolean bl) {
        this._httpOnly = bl;
    }

    @Override
    public void setIdManager(SessionIdManager sessionIdManager) {
        this._sessionIdManager = sessionIdManager;
    }

    @Override
    public void setMaxCookieAge(int n) {
        this._maxCookieAge = n;
        if (this._maxCookieAge > 0 && this._refreshCookieAge == 0) {
            this._refreshCookieAge = this._maxCookieAge / 3;
        }
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this._dftMaxIdleSecs = n;
    }

    public void setMetaManager(SessionIdManager sessionIdManager) {
        this.setIdManager(sessionIdManager);
    }

    public void setRefreshCookieAge(int n) {
        this._refreshCookieAge = n;
    }

    public void setSecureCookies(boolean bl) {
        this._secureCookies = bl;
    }

    @Override
    public void setSessionCookie(String string) {
        this._sessionCookie = string;
    }

    @Override
    public void setSessionDomain(String string) {
        this._sessionDomain = string;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    @Override
    public void setSessionPath(String string) {
        this._sessionPath = string;
    }

    @Override
    public void setSessionURL(String string) {
        this._sessionURL = string == null || "none".equals(string) ? null : string;
        this._sessionURLPrefix = string == null || "none".equals(string) ? null : ";" + this._sessionURL + "=";
    }

    public void setUsingCookies(boolean bl) {
        this._usingCookies = bl;
    }

    protected abstract void addSession(Session var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session, boolean bl) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this.addSession(session);
                if (this.getSessions() > this._maxSessions) {
                    this._maxSessions = this.getSessions();
                }
            }
        }
        if (!bl) {
            session.didActivate();
        } else if (this._sessionListeners != null) {
            sessionIdManager = new HttpSessionEvent((HttpSession)session);
            for (int i = 0; i < LazyList.size(this._sessionListeners); ++i) {
                ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionCreated((HttpSessionEvent)sessionIdManager);
            }
        }
    }

    public abstract Session getSession(String var1);

    protected abstract void invalidateSessions();

    protected abstract Session newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean bl) {
        this._nodeIdInSessionId = bl;
    }

    public void removeSession(HttpSession httpSession, boolean bl) {
        Session session = ((SessionIf)httpSession).getSession();
        this.removeSession(session, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session, boolean bl) {
        int n;
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            n = 0;
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                if (this.getSession(session.getClusterId()) != null) {
                    n = 1;
                    this.removeSession(session.getClusterId());
                }
            }
            if (n != 0) {
                this._sessionIdManager.removeSession(session);
                if (bl) {
                    this._sessionIdManager.invalidateAll(session.getClusterId());
                }
            }
        }
        if (bl && this._sessionListeners != null) {
            sessionIdManager = new HttpSessionEvent((HttpSession)session);
            n = LazyList.size(this._sessionListeners);
            while (n-- > 0) {
                ((HttpSessionListener)LazyList.get(this._sessionListeners, n)).sessionDestroyed((HttpSessionEvent)sessionIdManager);
            }
        }
        if (!bl) {
            session.willPassivate();
        }
    }

    protected abstract void removeSession(String var1);

    public abstract class Session
    implements SessionIf,
    Serializable {
        protected final String _clusterId;
        protected final String _nodeId;
        protected boolean _idChanged;
        protected final long _created;
        protected long _cookieSet;
        protected long _accessed;
        protected long _lastAccessed;
        protected boolean _invalid;
        protected boolean _doInvalidate;
        protected long _maxIdleMs;
        protected boolean _newSession;
        protected Map _values;
        protected int _requests;

        protected Session(HttpServletRequest httpServletRequest) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            this._newSession = true;
            this._created = System.currentTimeMillis();
            this._clusterId = AbstractSessionManager.this._sessionIdManager.newSessionId(httpServletRequest, this._created);
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, httpServletRequest);
            this._accessed = this._created;
            this._requests = 1;
        }

        protected Session(long l, String string) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            this._created = l;
            this._clusterId = string;
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, null);
            this._accessed = this._created;
        }

        @Override
        public Session getSession() {
            return this;
        }

        protected void initValues() {
            this._values = this.newAttributeMap();
        }

        public synchronized Object getAttribute(String string) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (null == this._values) {
                return null;
            }
            return this._values.get(string);
        }

        public synchronized Enumeration getAttributeNames() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            List<Object> list = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
            return Collections.enumeration(list);
        }

        public long getCookieSetTime() {
            return this._cookieSet;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public String getId() throws IllegalStateException {
            return AbstractSessionManager.this._nodeIdInSessionId ? this._nodeId : this._clusterId;
        }

        protected String getNodeId() {
            return this._nodeId;
        }

        protected String getClusterId() {
            return this._clusterId;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._lastAccessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._context;
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return __nullSessionContext;
        }

        public Object getValue(String string) throws IllegalStateException {
            return this.getAttribute(string);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] stringArray = new String[this._values.size()];
            return this._values.keySet().toArray(stringArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void access(long l) {
            Session session = this;
            synchronized (session) {
                this._newSession = false;
                this._lastAccessed = this._accessed;
                this._accessed = l;
                ++this._requests;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() {
            Session session = this;
            synchronized (session) {
                --this._requests;
                if (this._doInvalidate && this._requests <= 0) {
                    this.doInvalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            Session session = this;
            synchronized (session) {
                if (this._requests <= 0) {
                    this.doInvalidate();
                } else {
                    this._doInvalidate = true;
                }
            }
        }

        public void invalidate() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            this.doInvalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInvalidate() throws IllegalStateException {
            try {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                while (this._values != null && this._values.size() > 0) {
                    ArrayList arrayList;
                    Session session = this;
                    synchronized (session) {
                        arrayList = new ArrayList(this._values.keySet());
                    }
                    for (String string : arrayList) {
                        Object v;
                        Session session2 = this;
                        synchronized (session2) {
                            v = this._values.remove(string);
                        }
                        this.unbindValue(string, v);
                        if (AbstractSessionManager.this._sessionAttributeListeners == null) continue;
                        session2 = new HttpSessionBindingEvent((HttpSession)this, string, v);
                        for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                            ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved((HttpSessionBindingEvent)session2);
                        }
                    }
                }
            }
            finally {
                this._invalid = true;
            }
        }

        public boolean isIdChanged() {
            return this._idChanged;
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        public void putValue(String string, Object object) throws IllegalStateException {
            this.setAttribute(string, object);
        }

        public synchronized void removeAttribute(String string) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return;
            }
            Object v = this._values.remove(string);
            if (v != null) {
                this.unbindValue(string, v);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, v);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(httpSessionBindingEvent);
                    }
                }
            }
        }

        public void removeValue(String string) throws IllegalStateException {
            this.removeAttribute(string);
        }

        public synchronized void setAttribute(String string, Object object) {
            Object object2;
            if (object == null) {
                this.removeAttribute(string);
                return;
            }
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                this._values = this.newAttributeMap();
            }
            if ((object2 = this._values.put(string, object)) == null || !object.equals(object2)) {
                this.unbindValue(string, object2);
                this.bindValue(string, object);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object2 == null ? object : object2);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i);
                        if (object2 == null) {
                            httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
                            continue;
                        }
                        if (object == null) {
                            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                            continue;
                        }
                        httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
                    }
                }
            }
        }

        public void setIdChanged(boolean bl) {
            this._idChanged = bl;
        }

        public void setMaxInactiveInterval(int n) {
            this._maxIdleMs = (long)n * 1000L;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
        }

        protected void bindValue(String string, Object object) {
            if (object != null && object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
        }

        protected boolean isValid() {
            return !this._invalid;
        }

        protected abstract Map newAttributeMap();

        protected void cookieSet() {
            this._cookieSet = this._accessed;
        }

        protected void unbindValue(String string, Object object) {
            if (object != null && object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
        }

        protected synchronized void willPassivate() {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
            for (Object v : this._values.values()) {
                if (!(v instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener httpSessionActivationListener = (HttpSessionActivationListener)v;
                httpSessionActivationListener.sessionWillPassivate(httpSessionEvent);
            }
        }

        protected synchronized void didActivate() {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
            for (Object v : this._values.values()) {
                if (!(v instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener httpSessionActivationListener = (HttpSessionActivationListener)v;
                httpSessionActivationListener.sessionDidActivate(httpSessionEvent);
            }
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public Session getSession();
    }

    public static class NullSessionContext
    implements HttpSessionContext {
        private NullSessionContext() {
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public HttpSession getSession(String string) {
            return null;
        }
    }
}

