/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import javax.servlet.RequestDispatcher;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.log.Log;
import org.mortbay.util.URIUtil;

public class Context
extends ContextHandler {
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected SessionHandler _sessionHandler;

    public Context() {
        this(null, null, null, null, null);
    }

    public Context(int n) {
        this(null, null, n);
    }

    public Context(HandlerContainer handlerContainer, String string) {
        this(handlerContainer, string, null, null, null, null);
    }

    public Context(HandlerContainer handlerContainer, String string, int n) {
        this(handlerContainer, string, (n & 1) != 0 ? new SessionHandler() : null, (n & 2) != 0 ? new SecurityHandler() : null, null, null);
    }

    public Context(HandlerContainer handlerContainer, String string, boolean bl, boolean bl2) {
        this(handlerContainer, string, (bl ? 1 : 0) | (bl2 ? 2 : 0));
    }

    public Context(HandlerContainer handlerContainer, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(handlerContainer, null, sessionHandler, securityHandler, servletHandler, errorHandler);
    }

    public Context(HandlerContainer handlerContainer, String string, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super((ContextHandler.SContext)null);
        this._scontext = new SContext();
        this._sessionHandler = sessionHandler;
        this._securityHandler = securityHandler;
        ServletHandler servletHandler2 = this._servletHandler = servletHandler != null ? servletHandler : new ServletHandler();
        if (this._sessionHandler != null) {
            this.setHandler(this._sessionHandler);
            if (securityHandler != null) {
                this._sessionHandler.setHandler(this._securityHandler);
                this._securityHandler.setHandler(this._servletHandler);
            } else {
                this._sessionHandler.setHandler(this._servletHandler);
            }
        } else if (this._securityHandler != null) {
            this.setHandler(this._securityHandler);
            this._securityHandler.setHandler(this._servletHandler);
        } else {
            this.setHandler(this._servletHandler);
        }
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (string != null) {
            this.setContextPath(string);
        }
        if (handlerContainer != null) {
            handlerContainer.addHandler(this);
        }
    }

    @Override
    protected void startContext() throws Exception {
        super.startContext();
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            this._servletHandler.initialize();
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this._securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public ServletHolder addServlet(String string, String string2) {
        return this._servletHandler.addServletWithMapping(string, string2);
    }

    public ServletHolder addServlet(Class clazz, String string) {
        return this._servletHandler.addServletWithMapping(clazz.getName(), string);
    }

    public void addServlet(ServletHolder servletHolder, String string) {
        this._servletHandler.addServletWithMapping(servletHolder, string);
    }

    public void addFilter(FilterHolder filterHolder, String string, int n) {
        this._servletHandler.addFilterWithMapping(filterHolder, string, n);
    }

    public FilterHolder addFilter(Class clazz, String string, int n) {
        return this._servletHandler.addFilterWithMapping(clazz, string, n);
    }

    public FilterHolder addFilter(String string, String string2, int n) {
        return this._servletHandler.addFilterWithMapping(string, string2, n);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        if (this._sessionHandler == sessionHandler) {
            return;
        }
        if (this._sessionHandler != null) {
            this._sessionHandler.setHandler(null);
        }
        this._sessionHandler = sessionHandler;
        this.setHandler(this._sessionHandler);
        if (this._securityHandler != null) {
            this._sessionHandler.setHandler(this._securityHandler);
        } else if (this._servletHandler != null) {
            this._sessionHandler.setHandler(this._servletHandler);
        }
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        if (this._securityHandler == securityHandler) {
            return;
        }
        if (this._securityHandler != null) {
            this._securityHandler.setHandler(null);
        }
        this._securityHandler = securityHandler;
        if (this._securityHandler == null) {
            if (this._sessionHandler != null) {
                this._sessionHandler.setHandler(this._servletHandler);
            } else {
                this.setHandler(this._servletHandler);
            }
        } else {
            if (this._sessionHandler != null) {
                this._sessionHandler.setHandler(this._securityHandler);
            } else {
                this.setHandler(this._securityHandler);
            }
            if (this._servletHandler != null) {
                this._securityHandler.setHandler(this._servletHandler);
            }
        }
    }

    public void setServletHandler(ServletHandler servletHandler) {
        if (this._servletHandler == servletHandler) {
            return;
        }
        this._servletHandler = servletHandler;
        if (this._securityHandler != null) {
            this._securityHandler.setHandler(this._servletHandler);
        } else if (this._sessionHandler != null) {
            this._sessionHandler.setHandler(this._servletHandler);
        } else {
            this.setHandler(this._servletHandler);
        }
    }

    public class SContext
    extends ContextHandler.SContext {
        @Override
        public RequestDispatcher getNamedDispatcher(String string) {
            Context context = Context.this;
            if (Context.this._servletHandler == null || Context.this._servletHandler.getServlet(string) == null) {
                return null;
            }
            return new Dispatcher(context, string);
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String string) {
            if (string == null) {
                return null;
            }
            if (!string.startsWith("/")) {
                return null;
            }
            try {
                String string2 = null;
                int n = 0;
                n = string.indexOf(63);
                if (n > 0) {
                    string2 = string.substring(n + 1);
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(59)) > 0) {
                    string = string.substring(0, n);
                }
                String string3 = URIUtil.canonicalPath(URIUtil.decodePath(string));
                String string4 = URIUtil.addPaths(this.getContextPath(), string);
                Context context = Context.this;
                return new Dispatcher(context, string4, string3, string2);
            }
            catch (Exception exception) {
                Log.ignore(exception);
                return null;
            }
        }
    }
}

