/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.io.nio.DirectNIOBuffer;
import org.mortbay.io.nio.IndirectNIOBuffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.InclusiveByteRange;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.ResourceCache;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.NIOConnector;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.resource.FileResource;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;
import org.mortbay.util.IO;
import org.mortbay.util.MultiPartOutputStream;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private ContextHandler.SContext _context;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _welcomeServlets = false;
    private boolean _redirectWelcome = false;
    private boolean _gzip = true;
    private Resource _resourceBase;
    private NIOResourceCache _nioCache;
    private ResourceCache _bioCache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private boolean _aliases = false;
    private boolean _useFileMappedBuffer = false;
    ByteArrayBuffer _cacheControl;
    private ServletHandler _servletHandler;
    private ServletHolder _defaultHolder;

    public void init() throws UnavailableException {
        int n;
        ServletHolder[] servletHolderArray;
        String string;
        ServletContext servletContext = this.getServletContext();
        this._context = (ContextHandler.SContext)servletContext;
        this._mimeTypes = this._context.getContextHandler().getMimeTypes();
        this._welcomes = this._context.getContextHandler().getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.jsp", "index.html"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        this._aliases = this.getInitBoolean("aliases", this._aliases);
        if (!this._aliases && !FileResource.getCheckAliases()) {
            throw new IllegalStateException("Alias checking disabled");
        }
        if (this._aliases) {
            servletContext.log("Aliases are enabled");
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        String string2 = this.getInitParameter("relativeResourceBase");
        if (string2 != null) {
            try {
                this._resourceBase = this._context.getContextHandler().getResource("/").addPath(string2);
            }
            catch (Exception exception) {
                Log.warn("EXCEPTION ", exception);
                throw new UnavailableException(exception.toString());
            }
        }
        String string3 = this.getInitParameter("resourceBase");
        if (string2 != null && string3 != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (string3 != null) {
            try {
                this._resourceBase = Resource.newResource(string3);
            }
            catch (Exception exception) {
                Log.warn("EXCEPTION ", exception);
                throw new UnavailableException(exception.toString());
            }
        }
        if ((string = this.getInitParameter("cacheControl")) != null) {
            this._cacheControl = new ByteArrayBuffer(string);
        }
        try {
            if (this._resourceBase == null) {
                this._resourceBase = this._context.getContextHandler().getResource("/");
            }
            servletHolderArray = this.getInitParameter("cacheType");
            n = this.getInitInt("maxCacheSize", -2);
            int n2 = this.getInitInt("maxCachedFileSize", -2);
            int n3 = this.getInitInt("maxCachedFiles", -2);
            if ((servletHolderArray == null || "nio".equals(servletHolderArray) || "both".equals(servletHolderArray)) && (n == -2 || n > 0)) {
                this._nioCache = new NIOResourceCache(this._mimeTypes);
                if (n > 0) {
                    this._nioCache.setMaxCacheSize(n);
                }
                if (n2 >= -1) {
                    this._nioCache.setMaxCachedFileSize(n2);
                }
                if (n3 >= -1) {
                    this._nioCache.setMaxCachedFiles(n3);
                }
                this._nioCache.start();
            }
            if (("bio".equals(servletHolderArray) || "both".equals(servletHolderArray)) && (n == -2 || n > 0)) {
                this._bioCache = new ResourceCache(this._mimeTypes);
                if (n > 0) {
                    this._bioCache.setMaxCacheSize(n);
                }
                if (n2 >= -1) {
                    this._bioCache.setMaxCachedFileSize(n2);
                }
                if (n3 >= -1) {
                    this._bioCache.setMaxCachedFiles(n3);
                }
                this._bioCache.start();
            }
            if (this._nioCache == null) {
                this._bioCache = null;
            }
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
            throw new UnavailableException(exception.toString());
        }
        this._servletHandler = (ServletHandler)this._context.getContextHandler().getChildHandlerByClass(ServletHandler.class);
        servletHolderArray = this._servletHandler.getServlets();
        n = servletHolderArray.length;
        while (n-- > 0) {
            if (servletHolderArray[n].getServletInstance() != this) continue;
            this._defaultHolder = servletHolderArray[n];
        }
        if (Log.isDebugEnabled()) {
            Log.debug("resource base = " + this._resourceBase);
        }
    }

    public String getInitParameter(String string) {
        String string2 = this.getServletContext().getInitParameter("org.mortbay.jetty.servlet.Default." + string);
        if (string2 == null) {
            string2 = super.getInitParameter(string);
        }
        return string2;
    }

    private boolean getInitBoolean(String string, boolean bl) {
        String string2 = this.getInitParameter(string);
        if (string2 == null || string2.length() == 0) {
            return bl;
        }
        return string2.startsWith("t") || string2.startsWith("T") || string2.startsWith("y") || string2.startsWith("Y") || string2.startsWith("1");
    }

    private int getInitInt(String string, int n) {
        String string2 = this.getInitParameter(string);
        if (string2 == null) {
            string2 = this.getInitParameter(string);
        }
        if (string2 != null && string2.length() > 0) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    @Override
    public Resource getResource(String string) {
        if (this._resourceBase == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this._resourceBase.addPath(string);
            if (!this._aliases && resource.getAlias() != null) {
                if (resource.exists()) {
                    Log.warn("Aliased resource: " + resource + "==" + resource.getAlias());
                }
                return null;
            }
            if (Log.isDebugEnabled()) {
                Log.debug("RESOURCE=" + resource);
            }
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = null;
        String string2 = null;
        Enumeration enumeration = null;
        Boolean bl = (Boolean)httpServletRequest.getAttribute("org.mortbay.jetty.included");
        if (bl != null && bl.booleanValue()) {
            string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (string == null) {
                string = httpServletRequest.getServletPath();
                string2 = httpServletRequest.getPathInfo();
            }
        } else {
            bl = Boolean.FALSE;
            string = httpServletRequest.getServletPath();
            string2 = httpServletRequest.getPathInfo();
            enumeration = httpServletRequest.getHeaders("Range");
            if (enumeration != null && !enumeration.hasMoreElements()) {
                enumeration = null;
            }
        }
        String string3 = URIUtil.addPaths(string, string2);
        boolean bl2 = string3.endsWith("/");
        String string4 = null;
        boolean bl3 = false;
        if (!bl.booleanValue() && this._gzip && enumeration == null && !bl2 && (object = httpServletRequest.getHeader("Accept-Encoding")) != null && ((String)object).indexOf("gzip") >= 0) {
            bl3 = true;
        }
        object = null;
        HttpContent httpContent = null;
        Connector connector = HttpConnection.getCurrentConnection().getConnector();
        ResourceCache resourceCache = connector instanceof NIOConnector ? this._nioCache : this._bioCache;
        try {
            if (bl3) {
                string4 = string3 + ".gz";
                object = this.getResource(string4);
                if (object == null || !((Resource)object).exists() || ((Resource)object).isDirectory()) {
                    bl3 = false;
                    string4 = null;
                } else if (resourceCache != null && (httpContent = resourceCache.lookup(string4, (Resource)object)) != null) {
                    object = httpContent.getResource();
                }
                if (object == null || !((Resource)object).exists() || ((Resource)object).isDirectory()) {
                    bl3 = false;
                    string4 = null;
                }
            }
            if (!bl3) {
                object = resourceCache == null ? this.getResource(string3) : ((httpContent = resourceCache.lookup(string3, this)) != null ? httpContent.getResource() : this.getResource(string3));
            }
            if (Log.isDebugEnabled()) {
                Log.debug("resource=" + object + (httpContent != null ? " content" : ""));
            }
            if (object == null || !((Resource)object).exists()) {
                httpServletResponse.sendError(404);
            } else if (!((Resource)object).isDirectory()) {
                if (bl2 && this._aliases && string3.length() > 1) {
                    String string5 = httpServletRequest.getQueryString();
                    string3 = string3.substring(0, string3.length() - 1);
                    if (string5 != null && string5.length() != 0) {
                        string3 = string3 + "?" + string5;
                    }
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URIUtil.addPaths(this._context.getContextPath(), string3)));
                } else {
                    if (httpContent == null) {
                        httpContent = new UnCachedContent((Resource)object);
                    }
                    if (bl.booleanValue() || this.passConditionalHeaders(httpServletRequest, httpServletResponse, (Resource)object, httpContent)) {
                        if (bl3) {
                            httpServletResponse.setHeader("Content-Encoding", "gzip");
                            String string6 = this._context.getMimeType(string3);
                            if (string6 != null) {
                                httpServletResponse.setContentType(string6);
                            }
                        }
                        this.sendData(httpServletRequest, httpServletResponse, bl, (Resource)object, httpContent, enumeration);
                    }
                }
            } else {
                String string7 = null;
                if (!bl2 || string3.length() == 1 && httpServletRequest.getAttribute("org.mortbay.jetty.nullPathInfo") != null) {
                    StringBuffer stringBuffer = httpServletRequest.getRequestURL();
                    int n = stringBuffer.lastIndexOf(";");
                    if (n < 0) {
                        stringBuffer.append('/');
                    } else {
                        stringBuffer.insert(n, '/');
                    }
                    String string8 = httpServletRequest.getQueryString();
                    if (string8 != null && string8.length() != 0) {
                        stringBuffer.append('?');
                        stringBuffer.append(string8);
                    }
                    httpServletResponse.setContentLength(0);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(stringBuffer.toString()));
                } else {
                    string7 = this.getWelcomeFile(string3);
                    if (null != string7) {
                        if (this._redirectWelcome) {
                            httpServletResponse.setContentLength(0);
                            String string9 = httpServletRequest.getQueryString();
                            if (string9 != null && string9.length() != 0) {
                                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URIUtil.addPaths(this._context.getContextPath(), string7) + "?" + string9));
                            } else {
                                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URIUtil.addPaths(this._context.getContextPath(), string7)));
                            }
                        } else {
                            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string7);
                            if (requestDispatcher != null) {
                                if (bl.booleanValue()) {
                                    requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                                } else {
                                    httpServletRequest.setAttribute("org.mortbay.jetty.welcome", (Object)string7);
                                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                                }
                            }
                        }
                    } else {
                        httpContent = new UnCachedContent((Resource)object);
                        if (bl.booleanValue() || this.passConditionalHeaders(httpServletRequest, httpServletResponse, (Resource)object, httpContent)) {
                            this.sendDirectory(httpServletRequest, httpServletResponse, (Resource)object, string3.length() > 1);
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.warn("EXCEPTION ", illegalArgumentException);
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(500, illegalArgumentException.getMessage());
            }
        }
        finally {
            if (httpContent != null) {
                httpContent.release();
            } else if (object != null) {
                ((Resource)object).release();
            }
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(405);
    }

    private String getWelcomeFile(String string) throws MalformedURLException, IOException {
        if (this._welcomes == null) {
            return null;
        }
        String string2 = null;
        for (int i = 0; i < this._welcomes.length; ++i) {
            PathMap.Entry entry;
            String string3 = URIUtil.addPaths(string, this._welcomes[i]);
            Resource resource = this.getResource(string3);
            if (resource != null && resource.exists()) {
                return this._welcomes[i];
            }
            if (!this._welcomeServlets || string2 != null || (entry = this._servletHandler.getHolderEntry(string3)) == null || entry.getValue() == this._defaultHolder) continue;
            string2 = string3;
        }
        return string2;
    }

    protected boolean passConditionalHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Resource resource, HttpContent httpContent) throws IOException {
        try {
            if (!httpServletRequest.getMethod().equals("HEAD")) {
                long l;
                String string = httpServletRequest.getHeader("If-Modified-Since");
                if (string != null) {
                    Buffer buffer;
                    if (httpContent != null && (buffer = httpContent.getLastModified()) != null && string.equals(buffer.toString())) {
                        httpServletResponse.reset();
                        httpServletResponse.setStatus(304);
                        httpServletResponse.flushBuffer();
                        return false;
                    }
                    l = httpServletRequest.getDateHeader("If-Modified-Since");
                    if (l != -1L && resource.lastModified() / 1000L <= l / 1000L) {
                        httpServletResponse.reset();
                        httpServletResponse.setStatus(304);
                        httpServletResponse.flushBuffer();
                        return false;
                    }
                }
                if ((l = httpServletRequest.getDateHeader("If-Unmodified-Since")) != -1L && resource.lastModified() / 1000L > l / 1000L) {
                    httpServletResponse.sendError(412);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(400, illegalArgumentException.getMessage());
            }
            throw illegalArgumentException;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Resource resource, boolean bl) throws IOException {
        if (!this._dirAllowed) {
            httpServletResponse.sendError(403);
            return;
        }
        byte[] byArray = null;
        String string = URIUtil.addPaths(httpServletRequest.getRequestURI(), "/");
        String string2 = resource.getListHTML(string, bl);
        if (string2 == null) {
            httpServletResponse.sendError(403, "No directory");
            return;
        }
        byArray = string2.getBytes("UTF-8");
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        httpServletResponse.setContentLength(byArray.length);
        httpServletResponse.getOutputStream().write(byArray);
    }

    protected void sendData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, Resource resource, HttpContent httpContent, Enumeration enumeration) throws IOException {
        long l = resource.length();
        Object object = null;
        try {
            object = httpServletResponse.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            object = new WriterOutputStream(httpServletResponse.getWriter());
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            if (bl) {
                resource.writeTo((OutputStream)object, 0L, l);
            } else if (object instanceof HttpConnection.Output) {
                if (httpServletResponse instanceof Response) {
                    this.writeOptionHeaders(((Response)httpServletResponse).getHttpFields());
                    ((HttpConnection.Output)((Object)object)).sendContent(httpContent);
                } else if (httpContent.getBuffer() != null) {
                    this.writeHeaders(httpServletResponse, httpContent, l);
                    ((HttpConnection.Output)((Object)object)).sendContent(httpContent.getBuffer());
                } else {
                    this.writeHeaders(httpServletResponse, httpContent, l);
                    resource.writeTo((OutputStream)object, 0L, l);
                }
            } else {
                this.writeHeaders(httpServletResponse, httpContent, l);
                resource.writeTo((OutputStream)object, 0L, l);
            }
        } else {
            InclusiveByteRange inclusiveByteRange;
            int n;
            List list = InclusiveByteRange.satisfiableRanges(enumeration, l);
            if (list == null || list.size() == 0) {
                this.writeHeaders(httpServletResponse, httpContent, l);
                httpServletResponse.setStatus(416);
                httpServletResponse.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(l));
                resource.writeTo((OutputStream)object, 0L, l);
                return;
            }
            if (list.size() == 1) {
                InclusiveByteRange inclusiveByteRange2 = (InclusiveByteRange)list.get(0);
                long l2 = inclusiveByteRange2.getSize(l);
                this.writeHeaders(httpServletResponse, httpContent, l2);
                httpServletResponse.setStatus(206);
                httpServletResponse.setHeader("Content-Range", inclusiveByteRange2.toHeaderRangeString(l));
                resource.writeTo((OutputStream)object, inclusiveByteRange2.getFirst(l), l2);
                return;
            }
            this.writeHeaders(httpServletResponse, httpContent, -1L);
            String string = httpContent.getContentType().toString();
            MultiPartOutputStream multiPartOutputStream = new MultiPartOutputStream((OutputStream)object);
            httpServletResponse.setStatus(206);
            String string2 = httpServletRequest.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            httpServletResponse.setContentType(string2 + multiPartOutputStream.getBoundary());
            InputStream inputStream = resource.getInputStream();
            long l3 = 0L;
            int n2 = 0;
            String[] stringArray = new String[list.size()];
            for (n = 0; n < list.size(); ++n) {
                inclusiveByteRange = (InclusiveByteRange)list.get(n);
                stringArray[n] = inclusiveByteRange.toHeaderRangeString(l);
                n2 = (int)((long)n2 + ((long)((n > 0 ? 2 : 0) + 2 + multiPartOutputStream.getBoundary().length() + 2 + "Content-Type".length() + 2 + string.length() + 2 + "Content-Range".length() + 2 + stringArray[n].length() + 2 + 2) + (inclusiveByteRange.getLast(l) - inclusiveByteRange.getFirst(l)) + 1L));
            }
            httpServletResponse.setContentLength(n2 += 4 + multiPartOutputStream.getBoundary().length() + 2 + 2);
            for (n = 0; n < list.size(); ++n) {
                inclusiveByteRange = (InclusiveByteRange)list.get(n);
                multiPartOutputStream.startPart(string, new String[]{"Content-Range: " + stringArray[n]});
                long l4 = inclusiveByteRange.getFirst(l);
                long l5 = inclusiveByteRange.getSize(l);
                if (inputStream != null) {
                    if (l4 < l3) {
                        inputStream.close();
                        inputStream = resource.getInputStream();
                        l3 = 0L;
                    }
                    if (l3 < l4) {
                        inputStream.skip(l4 - l3);
                        l3 = l4;
                    }
                    IO.copy(inputStream, multiPartOutputStream, l5);
                    l3 += l5;
                    continue;
                }
                resource.writeTo(multiPartOutputStream, l4, l5);
            }
            if (inputStream != null) {
                inputStream.close();
            }
            multiPartOutputStream.close();
        }
    }

    protected void writeHeaders(HttpServletResponse httpServletResponse, HttpContent httpContent, long l) throws IOException {
        if (httpContent.getContentType() != null && httpServletResponse.getContentType() == null) {
            httpServletResponse.setContentType(httpContent.getContentType().toString());
        }
        if (httpServletResponse instanceof Response) {
            long l2;
            Response response = (Response)httpServletResponse;
            HttpFields httpFields = response.getHttpFields();
            if (httpContent.getLastModified() != null) {
                httpFields.put(HttpHeaders.LAST_MODIFIED_BUFFER, httpContent.getLastModified(), httpContent.getResource().lastModified());
            } else if (httpContent.getResource() != null && (l2 = httpContent.getResource().lastModified()) != -1L) {
                httpFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, l2);
            }
            if (l != -1L) {
                response.setLongContentLength(l);
            }
            this.writeOptionHeaders(httpFields);
        } else {
            long l3 = httpContent.getResource().lastModified();
            if (l3 >= 0L) {
                httpServletResponse.setDateHeader("Last-Modified", l3);
            }
            if (l != -1L) {
                if (l < Integer.MAX_VALUE) {
                    httpServletResponse.setContentLength((int)l);
                } else {
                    httpServletResponse.setHeader("Content-Length", TypeUtil.toString(l));
                }
            }
            this.writeOptionHeaders(httpServletResponse);
        }
    }

    protected void writeOptionHeaders(HttpFields httpFields) throws IOException {
        if (this._acceptRanges) {
            httpFields.put(HttpHeaders.ACCEPT_RANGES_BUFFER, HttpHeaderValues.BYTES_BUFFER);
        }
        if (this._cacheControl != null) {
            httpFields.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
        }
    }

    protected void writeOptionHeaders(HttpServletResponse httpServletResponse) throws IOException {
        if (this._acceptRanges) {
            httpServletResponse.setHeader("Accept-Ranges", "bytes");
        }
        if (this._cacheControl != null) {
            httpServletResponse.setHeader("Cache-Control", this._cacheControl.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this._nioCache != null) {
                this._nioCache.stop();
            }
            if (this._bioCache != null) {
                this._bioCache.stop();
            }
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
        }
        finally {
            super.destroy();
        }
    }

    class NIOResourceCache
    extends ResourceCache {
        public NIOResourceCache(MimeTypes mimeTypes) {
            super(mimeTypes);
        }

        @Override
        protected void fill(ResourceCache.Content content) throws IOException {
            AbstractBuffer abstractBuffer = null;
            Resource resource = content.getResource();
            long l = resource.length();
            if (DefaultServlet.this._useFileMappedBuffer && resource.getFile() != null) {
                abstractBuffer = new DirectNIOBuffer(resource.getFile());
            } else {
                InputStream inputStream = resource.getInputStream();
                try {
                    Connector connector = HttpConnection.getCurrentConnection().getConnector();
                    abstractBuffer = ((NIOConnector)((Object)connector)).getUseDirectBuffers() ? new DirectNIOBuffer((int)l) : new IndirectNIOBuffer((int)l);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.warn(outOfMemoryError.toString());
                    Log.debug(outOfMemoryError);
                    abstractBuffer = new IndirectNIOBuffer((int)l);
                }
                abstractBuffer.readFrom(inputStream, (int)l);
                inputStream.close();
            }
            content.setBuffer(abstractBuffer);
        }
    }

    private class UnCachedContent
    implements HttpContent {
        Resource _resource;

        UnCachedContent(Resource resource) {
            this._resource = resource;
        }

        @Override
        public Buffer getContentType() {
            return DefaultServlet.this._mimeTypes.getMimeByExtension(this._resource.toString());
        }

        @Override
        public Buffer getLastModified() {
            return null;
        }

        @Override
        public Buffer getBuffer() {
            return null;
        }

        @Override
        public long getContentLength() {
            return this._resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        @Override
        public void release() {
            this._resource.release();
            this._resource = null;
        }
    }
}

