/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.Attributes;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String __INCLUDE_JETTY = "org.mortbay.jetty.included";
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String __INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String __INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String __INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String __INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String __FORWARD_JETTY = "org.mortbay.jetty.forwarded";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String __FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String __FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String __FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String __FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String __FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String __JSP_FILE = "org.apache.catalina.jsp_file";
    private ContextHandler _contextHandler;
    private String _uri;
    private String _path;
    private String _dQuery;
    private String _named;

    public static int type(String string) {
        if ("request".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(string)) {
            return 8;
        }
        throw new IllegalArgumentException(string);
    }

    public Dispatcher(ContextHandler contextHandler, String string, String string2, String string3) {
        this._contextHandler = contextHandler;
        this._uri = string;
        this._path = string2;
        this._dQuery = string3;
    }

    public Dispatcher(ContextHandler contextHandler, String string) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = string;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.forward(servletRequest, servletResponse, 2);
    }

    public void error(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.forward(servletRequest, servletResponse, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        Request request = servletRequest instanceof Request ? (Request)servletRequest : HttpConnection.getCurrentConnection().getRequest();
        servletRequest.removeAttribute(__JSP_FILE);
        Attributes attributes = request.getAttributes();
        MultiMap multiMap = request.getParameters();
        try {
            request.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, 4);
            } else {
                Object object;
                String string = this._dQuery;
                if (string != null) {
                    object = new MultiMap();
                    UrlEncoded.decodeTo(string, (MultiMap)object, servletRequest.getCharacterEncoding());
                    if (multiMap != null && multiMap.size() > 0) {
                        for (Map.Entry entry : multiMap.entrySet()) {
                            String string2 = (String)entry.getKey();
                            Object v = entry.getValue();
                            for (int i = 0; i < LazyList.size(v); ++i) {
                                ((MultiMap)object).add(string2, LazyList.get(v, i));
                            }
                        }
                    }
                    request.setParameters((MultiMap)object);
                }
                object = new IncludeAttributes(attributes);
                ((IncludeAttributes)object)._requestURI = this._uri;
                ((IncludeAttributes)object)._contextPath = this._contextHandler.getContextPath();
                ((IncludeAttributes)object)._servletPath = null;
                ((IncludeAttributes)object)._pathInfo = this._path;
                ((IncludeAttributes)object)._query = string;
                request.setAttributes((Attributes)object);
                this._contextHandler.handle(this._named == null ? this._path : this._named, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, 4);
            }
        }
        finally {
            request.setAttributes(attributes);
            request.getConnection().included();
            request.setParameters(multiMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest servletRequest, ServletResponse servletResponse, int n) throws ServletException, IOException {
        Request request = servletRequest instanceof Request ? (Request)servletRequest : HttpConnection.getCurrentConnection().getRequest();
        servletResponse.resetBuffer();
        servletRequest.removeAttribute(__JSP_FILE);
        String string = request.getRequestURI();
        String string2 = request.getContextPath();
        String string3 = request.getServletPath();
        String string4 = request.getPathInfo();
        String string5 = request.getQueryString();
        Attributes attributes = request.getAttributes();
        MultiMap multiMap = request.getParameters();
        try {
            if (this._named != null) {
                this._contextHandler.handle(this._named, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, n);
            } else {
                Object object;
                String string6 = this._dQuery;
                if (string6 != null) {
                    Object object2;
                    object = new MultiMap();
                    UrlEncoded.decodeTo(string6, (MultiMap)object, servletRequest.getCharacterEncoding());
                    boolean bl = false;
                    if (multiMap == null) {
                        request.getParameterNames();
                        multiMap = request.getParameters();
                    }
                    if (multiMap != null && multiMap.size() > 0) {
                        for (Map.Entry entry : multiMap.entrySet()) {
                            object2 = (String)entry.getKey();
                            if (((HashMap)object).containsKey(object2)) {
                                bl = true;
                            }
                            Object v = entry.getValue();
                            for (int i = 0; i < LazyList.size(v); ++i) {
                                ((MultiMap)object).add(object2, LazyList.get(v, i));
                            }
                        }
                    }
                    if (string5 != null && string5.length() > 0) {
                        if (bl) {
                            Map.Entry entry;
                            StringBuffer stringBuffer = new StringBuffer();
                            entry = new MultiMap();
                            UrlEncoded.decodeTo(string5, (MultiMap)((Object)entry), servletRequest.getCharacterEncoding());
                            object2 = new MultiMap();
                            UrlEncoded.decodeTo(string6, (MultiMap)object2, servletRequest.getCharacterEncoding());
                            for (Map.Entry entry2 : ((HashMap)((Object)entry)).entrySet()) {
                                String string7 = (String)entry2.getKey();
                                if (((HashMap)object2).containsKey(string7)) continue;
                                Object v = entry2.getValue();
                                for (int i = 0; i < LazyList.size(v); ++i) {
                                    stringBuffer.append("&" + string7 + "=" + LazyList.get(v, i));
                                }
                            }
                            string6 = string6 + stringBuffer;
                        } else {
                            string6 = string6 + "&" + string5;
                        }
                    }
                    request.setParameters((MultiMap)object);
                    request.setQueryString(string6);
                }
                object = new ForwardAttributes(attributes);
                if ((String)attributes.getAttribute(__FORWARD_REQUEST_URI) != null) {
                    ((ForwardAttributes)object)._pathInfo = (String)attributes.getAttribute(__FORWARD_PATH_INFO);
                    ((ForwardAttributes)object)._query = (String)attributes.getAttribute(__FORWARD_QUERY_STRING);
                    ((ForwardAttributes)object)._requestURI = (String)attributes.getAttribute(__FORWARD_REQUEST_URI);
                    ((ForwardAttributes)object)._contextPath = (String)attributes.getAttribute(__FORWARD_CONTEXT_PATH);
                    ((ForwardAttributes)object)._servletPath = (String)attributes.getAttribute(__FORWARD_SERVLET_PATH);
                } else {
                    ((ForwardAttributes)object)._pathInfo = string4;
                    ((ForwardAttributes)object)._query = string5;
                    ((ForwardAttributes)object)._requestURI = string;
                    ((ForwardAttributes)object)._contextPath = string2;
                    ((ForwardAttributes)object)._servletPath = string3;
                }
                request.setRequestURI(this._uri);
                request.setContextPath(this._contextHandler.getContextPath());
                request.setAttributes((Attributes)object);
                request.setQueryString(string6);
                this._contextHandler.handle(this._path, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, n);
                if (request.getConnection().getResponse().isWriting()) {
                    try {
                        servletResponse.getWriter().close();
                    }
                    catch (IllegalStateException illegalStateException) {
                        servletResponse.getOutputStream().close();
                    }
                } else {
                    try {
                        servletResponse.getOutputStream().close();
                    }
                    catch (IllegalStateException illegalStateException) {
                        servletResponse.getWriter().close();
                    }
                }
            }
        }
        finally {
            request.setRequestURI(string);
            request.setContextPath(string2);
            request.setServletPath(string3);
            request.setPathInfo(string4);
            request.setAttributes(attributes);
            request.setParameters(multiMap);
            request.setQueryString(string5);
        }
    }

    private class IncludeAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        @Override
        public Object getAttribute(String string) {
            if (Dispatcher.this._named == null) {
                if (string.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (string.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (string.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (string.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return this._query;
                }
                if (string.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return this._requestURI;
                }
            } else if (string.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            if (string.equals(Dispatcher.__INCLUDE_JETTY)) {
                return Boolean.TRUE;
            }
            return this._attr.getAttribute(string);
        }

        @Override
        public Enumeration getAttributeNames() {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = this._attr.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                hashSet.add(string);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    hashSet.add(Dispatcher.__INCLUDE_PATH_INFO);
                } else {
                    hashSet.remove(Dispatcher.__INCLUDE_PATH_INFO);
                }
                hashSet.add(Dispatcher.__INCLUDE_REQUEST_URI);
                hashSet.add(Dispatcher.__INCLUDE_SERVLET_PATH);
                hashSet.add(Dispatcher.__INCLUDE_CONTEXT_PATH);
                if (this._query != null) {
                    hashSet.add(Dispatcher.__INCLUDE_QUERY_STRING);
                } else {
                    hashSet.remove(Dispatcher.__INCLUDE_QUERY_STRING);
                }
            }
            return Collections.enumeration(hashSet);
        }

        @Override
        public void setAttribute(String string, Object object) {
            if (Dispatcher.this._named == null && string.startsWith("javax.servlet.")) {
                if (string.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    this._pathInfo = (String)object;
                } else if (string.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    this._requestURI = (String)object;
                } else if (string.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    this._servletPath = (String)object;
                } else if (string.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    this._contextPath = (String)object;
                } else if (string.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    this._query = (String)object;
                } else if (object == null) {
                    this._attr.removeAttribute(string);
                } else {
                    this._attr.setAttribute(string, object);
                }
            } else if (object == null) {
                this._attr.removeAttribute(string);
            } else {
                this._attr.setAttribute(string, object);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String string) {
            this.setAttribute(string, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        @Override
        public Object getAttribute(String string) {
            if (Dispatcher.this._named == null) {
                if (string.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (string.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    return this._requestURI;
                }
                if (string.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (string.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (string.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    return this._query;
                }
            }
            if (string.startsWith(Dispatcher.__INCLUDE_PREFIX) || string.equals(Dispatcher.__INCLUDE_JETTY)) {
                return null;
            }
            if (string.equals(Dispatcher.__FORWARD_JETTY)) {
                return Boolean.TRUE;
            }
            return this._attr.getAttribute(string);
        }

        @Override
        public Enumeration getAttributeNames() {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = this._attr.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(Dispatcher.__INCLUDE_PREFIX) || string.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                hashSet.add(string);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    hashSet.add(Dispatcher.__FORWARD_PATH_INFO);
                } else {
                    hashSet.remove(Dispatcher.__FORWARD_PATH_INFO);
                }
                hashSet.add(Dispatcher.__FORWARD_REQUEST_URI);
                hashSet.add(Dispatcher.__FORWARD_SERVLET_PATH);
                hashSet.add(Dispatcher.__FORWARD_CONTEXT_PATH);
                if (this._query != null) {
                    hashSet.add(Dispatcher.__FORWARD_QUERY_STRING);
                } else {
                    hashSet.remove(Dispatcher.__FORWARD_QUERY_STRING);
                }
            }
            return Collections.enumeration(hashSet);
        }

        @Override
        public void setAttribute(String string, Object object) {
            if (Dispatcher.this._named == null && string.startsWith("javax.servlet.")) {
                if (string.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    this._pathInfo = (String)object;
                } else if (string.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    this._requestURI = (String)object;
                } else if (string.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    this._servletPath = (String)object;
                } else if (string.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    this._contextPath = (String)object;
                } else if (string.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    this._query = (String)object;
                } else if (object == null) {
                    this._attr.removeAttribute(string);
                } else {
                    this._attr.setAttribute(string, object);
                }
            } else if (object == null) {
                this._attr.removeAttribute(string);
            } else {
                this._attr.setAttribute(string, object);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String string) {
            this.setAttribute(string, null);
        }
    }
}

