/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.log.Log;
import org.mortbay.util.TypeUtil;

public class ErrorPageErrorHandler
extends ErrorHandler {
    protected ServletContext _servletContext;
    protected Map _errorPages;
    protected List _errorPageList;

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException {
        String string2 = httpServletRequest.getMethod();
        if (!(string2.equals("GET") || string2.equals("POST") || string2.equals("HEAD"))) {
            HttpConnection.getCurrentConnection().getRequest().setHandled(true);
            return;
        }
        if (this._errorPages != null) {
            Object object;
            String string3 = null;
            Class<Object> clazz = (Class)httpServletRequest.getAttribute("javax.servlet.error.exception_type");
            if (ServletException.class.equals((Object)clazz) && (string3 = (String)this._errorPages.get(clazz.getName())) == null) {
                object = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception");
                while (object instanceof ServletException) {
                    object = ((ServletException)((Object)object)).getRootCause();
                }
                if (object != null) {
                    clazz = object.getClass();
                }
            }
            while (string3 == null && clazz != null) {
                string3 = (String)this._errorPages.get(clazz.getName());
                clazz = clazz.getSuperclass();
            }
            if (string3 == null && (object = (Integer)httpServletRequest.getAttribute("javax.servlet.error.status_code")) != null && (string3 = (String)this._errorPages.get(TypeUtil.toString((Integer)object))) == null && this._errorPageList != null) {
                for (int i = 0; i < this._errorPageList.size(); ++i) {
                    ErrorCodeRange errorCodeRange = (ErrorCodeRange)this._errorPageList.get(i);
                    if (!errorCodeRange.isInRange((Integer)object)) continue;
                    string3 = errorCodeRange.getUri();
                    break;
                }
            }
            if (!(string3 == null || (object = (String)httpServletRequest.getAttribute("org.mortbay.jetty.error_page")) != null && ((String)object).equals(string3))) {
                httpServletRequest.setAttribute("org.mortbay.jetty.error_page", (Object)string3);
                Dispatcher dispatcher = (Dispatcher)this._servletContext.getRequestDispatcher(string3);
                try {
                    if (dispatcher != null) {
                        dispatcher.error((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        return;
                    }
                    Log.warn("No error page " + string3);
                }
                catch (ServletException servletException) {
                    Log.warn("EXCEPTION ", servletException);
                    return;
                }
            }
        }
        super.handle(string, httpServletRequest, httpServletResponse, n);
    }

    public Map getErrorPages() {
        return this._errorPages;
    }

    public void setErrorPages(Map map) {
        this._errorPages = map;
    }

    public void addErrorPage(Class clazz, String string) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(clazz.getName(), string);
    }

    public void addErrorPage(int n, String string) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(TypeUtil.toString(n), string);
    }

    public void addErrorPage(int n, int n2, String string) {
        if (this._errorPageList == null) {
            this._errorPageList = new ArrayList();
        }
        this._errorPageList.add(new ErrorCodeRange(n, n2, string));
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._servletContext = ContextHandler.getCurrentContext();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    private class ErrorCodeRange {
        private int _from;
        private int _to;
        private String _uri;

        ErrorCodeRange(int n, int n2, String string) throws IllegalArgumentException {
            if (n > n2) {
                throw new IllegalArgumentException("from>to");
            }
            this._from = n;
            this._to = n2;
            this._uri = string;
        }

        boolean isInRange(int n) {
            return n >= this._from && n <= this._to;
        }

        String getUri() {
            return this._uri;
        }

        public String toString() {
            return "from: " + this._from + ",to: " + this._to + ",uri: " + this._uri;
        }
    }
}

