/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.log.Log;

public class FilterHolder
extends Holder {
    private transient Filter _filter;
    private transient Config _config;

    public static int dispatch(String string) {
        if ("request".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(string)) {
            return 8;
        }
        throw new IllegalArgumentException(string);
    }

    public FilterHolder() {
    }

    public FilterHolder(Class clazz) {
        super(clazz);
    }

    public FilterHolder(Filter filter) {
        this.setFilter(filter);
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!Filter.class.isAssignableFrom(this._class)) {
            String string = this._class + " is not a javax.servlet.Filter";
            super.stop();
            throw new IllegalStateException(string);
        }
        if (this._filter == null) {
            this._filter = (Filter)this.newInstance();
        }
        this._filter = this.getServletHandler().customizeFilter(this._filter);
        this._config = new Config();
        this._filter.init((FilterConfig)this._config);
    }

    @Override
    public void doStop() {
        if (this._filter != null) {
            try {
                this.destroyInstance(this._filter);
            }
            catch (Exception exception) {
                Log.warn(exception);
            }
        }
        if (!this._extInstance) {
            this._filter = null;
        }
        this._config = null;
        super.doStop();
    }

    @Override
    public void destroyInstance(Object object) throws Exception {
        if (object == null) {
            return;
        }
        Filter filter = (Filter)object;
        filter.destroy();
        this.getServletHandler().customizeFilterDestroy(filter);
    }

    public synchronized void setFilter(Filter filter) {
        this._filter = filter;
        this._extInstance = true;
        this.setHeldClass(filter.getClass());
        if (this.getName() == null) {
            this.setName(filter.getClass().getName());
        }
    }

    public Filter getFilter() {
        return this._filter;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    class Config
    implements FilterConfig {
        Config() {
        }

        public String getFilterName() {
            return FilterHolder.this._name;
        }

        public ServletContext getServletContext() {
            return FilterHolder.this._servletHandler.getServletContext();
        }

        public String getInitParameter(String string) {
            return FilterHolder.this.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return FilterHolder.this.getInitParameterNames();
        }
    }
}

