/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Arrays;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.PathMap;

public class FilterMapping {
    private int _dispatches = 1;
    private String _filterName;
    private transient FilterHolder _holder;
    private String[] _pathSpecs;
    private String[] _servletNames;

    boolean appliesTo(String string, int n) {
        if (((this._dispatches & n) != 0 || this._dispatches == 0 && n == 1) && this._pathSpecs != null) {
            for (int i = 0; i < this._pathSpecs.length; ++i) {
                if (this._pathSpecs[i] == null || !PathMap.match(this._pathSpecs[i], string, true)) continue;
                return true;
            }
        }
        return false;
    }

    boolean appliesTo(int n) {
        return (this._dispatches & n) != 0 || this._dispatches == 0 && n == 1;
    }

    public int getDispatches() {
        return this._dispatches;
    }

    public String getFilterName() {
        return this._filterName;
    }

    FilterHolder getFilterHolder() {
        return this._holder;
    }

    public String[] getPathSpecs() {
        return this._pathSpecs;
    }

    public void setDispatches(int n) {
        this._dispatches = n;
    }

    public void setFilterName(String string) {
        this._filterName = string;
    }

    void setFilterHolder(FilterHolder filterHolder) {
        this._holder = filterHolder;
    }

    public void setPathSpecs(String[] stringArray) {
        this._pathSpecs = stringArray;
    }

    public void setPathSpec(String string) {
        this._pathSpecs = new String[]{string};
    }

    public String[] getServletNames() {
        return this._servletNames;
    }

    public void setServletNames(String[] stringArray) {
        this._servletNames = stringArray;
    }

    public void setServletName(String string) {
        this._servletNames = new String[]{string};
    }

    public String toString() {
        return "(F=" + this._filterName + "," + (this._pathSpecs == null ? "[]" : Arrays.asList(this._pathSpecs).toString()) + "," + (this._servletNames == null ? "[]" : Arrays.asList(this._servletNames).toString()) + "," + this._dispatches + ")";
    }
}

