/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.log.Log;
import org.mortbay.util.MultiMap;

public class HashSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    protected static final String SESSION_ID_RANDOM_ALGORITHM = "SHA1PRNG";
    protected static final String SESSION_ID_RANDOM_ALGORITHM_ALT = "IBMSecureRandom";
    MultiMap _sessions;
    protected Random _random;
    private boolean _weakRandom;
    private String _workerName;

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        this._random = random;
    }

    @Override
    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String string) {
        this._workerName = string;
    }

    @Override
    public String getNodeId(String string, HttpServletRequest httpServletRequest) {
        String string2;
        String string3 = string2 = httpServletRequest == null ? null : (String)httpServletRequest.getAttribute("org.mortbay.http.ajp.JVMRoute");
        if (string2 != null) {
            return string + '.' + string2;
        }
        if (this._workerName != null) {
            return string + '.' + this._workerName;
        }
        return string;
    }

    @Override
    public String getClusterId(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) : string;
    }

    @Override
    protected void doStart() {
        if (this._random == null) {
            try {
                Log.debug("Init SecureRandom.");
                this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM_ALT);
                    this._weakRandom = false;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    Log.warn("Could not generate SecureRandom for session-id randomness", noSuchAlgorithmException);
                    this._random = new Random();
                    this._weakRandom = true;
                }
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
        this._sessions = new MultiMap();
    }

    @Override
    protected void doStop() {
        if (this._sessions != null) {
            this._sessions.clear();
        }
        this._sessions = null;
    }

    @Override
    public boolean idInUse(String string) {
        return this._sessions.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession httpSession) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            this._sessions.add(this.getClusterId(httpSession.getId()), httpSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(HttpSession httpSession) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            this._sessions.removeValue(this.getClusterId(httpSession.getId()), httpSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String string) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            while (this._sessions.containsKey(string)) {
                AbstractSessionManager.Session session = (AbstractSessionManager.Session)this._sessions.getValue(string, 0);
                if (session.isValid()) {
                    session.invalidate();
                    continue;
                }
                this._sessions.removeValue(string, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String newSessionId(HttpServletRequest httpServletRequest, long l) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            String string;
            String string2 = httpServletRequest.getRequestedSessionId();
            if (string2 != null && this.idInUse(string = this.getClusterId(string2))) {
                return string;
            }
            string = (String)httpServletRequest.getAttribute(__NEW_SESSION_ID);
            if (string != null && this.idInUse(string)) {
                return string;
            }
            String string3 = null;
            while (string3 == null || string3.length() == 0 || this.idInUse(string3)) {
                long l2 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)httpServletRequest.hashCode() << 32 : this._random.nextLong();
                l2 ^= l;
                if (httpServletRequest != null && httpServletRequest.getRemoteAddr() != null) {
                    l2 ^= (long)httpServletRequest.getRemoteAddr().hashCode();
                }
                if (l2 < 0L) {
                    l2 = -l2;
                }
                string3 = Long.toString(l2, 36);
            }
            httpServletRequest.setAttribute(__NEW_SESSION_ID, (Object)string3);
            return string3;
        }
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }
}

