/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class HashSessionManager
extends AbstractSessionManager {
    private Timer _timer;
    private TimerTask _task;
    private int _scavengePeriodMs = 30000;
    private int _savePeriodMs = 0;
    private TimerTask _saveTask;
    protected Map _sessions;
    private File _storeDir;
    private boolean _lazyLoad = false;
    private boolean _sessionsLoaded = false;

    @Override
    public void doStart() throws Exception {
        this._sessions = new HashMap();
        super.doStart();
        this._timer = new Timer(true);
        this.setScavengePeriod(this.getScavengePeriod());
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdir();
            }
            if (!this._lazyLoad) {
                this.restoreSessions();
            }
        }
        this.setSavePeriod(this.getSavePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        if (this._storeDir != null) {
            this.saveSessions();
        }
        super.doStop();
        this._sessions.clear();
        this._sessions = null;
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._saveTask != null) {
                this._saveTask.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this._timer != null) {
                this._timer.cancel();
            }
            this._timer = null;
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    @Override
    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    @Override
    public int getSessions() {
        return this._sessions.size();
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        super.setMaxInactiveInterval(n);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePeriod(int n) {
        int n2 = this._savePeriodMs;
        int n3 = n * 1000;
        if (n3 < 0) {
            n3 = 0;
        }
        this._savePeriodMs = n3;
        if (this._timer != null) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._saveTask != null) {
                    this._saveTask.cancel();
                }
                if (this._savePeriodMs > 0 && this._storeDir != null) {
                    this._saveTask = new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                HashSessionManager.this.saveSessions();
                            }
                            catch (Exception exception) {
                                Log.warn(exception);
                            }
                        }
                    };
                    this._timer.schedule(this._saveTask, this._savePeriodMs, (long)this._savePeriodMs);
                }
            }
        }
    }

    public int getSavePeriod() {
        if (this._savePeriodMs <= 0) {
            return 0;
        }
        return this._savePeriodMs / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int n) {
        if (n == 0) {
            n = 60;
        }
        int n2 = this._scavengePeriodMs;
        int n3 = n * 1000;
        if (n3 > 60000) {
            n3 = 60000;
        }
        if (n3 < 1000) {
            n3 = 1000;
        }
        this._scavengePeriodMs = n3;
        if (this._timer != null && (n3 != n2 || this._task == null)) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    @Override
                    public void run() {
                        HashSessionManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengePeriodMs, (long)this._scavengePeriodMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long l = System.currentTimeMillis();
            try {
                if (!this._sessionsLoaded && this._lazyLoad) {
                    this.restoreSessions();
                }
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            Object object = null;
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                for (Session session : this._sessions.values()) {
                    long l2 = session._maxIdleMs;
                    if (l2 <= 0L || session._accessed + l2 >= l) continue;
                    object = LazyList.add(object, session);
                }
            }
            int n = LazyList.size(object);
            while (n-- > 0) {
                Session session = (Session)LazyList.get(object, n);
                long l3 = session._maxIdleMs;
                if (l3 <= 0L || session._accessed + l3 >= System.currentTimeMillis()) continue;
                session.timeout();
                int n2 = this._sessions.size();
                if (n2 >= this._minSessions) continue;
                this._minSessions = n2;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Log.warn("Problem scavenging sessions", throwable);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    @Override
    protected void addSession(AbstractSessionManager.Session session) {
        this._sessions.put(session.getClusterId(), session);
    }

    @Override
    public AbstractSessionManager.Session getSession(String string) {
        try {
            if (!this._sessionsLoaded && this._lazyLoad) {
                this.restoreSessions();
            }
        }
        catch (Exception exception) {
            Log.warn(exception);
        }
        if (this._sessions == null) {
            return null;
        }
        return (Session)this._sessions.get(string);
    }

    @Override
    protected void invalidateSessions() {
        ArrayList arrayList = new ArrayList(this._sessions.values());
        for (Session session : arrayList) {
            session.invalidate();
        }
        this._sessions.clear();
    }

    @Override
    protected AbstractSessionManager.Session newSession(HttpServletRequest httpServletRequest) {
        return new Session(httpServletRequest);
    }

    @Override
    protected void removeSession(String string) {
        this._sessions.remove(string);
    }

    public void setStoreDirectory(File file) {
        this._storeDir = file;
    }

    public File getStoreDirectory() {
        return this._storeDir;
    }

    public void setLazyLoad(boolean bl) {
        this._lazyLoad = bl;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public void restoreSessions() throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            Log.warn("Unable to restore Sessions: Cannot read from Session storage directory " + this._storeDir.getAbsolutePath());
            return;
        }
        File[] fileArray = this._storeDir.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            try {
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                Session session = this.restoreSession(fileInputStream);
                fileInputStream.close();
                this.addSession(session, false);
                fileArray[i].delete();
                continue;
            }
            catch (Exception exception) {
                Log.warn("Problem restoring session " + fileArray[i].getName(), exception);
            }
        }
        this._sessionsLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSessions() throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            Log.warn("Unable to save Sessions: Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable");
            return;
        }
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            for (Map.Entry entry : this._sessions.entrySet()) {
                String string = (String)entry.getKey();
                Session session = (Session)entry.getValue();
                try {
                    File file = new File(this._storeDir, string);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    session.save(fileOutputStream);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    Log.warn("Problem persisting session " + string, exception);
                }
            }
        }
    }

    public Session restoreSession(FileInputStream fileInputStream) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        boolean bl = dataInputStream.readBoolean();
        long l = dataInputStream.readLong();
        long l2 = dataInputStream.readLong();
        long l3 = dataInputStream.readLong();
        long l4 = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        Session session = new Session(l, string);
        session._cookieSet = l2;
        session._lastAccessed = l4;
        int n2 = dataInputStream.readInt();
        if (n2 > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n2; ++i) {
                String string3 = dataInputStream.readUTF();
                arrayList.add(string3);
            }
            ClassLoadingObjectInputStream classLoadingObjectInputStream = new ClassLoadingObjectInputStream(dataInputStream);
            for (int i = 0; i < n2; ++i) {
                Object object = classLoadingObjectInputStream.readObject();
                session.setAttribute((String)arrayList.get(i), object);
            }
            classLoadingObjectInputStream.close();
        } else {
            session.initValues();
        }
        dataInputStream.close();
        return session;
    }

    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(objectStreamClass.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }

    protected class Session
    extends AbstractSessionManager.Session {
        private static final long serialVersionUID = -2134521374206116367L;

        protected Session(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        protected Session(long l, String string) {
            super(l, string);
        }

        @Override
        public void setMaxInactiveInterval(int n) {
            super.setMaxInactiveInterval(n);
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)HashSessionManager.this._scavengePeriodMs) {
                HashSessionManager.this.setScavengePeriod((n + 9) / 10);
            }
        }

        @Override
        protected Map newAttributeMap() {
            return new HashMap(3);
        }

        @Override
        public void invalidate() throws IllegalStateException {
            super.invalidate();
            this.remove(this.getId());
        }

        public void remove(String string) {
            if (string == null) {
                return;
            }
            if (HashSessionManager.this.isStopping() || HashSessionManager.this.isStopped()) {
                return;
            }
            if (HashSessionManager.this._storeDir == null || !HashSessionManager.this._storeDir.exists()) {
                return;
            }
            File file = new File(HashSessionManager.this._storeDir, string);
            file.delete();
        }

        public void save(FileOutputStream fileOutputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.writeUTF(this._clusterId);
            dataOutputStream.writeUTF(this._nodeId);
            dataOutputStream.writeBoolean(this._idChanged);
            dataOutputStream.writeLong(this._created);
            dataOutputStream.writeLong(this._cookieSet);
            dataOutputStream.writeLong(this._accessed);
            dataOutputStream.writeLong(this._lastAccessed);
            dataOutputStream.writeInt(this._requests);
            if (this._values != null) {
                Object object2;
                dataOutputStream.writeInt(this._values.size());
                for (Object object2 : this._values.keySet()) {
                    dataOutputStream.writeUTF((String)object2);
                }
                Iterator<Object> iterator = this._values.values().iterator();
                object2 = new ObjectOutputStream(dataOutputStream);
                while (iterator.hasNext()) {
                    ((ObjectOutputStream)object2).writeObject(iterator.next());
                }
                ((ObjectOutputStream)object2).close();
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.close();
        }
    }
}

