/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;
import org.mortbay.util.URIUtil;

public class Invoker
extends HttpServlet {
    private ContextHandler _contextHandler;
    private ServletHandler _servletHandler;
    private Map.Entry _invokerEntry;
    private Map _parameters;
    private boolean _nonContextServlets;
    private boolean _verbose;

    public void init() {
        ServletContext servletContext = this.getServletContext();
        this._contextHandler = ((ContextHandler.SContext)servletContext).getContextHandler();
        Handler handler = this._contextHandler.getHandler();
        while (handler != null && !(handler instanceof ServletHandler) && handler instanceof HandlerWrapper) {
            handler = ((HandlerWrapper)handler).getHandler();
        }
        this._servletHandler = (ServletHandler)handler;
        Enumeration enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getInitParameter(string);
            String string3 = string2.toLowerCase();
            if ("nonContextServlets".equals(string)) {
                boolean bl = this._nonContextServlets = string2.length() > 0 && string3.startsWith("t");
            }
            if ("verbose".equals(string)) {
                this._verbose = string2.length() > 0 && string3.startsWith("t");
                continue;
            }
            if (this._parameters == null) {
                this._parameters = new HashMap();
            }
            this._parameters.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        boolean bl = false;
        String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string2 == null) {
            string2 = httpServletRequest.getServletPath();
        } else {
            bl = true;
        }
        String string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        if (string3 == null) {
            string3 = httpServletRequest.getPathInfo();
        }
        if ((string = string3) == null || string.length() <= 1) {
            httpServletResponse.sendError(404);
            return;
        }
        int n = string.charAt(0) == '/' ? 1 : 0;
        int n2 = string.indexOf(47, n);
        string = n2 < 0 ? string.substring(n) : string.substring(n, n2);
        ServletHolder[] servletHolderArray = this._servletHandler.getServlets();
        ServletHolder servletHolder = this.getHolder(servletHolderArray, string);
        if (servletHolder != null) {
            Log.debug("Adding servlet mapping for named servlet:" + string + ":" + URIUtil.addPaths(string2, string) + "/*");
            ServletMapping servletMapping = new ServletMapping();
            servletMapping.setServletName(string);
            servletMapping.setPathSpec(URIUtil.addPaths(string2, string) + "/*");
            this._servletHandler.setServletMappings((ServletMapping[])LazyList.addToArray(this._servletHandler.getServletMappings(), servletMapping, ServletMapping.class));
        } else {
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            if (string == null || string.length() == 0) {
                httpServletResponse.sendError(404);
                return;
            }
            ServletHandler servletHandler = this._servletHandler;
            synchronized (servletHandler) {
                this._invokerEntry = this._servletHandler.getHolderEntry(string2);
                String string4 = URIUtil.addPaths(string2, string);
                PathMap.Entry entry = this._servletHandler.getHolderEntry(string4);
                if (entry != null && !entry.equals(this._invokerEntry)) {
                    servletHolder = (ServletHolder)entry.getValue();
                } else {
                    Log.debug("Making new servlet=" + string + " with path=" + string4 + "/*");
                    servletHolder = this._servletHandler.addServletWithMapping(string, string4 + "/*");
                    if (this._parameters != null) {
                        servletHolder.setInitParameters(this._parameters);
                    }
                    try {
                        servletHolder.start();
                    }
                    catch (Exception exception) {
                        Log.debug(exception);
                        throw new UnavailableException(exception.toString());
                    }
                    if (!this._nonContextServlets) {
                        Servlet servlet = servletHolder.getServlet();
                        if (this._contextHandler.getClassLoader() != servlet.getClass().getClassLoader()) {
                            try {
                                servletHolder.stop();
                            }
                            catch (Exception exception) {
                                Log.ignore(exception);
                            }
                            Log.warn("Dynamic servlet " + servlet + " not loaded from context " + httpServletRequest.getContextPath());
                            throw new UnavailableException("Not in context");
                        }
                    }
                    if (this._verbose) {
                        Log.debug("Dynamic load '" + string + "' at " + string4);
                    }
                }
            }
        }
        if (servletHolder != null) {
            servletHolder.handle((ServletRequest)new Request(httpServletRequest, bl, string, string2, string3), (ServletResponse)httpServletResponse);
        } else {
            Log.info("Can't find holder for servlet: " + string);
            httpServletResponse.sendError(404);
        }
    }

    private ServletHolder getHolder(ServletHolder[] servletHolderArray, String string) {
        if (servletHolderArray == null) {
            return null;
        }
        ServletHolder servletHolder = null;
        for (int i = 0; servletHolder == null && i < servletHolderArray.length; ++i) {
            if (!servletHolderArray[i].getName().equals(string)) continue;
            servletHolder = servletHolderArray[i];
        }
        return servletHolder;
    }

    class Request
    extends HttpServletRequestWrapper {
        String _servletPath;
        String _pathInfo;
        boolean _included;

        Request(HttpServletRequest httpServletRequest, boolean bl, String string, String string2, String string3) {
            super(httpServletRequest);
            this._included = bl;
            this._servletPath = URIUtil.addPaths(string2, string);
            this._pathInfo = string3.substring(string.length() + 1);
            if (this._pathInfo.length() == 0) {
                this._pathInfo = null;
            }
        }

        public String getServletPath() {
            if (this._included) {
                return super.getServletPath();
            }
            return this._servletPath;
        }

        public String getPathInfo() {
            if (this._included) {
                return super.getPathInfo();
            }
            return this._pathInfo;
        }

        public Object getAttribute(String string) {
            if (this._included) {
                if (string.equals("javax.servlet.include.request_uri")) {
                    return URIUtil.addPaths(URIUtil.addPaths(this.getContextPath(), this._servletPath), this._pathInfo);
                }
                if (string.equals("javax.servlet.include.path_info")) {
                    return this._pathInfo;
                }
                if (string.equals("javax.servlet.include.servlet_path")) {
                    return this._servletPath;
                }
            }
            return super.getAttribute(string);
        }
    }
}

