/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.URIUtil;

public class ServletHandler
extends AbstractHandler {
    public static final String __DEFAULT_SERVLET = "default";
    public static final String __J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String __J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String __J_S_ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String __J_S_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String __J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String __J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String __J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private ContextHandler _contextHandler;
    private ContextHandler.SContext _servletContext;
    private FilterHolder[] _filters;
    private FilterMapping[] _filterMappings;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 1000;
    private boolean _startWithUnavailable = true;
    private ServletHolder[] _servlets;
    private ServletMapping[] _servletMappings;
    private transient Map _filterNameMap = new HashMap();
    private transient List _filterPathMappings;
    private transient MultiMap _filterNameMappings;
    private transient Map _servletNameMap = new HashMap();
    private transient PathMap _servletPathMap;
    protected transient HashMap[] _chainCache;

    @Override
    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, this._filters, null, "filter", true);
            this.getServer().getContainer().update((Object)this, this._filterMappings, null, "filterMapping", true);
            this.getServer().getContainer().update((Object)this, this._servlets, null, "servlet", true);
            this.getServer().getContainer().update((Object)this, this._servletMappings, null, "servletMapping", true);
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, this._filters, "filter", true);
            server.getContainer().update((Object)this, null, this._filterMappings, "filterMapping", true);
            server.getContainer().update((Object)this, null, this._servlets, "servlet", true);
            server.getContainer().update((Object)this, null, this._servletMappings, "servletMapping", true);
        }
        super.setServer(server);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        this._servletContext = ContextHandler.getCurrentContext();
        this._contextHandler = this._servletContext == null ? null : this._servletContext.getContextHandler();
        this.updateNameMappings();
        this.updateMappings();
        if (this._filterChainsCached) {
            this._chainCache = new HashMap[]{null, new HashMap(), new HashMap(), null, new HashMap(), null, null, null, new HashMap()};
        }
        super.doStart();
        if (this._contextHandler == null || !(this._contextHandler instanceof Context)) {
            this.initialize();
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        int n;
        super.doStop();
        if (this._filters != null) {
            n = this._filters.length;
            while (n-- > 0) {
                try {
                    this._filters[n].stop();
                }
                catch (Exception exception) {
                    Log.warn("EXCEPTION ", exception);
                }
            }
        }
        if (this._servlets != null) {
            n = this._servlets.length;
            while (n-- > 0) {
                try {
                    this._servlets[n].stop();
                }
                catch (Exception exception) {
                    Log.warn("EXCEPTION ", exception);
                }
            }
        }
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
        this._chainCache = null;
    }

    public Object getContextLog() {
        return null;
    }

    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    public FilterHolder[] getFilters() {
        return this._filters;
    }

    public PathMap.Entry getHolderEntry(String string) {
        if (this._servletPathMap == null) {
            return null;
        }
        return this._servletPathMap.getMatch(string);
    }

    public boolean matchesPath(String string) {
        return this._servletPathMap.containsMatch(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            return null;
        }
        try {
            String string2 = null;
            int n = 0;
            n = string.indexOf(63);
            if (n > 0) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(59)) > 0) {
                string = string.substring(0, n);
            }
            String string3 = URIUtil.canonicalPath(URIUtil.decodePath(string));
            String string4 = URIUtil.addPaths(this._contextHandler.getContextPath(), string);
            return new Dispatcher(this._contextHandler, string4, string3, string2);
        }
        catch (Exception exception) {
            Log.ignore(exception);
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    public ServletHolder getServlet(String string) {
        return (ServletHolder)this._servletNameMap.get(string);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handle(String var1_1, HttpServletRequest var2_2, HttpServletResponse var3_3, int var4_4) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getFilterChain(int n, String string, ServletHolder servletHolder) {
        Object object;
        String string2;
        String string3 = string2 = string == null ? servletHolder.getName() : string;
        if (this._filterChainsCached && this._chainCache != null) {
            object = this;
            synchronized (object) {
                if (this._chainCache[n].containsKey(string2)) {
                    return (FilterChain)this._chainCache[n].get(string2);
                }
            }
        }
        object = null;
        if (string != null && this._filterPathMappings != null) {
            for (int i = 0; i < this._filterPathMappings.size(); ++i) {
                FilterMapping filterMapping = (FilterMapping)this._filterPathMappings.get(i);
                if (!filterMapping.appliesTo(string, n)) continue;
                object = LazyList.add(object, filterMapping.getFilterHolder());
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0 && this._filterNameMappings.size() > 0) {
            FilterMapping filterMapping;
            int n2;
            Object object2 = this._filterNameMappings.get(servletHolder.getName());
            for (n2 = 0; n2 < LazyList.size(object2); ++n2) {
                filterMapping = (FilterMapping)LazyList.get(object2, n2);
                if (!filterMapping.appliesTo(n)) continue;
                object = LazyList.add(object, filterMapping.getFilterHolder());
            }
            object2 = this._filterNameMappings.get("*");
            for (n2 = 0; n2 < LazyList.size(object2); ++n2) {
                filterMapping = (FilterMapping)LazyList.get(object2, n2);
                if (!filterMapping.appliesTo(n)) continue;
                object = LazyList.add(object, filterMapping.getFilterHolder());
            }
        }
        if (object == null) {
            return null;
        }
        Object object3 = null;
        if (this._filterChainsCached) {
            if (LazyList.size(object) > 0) {
                object3 = new CachedChain(object, servletHolder);
            }
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this._maxFilterChainsCacheSize > 0 && this._chainCache[n].size() > this._maxFilterChainsCacheSize) {
                    this._chainCache[n].clear();
                }
                this._chainCache[n].put(string2, object3);
            }
        } else if (LazyList.size(object) > 0) {
            object3 = new Chain(object, servletHolder);
        }
        return object3;
    }

    public boolean isInitializeAtStart() {
        return false;
    }

    public void setInitializeAtStart(boolean bl) {
    }

    public boolean isAvailable() {
        if (!this.isStarted()) {
            return false;
        }
        ServletHolder[] servletHolderArray = this.getServlets();
        for (int i = 0; i < servletHolderArray.length; ++i) {
            ServletHolder servletHolder = servletHolderArray[i];
            if (servletHolder == null || servletHolder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void setStartWithUnavailable(boolean bl) {
        this._startWithUnavailable = bl;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    public void initialize() throws Exception {
        MultiException multiException = new MultiException();
        if (this._filters != null) {
            for (int i = 0; i < this._filters.length; ++i) {
                this._filters[i].start();
            }
        }
        if (this._servlets != null) {
            Object[] objectArray = (ServletHolder[])this._servlets.clone();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    if (((Holder)objectArray[i]).getClassName() == null && ((ServletHolder)objectArray[i]).getForcedPath() != null) {
                        ServletHolder servletHolder = (ServletHolder)this._servletPathMap.match(((ServletHolder)objectArray[i]).getForcedPath());
                        if (servletHolder == null || servletHolder.getClassName() == null) {
                            multiException.add(new IllegalStateException("No forced path servlet for " + ((ServletHolder)objectArray[i]).getForcedPath()));
                            continue;
                        }
                        ((Holder)objectArray[i]).setClassName(servletHolder.getClassName());
                    }
                    ((AbstractLifeCycle)objectArray[i]).start();
                    continue;
                }
                catch (Throwable throwable) {
                    Log.debug("EXCEPTION ", throwable);
                    multiException.add(throwable);
                }
            }
            multiException.ifExceptionThrow();
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public ServletHolder newServletHolder() {
        return new ServletHolder();
    }

    public ServletHolder newServletHolder(Class clazz) {
        return new ServletHolder(clazz);
    }

    public ServletHolder addServletWithMapping(String string, String string2) {
        ServletHolder servletHolder = this.newServletHolder(null);
        servletHolder.setName(string + "-" + servletHolder.hashCode());
        servletHolder.setClassName(string);
        this.addServletWithMapping(servletHolder, string2);
        return servletHolder;
    }

    public ServletHolder addServletWithMapping(Class clazz, String string) {
        ServletHolder servletHolder = this.newServletHolder(clazz);
        this.setServlets((ServletHolder[])LazyList.addToArray(this.getServlets(), servletHolder, ServletHolder.class));
        this.addServletWithMapping(servletHolder, string);
        return servletHolder;
    }

    public void addServletWithMapping(ServletHolder servletHolder, String string) {
        Object[] objectArray = this.getServlets();
        if (objectArray != null) {
            objectArray = (ServletHolder[])objectArray.clone();
        }
        try {
            this.setServlets((ServletHolder[])LazyList.addToArray(objectArray, servletHolder, ServletHolder.class));
            ServletMapping servletMapping = new ServletMapping();
            servletMapping.setServletName(servletHolder.getName());
            servletMapping.setPathSpec(string);
            this.setServletMappings((ServletMapping[])LazyList.addToArray(this.getServletMappings(), servletMapping, ServletMapping.class));
        }
        catch (Exception exception) {
            this.setServlets((ServletHolder[])objectArray);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    public ServletHolder addServlet(String string, String string2) {
        return this.addServletWithMapping(string, string2);
    }

    public void addServlet(ServletHolder servletHolder) {
        this.setServlets((ServletHolder[])LazyList.addToArray(this.getServlets(), servletHolder, ServletHolder.class));
    }

    public void addServletMapping(ServletMapping servletMapping) {
        this.setServletMappings((ServletMapping[])LazyList.addToArray(this.getServletMappings(), servletMapping, ServletMapping.class));
    }

    public FilterHolder newFilterHolder(Class clazz) {
        return new FilterHolder(clazz);
    }

    public FilterHolder newFilterHolder() {
        return new FilterHolder();
    }

    public FilterHolder getFilter(String string) {
        return (FilterHolder)this._filterNameMap.get(string);
    }

    public FilterHolder addFilterWithMapping(Class clazz, String string, int n) {
        FilterHolder filterHolder = this.newFilterHolder(clazz);
        this.addFilterWithMapping(filterHolder, string, n);
        return filterHolder;
    }

    public FilterHolder addFilterWithMapping(String string, String string2, int n) {
        FilterHolder filterHolder = this.newFilterHolder(null);
        filterHolder.setName(string + "-" + filterHolder.hashCode());
        filterHolder.setClassName(string);
        this.addFilterWithMapping(filterHolder, string2, n);
        return filterHolder;
    }

    public void addFilterWithMapping(FilterHolder filterHolder, String string, int n) {
        Object[] objectArray = this.getFilters();
        if (objectArray != null) {
            objectArray = (FilterHolder[])objectArray.clone();
        }
        try {
            this.setFilters((FilterHolder[])LazyList.addToArray(objectArray, filterHolder, FilterHolder.class));
            FilterMapping filterMapping = new FilterMapping();
            filterMapping.setFilterName(filterHolder.getName());
            filterMapping.setPathSpec(string);
            filterMapping.setDispatches(n);
            this.setFilterMappings((FilterMapping[])LazyList.addToArray(this.getFilterMappings(), filterMapping, FilterMapping.class));
        }
        catch (RuntimeException runtimeException) {
            this.setFilters((FilterHolder[])objectArray);
            throw runtimeException;
        }
        catch (Error error) {
            this.setFilters((FilterHolder[])objectArray);
            throw error;
        }
    }

    public FilterHolder addFilter(String string, String string2, int n) {
        return this.addFilterWithMapping(string, string2, n);
    }

    public void addFilter(FilterHolder filterHolder, FilterMapping filterMapping) {
        if (filterHolder != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray(this.getFilters(), filterHolder, FilterHolder.class));
        }
        if (filterMapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray(this.getFilterMappings(), filterMapping, FilterMapping.class));
        }
    }

    public void addFilter(FilterHolder filterHolder) {
        if (filterHolder != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray(this.getFilters(), filterHolder, FilterHolder.class));
        }
    }

    public void addFilterMapping(FilterMapping filterMapping) {
        if (filterMapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray(this.getFilterMappings(), filterMapping, FilterMapping.class));
        }
    }

    protected synchronized void updateNameMappings() {
        int n;
        this._filterNameMap.clear();
        if (this._filters != null) {
            for (n = 0; n < this._filters.length; ++n) {
                this._filterNameMap.put(this._filters[n].getName(), this._filters[n]);
                this._filters[n].setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            for (n = 0; n < this._servlets.length; ++n) {
                this._servletNameMap.put(this._servlets[n].getName(), this._servlets[n]);
                this._servlets[n].setServletHandler(this);
            }
        }
    }

    protected synchronized void updateMappings() {
        String[] stringArray;
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList();
            this._filterNameMappings = new MultiMap();
            for (int i = 0; i < this._filterMappings.length; ++i) {
                FilterHolder filterHolder = (FilterHolder)this._filterNameMap.get(this._filterMappings[i].getFilterName());
                if (filterHolder == null) {
                    throw new IllegalStateException("No filter named " + this._filterMappings[i].getFilterName());
                }
                this._filterMappings[i].setFilterHolder(filterHolder);
                if (this._filterMappings[i].getPathSpecs() != null) {
                    this._filterPathMappings.add(this._filterMappings[i]);
                }
                if (this._filterMappings[i].getServletNames() == null) continue;
                stringArray = this._filterMappings[i].getServletNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray[j] == null) continue;
                    this._filterNameMappings.add(stringArray[j], this._filterMappings[i]);
                }
            }
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pathMap = new PathMap();
            for (int i = 0; i < this._servletMappings.length; ++i) {
                stringArray = (String[])this._servletNameMap.get(this._servletMappings[i].getServletName());
                if (stringArray == null) {
                    throw new IllegalStateException("No such servlet: " + this._servletMappings[i].getServletName());
                }
                if (this._servletMappings[i].getPathSpecs() == null) continue;
                String[] stringArray2 = this._servletMappings[i].getPathSpecs();
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (stringArray2[j] == null) continue;
                    pathMap.put(stringArray2[j], stringArray);
                }
            }
            this._servletPathMap = pathMap;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("filterNameMap=" + this._filterNameMap);
            Log.debug("pathFilters=" + this._filterPathMappings);
            Log.debug("servletFilterMap=" + this._filterNameMappings);
            Log.debug("servletPathMap=" + this._servletPathMap);
            Log.debug("servletNameMap=" + this._servletNameMap);
        }
        try {
            if (this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void notFound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug("Not Found " + httpServletRequest.getRequestURI());
        }
        httpServletResponse.sendError(404);
    }

    public void setFilterChainsCached(boolean bl) {
        this._filterChainsCached = bl;
    }

    public void setFilterMappings(FilterMapping[] filterMappingArray) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._filterMappings, filterMappingArray, "filterMapping", true);
        }
        this._filterMappings = filterMappingArray;
        this.updateMappings();
    }

    public synchronized void setFilters(FilterHolder[] filterHolderArray) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._filters, filterHolderArray, "filter", true);
        }
        this._filters = filterHolderArray;
        this.updateNameMappings();
    }

    public void setServletMappings(ServletMapping[] servletMappingArray) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._servletMappings, servletMappingArray, "servletMapping", true);
        }
        this._servletMappings = servletMappingArray;
        this.updateMappings();
    }

    public synchronized void setServlets(ServletHolder[] servletHolderArray) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._servlets, servletHolderArray, "servlet", true);
        }
        this._servlets = servletHolderArray;
        this.updateNameMappings();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int n) {
        this._maxFilterChainsCacheSize = n;
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        return servlet;
    }

    public Servlet customizeServletDestroy(Servlet servlet) throws Exception {
        return servlet;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        return filter;
    }

    public Filter customizeFilterDestroy(Filter filter) throws Exception {
        return filter;
    }

    private class Chain
    implements FilterChain {
        int _filter = 0;
        Object _chain;
        ServletHolder _servletHolder;

        Chain(Object object, ServletHolder servletHolder) {
            this._chain = object;
            this._servletHolder = servletHolder;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            if (Log.isDebugEnabled()) {
                Log.debug("doFilter " + this._filter);
            }
            if (this._filter < LazyList.size(this._chain)) {
                FilterHolder filterHolder = (FilterHolder)LazyList.get(this._chain, this._filter++);
                if (Log.isDebugEnabled()) {
                    Log.debug("call filter " + filterHolder);
                }
                Filter filter = filterHolder.getFilter();
                filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
                return;
            }
            if (this._servletHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("call servlet " + this._servletHolder);
                }
                this._servletHolder.handle(servletRequest, servletResponse);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < LazyList.size(this._chain); ++i) {
                stringBuffer.append(LazyList.get(this._chain, i).toString());
                stringBuffer.append("->");
            }
            stringBuffer.append(this._servletHolder);
            return stringBuffer.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(Object object, ServletHolder servletHolder) {
            if (LazyList.size(object) > 0) {
                this._filterHolder = (FilterHolder)LazyList.get(object, 0);
                object = LazyList.remove(object, 0);
                this._next = new CachedChain(object, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("call filter " + this._filterHolder);
                }
                Filter filter = this._filterHolder.getFilter();
                filter.doFilter(servletRequest, servletResponse, (FilterChain)this._next);
                return;
            }
            if (this._servletHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("call servlet " + this._servletHolder);
                }
                this._servletHolder.handle(servletRequest, servletResponse);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return this._filterHolder + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

