/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.log.Log;

public class ServletHolder
extends Holder
implements Comparable {
    private int _initOrder;
    private boolean _initOnStartup = false;
    private Map _roleMap;
    private String _forcedPath;
    private String _runAs;
    private UserRealm _realm;
    private transient Servlet _servlet;
    private transient Config _config;
    private transient long _unavailable;
    private transient UnavailableException _unavailableEx;

    public ServletHolder() {
    }

    public ServletHolder(Servlet servlet) {
        this.setServlet(servlet);
    }

    public ServletHolder(Class clazz) {
        super(clazz);
    }

    public UnavailableException getUnavailableException() {
        return this._unavailableEx;
    }

    public synchronized void setServlet(Servlet servlet) {
        if (servlet == null || servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException();
        }
        this._extInstance = true;
        this._servlet = servlet;
        this.setHeldClass(servlet.getClass());
        if (this.getName() == null) {
            this.setName(servlet.getClass().getName() + "-" + super.hashCode());
        }
    }

    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int n) {
        this._initOnStartup = true;
        this._initOrder = n;
    }

    public int compareTo(Object object) {
        if (object instanceof ServletHolder) {
            int n;
            ServletHolder servletHolder = (ServletHolder)object;
            if (servletHolder == this) {
                return 0;
            }
            if (servletHolder._initOrder < this._initOrder) {
                return 1;
            }
            if (servletHolder._initOrder > this._initOrder) {
                return -1;
            }
            int n2 = n = this._className != null && servletHolder._className != null ? this._className.compareTo(servletHolder._className) : 0;
            if (n == 0) {
                n = this._name.compareTo(servletHolder._name);
            }
            if (n == 0) {
                n = this.hashCode() > object.hashCode() ? 1 : -1;
            }
            return n;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._name == null ? System.identityHashCode(this) : this._name.hashCode();
    }

    public synchronized void setUserRoleLink(String string, String string2) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap();
        }
        this._roleMap.put(string, string2);
    }

    public String getUserRoleLink(String string) {
        if (this._roleMap == null) {
            return string;
        }
        String string2 = (String)this._roleMap.get(string);
        return string2 == null ? string : string2;
    }

    public Map getRoleMap() {
        return this._roleMap;
    }

    public void setRunAs(String string) {
        this._runAs = string;
    }

    public String getRunAs() {
        return this._runAs;
    }

    public String getForcedPath() {
        return this._forcedPath;
    }

    public void setForcedPath(String string) {
        this._forcedPath = string;
    }

    @Override
    public void doStart() throws Exception {
        this._unavailable = 0L;
        try {
            super.doStart();
            this.checkServletType();
        }
        catch (UnavailableException unavailableException) {
            this.makeUnavailable(unavailableException);
        }
        this._config = new Config();
        if (this._runAs != null) {
            this._realm = ((SecurityHandler)ContextHandler.getCurrentContext().getContextHandler().getChildHandlerByClass(SecurityHandler.class)).getUserRealm();
        }
        if (SingleThreadModel.class.isAssignableFrom(this._class)) {
            this._servlet = new SingleThreadedWrapper();
        }
        if (this._extInstance || this._initOnStartup) {
            try {
                this.initServlet();
            }
            catch (Exception exception) {
                if (this._servletHandler.isStartWithUnavailable()) {
                    Log.ignore(exception);
                }
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        Principal principal = null;
        try {
            if (this._runAs != null && this._realm != null) {
                principal = this._realm.pushRole(null, this._runAs);
            }
            if (this._servlet != null) {
                try {
                    this.destroyInstance(this._servlet);
                }
                catch (Exception exception) {
                    Log.warn(exception);
                }
            }
            if (!this._extInstance) {
                this._servlet = null;
            }
            this._config = null;
        }
        finally {
            super.doStop();
            if (this._runAs != null && this._realm != null && principal != null) {
                this._realm.popRole(principal);
            }
        }
    }

    @Override
    public void destroyInstance(Object object) throws Exception {
        if (object == null) {
            return;
        }
        Servlet servlet = (Servlet)object;
        servlet.destroy();
        this.getServletHandler().customizeServletDestroy(servlet);
    }

    public synchronized Servlet getServlet() throws ServletException {
        if (this._unavailable != 0L) {
            if (this._unavailable < 0L || this._unavailable > 0L && System.currentTimeMillis() < this._unavailable) {
                throw this._unavailableEx;
            }
            this._unavailable = 0L;
            this._unavailableEx = null;
        }
        if (this._servlet == null) {
            this.initServlet();
        }
        return this._servlet;
    }

    public Servlet getServletInstance() {
        return this._servlet;
    }

    public void checkServletType() throws UnavailableException {
        if (!Servlet.class.isAssignableFrom(this._class)) {
            throw new UnavailableException("Servlet " + this._class + " is not a javax.servlet.Servlet");
        }
    }

    public boolean isAvailable() {
        if (this.isStarted() && this._unavailable == 0L) {
            return true;
        }
        try {
            this.getServlet();
        }
        catch (Exception exception) {
            Log.ignore(exception);
        }
        return this.isStarted() && this._unavailable == 0L;
    }

    private void makeUnavailable(UnavailableException unavailableException) {
        if (this._unavailableEx == unavailableException && this._unavailable != 0L) {
            return;
        }
        this._servletHandler.getServletContext().log("unavailable", (Throwable)unavailableException);
        this._unavailableEx = unavailableException;
        this._unavailable = -1L;
        this._unavailable = unavailableException.isPermanent() ? -1L : (this._unavailableEx.getUnavailableSeconds() > 0 ? System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds()) : System.currentTimeMillis() + 5000L);
    }

    private void makeUnavailable(Throwable throwable) {
        if (throwable instanceof UnavailableException) {
            this.makeUnavailable((UnavailableException)throwable);
        } else {
            this._servletHandler.getServletContext().log("unavailable", throwable);
            this._unavailableEx = new UnavailableException(throwable.toString(), -1);
            this._unavailable = -1L;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initServlet() throws ServletException {
        Principal principal = null;
        try {
            if (this._servlet == null) {
                this._servlet = (Servlet)this.newInstance();
            }
            if (this._config == null) {
                this._config = new Config();
            }
            if (!(this._servlet instanceof SingleThreadedWrapper)) {
                this._servlet = this.getServletHandler().customizeServlet(this._servlet);
            }
            if (this._runAs != null && this._realm != null) {
                principal = this._realm.pushRole(null, this._runAs);
            }
            this._servlet.init((ServletConfig)this._config);
            if (this._runAs == null) return;
            if (this._realm == null) return;
            if (principal == null) return;
            this._realm.popRole(principal);
            return;
        }
        catch (UnavailableException unavailableException) {
            try {
                this.makeUnavailable(unavailableException);
                this._servlet = null;
                this._config = null;
                throw unavailableException;
                catch (ServletException servletException) {
                    this.makeUnavailable(servletException.getCause() == null ? servletException : servletException.getCause());
                    this._servlet = null;
                    this._config = null;
                    throw servletException;
                }
                catch (Exception exception) {
                    this.makeUnavailable(exception);
                    this._servlet = null;
                    this._config = null;
                    throw new ServletException((Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                if (this._runAs == null) throw throwable;
                if (this._realm == null) throw throwable;
                if (principal == null) throw throwable;
                this._realm.popRole(principal);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, UnavailableException, IOException {
        if (this._class == null) {
            throw new UnavailableException("Servlet Not Initialized");
        }
        Servlet servlet = this._servlet;
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            if (this._unavailable != 0L || !this._initOnStartup) {
                servlet = this.getServlet();
            }
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
        }
        boolean bl = true;
        Principal principal = null;
        Request request = null;
        try {
            if (this._forcedPath != null) {
                servletRequest.setAttribute("org.apache.catalina.jsp_file", (Object)this._forcedPath);
            }
            if (this._runAs != null && this._realm != null) {
                request = HttpConnection.getCurrentConnection().getRequest();
                principal = this._realm.pushRole(request.getUserPrincipal(), this._runAs);
                request.setUserPrincipal(principal);
            }
            servlet.service(servletRequest, servletResponse);
            bl = false;
            if (this._runAs != null && this._realm != null && principal != null && request != null) {
                principal = this._realm.popRole(principal);
                request.setUserPrincipal(principal);
            }
            if (!bl) return;
        }
        catch (UnavailableException unavailableException) {
            try {
                this.makeUnavailable(unavailableException);
                throw this._unavailableEx;
            }
            catch (Throwable throwable) {
                if (this._runAs != null && this._realm != null && principal != null && request != null) {
                    principal = this._realm.popRole(principal);
                    request.setUserPrincipal(principal);
                }
                if (!bl) throw throwable;
                servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
                throw throwable;
            }
        }
        servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
        return;
    }

    private class SingleThreadedWrapper
    implements Servlet {
        Stack _stack = new Stack();

        private SingleThreadedWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                while (this._stack.size() > 0) {
                    try {
                        ((Servlet)this._stack.pop()).destroy();
                    }
                    catch (Exception exception) {
                        Log.warn(exception);
                    }
                }
            }
        }

        public ServletConfig getServletConfig() {
            return ServletHolder.this._config;
        }

        public String getServletInfo() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(ServletConfig servletConfig) throws ServletException {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() == 0) {
                    try {
                        Servlet servlet = (Servlet)ServletHolder.this.newInstance();
                        servlet = ServletHolder.this.getServletHandler().customizeServlet(servlet);
                        servlet.init(servletConfig);
                        this._stack.push(servlet);
                    }
                    catch (ServletException servletException) {
                        throw servletException;
                    }
                    catch (Exception exception) {
                        throw new ServletException((Throwable)exception);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            Servlet servlet;
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() > 0) {
                    servlet = (Servlet)this._stack.pop();
                } else {
                    try {
                        servlet = (Servlet)ServletHolder.this.newInstance();
                        servlet = ServletHolder.this.getServletHandler().customizeServlet(servlet);
                        servlet.init((ServletConfig)ServletHolder.this._config);
                    }
                    catch (ServletException servletException) {
                        throw servletException;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        throw new ServletException((Throwable)exception);
                    }
                }
            }
            try {
                servlet.service(servletRequest, servletResponse);
            }
            finally {
                singleThreadedWrapper = this;
                synchronized (singleThreadedWrapper) {
                    this._stack.push(servlet);
                }
            }
        }
    }

    class Config
    implements ServletConfig {
        Config() {
        }

        public String getServletName() {
            return ServletHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ServletHolder.this._servletHandler.getServletContext();
        }

        public String getInitParameter(String string) {
            return ServletHolder.this.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return ServletHolder.this.getInitParameterNames();
        }
    }
}

