/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.log.Log;

public class SessionHandler
extends HandlerWrapper {
    private SessionManager _sessionManager;

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager sessionManager) {
        this.setSessionManager(sessionManager);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        SessionManager sessionManager2 = this._sessionManager;
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, sessionManager2, sessionManager, "sessionManager", true);
        }
        if (sessionManager != null) {
            sessionManager.setSessionHandler(this);
        }
        this._sessionManager = sessionManager;
        if (sessionManager2 != null) {
            sessionManager2.setSessionHandler(null);
        }
    }

    @Override
    public void setServer(Server server) {
        Server server2 = this.getServer();
        if (server2 != null && server2 != server) {
            server2.getContainer().update((Object)this, this._sessionManager, null, "sessionManager", true);
        }
        super.setServer(server);
        if (server != null && server != server2) {
            server.getContainer().update((Object)this, null, this._sessionManager, "sessionManager", true);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._sessionManager.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._sessionManager.stop();
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        this.setRequestedId(httpServletRequest, n);
        Request request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
        SessionManager sessionManager = null;
        HttpSession httpSession = null;
        try {
            sessionManager = request.getSessionManager();
            httpSession = request.getSession(false);
            if (sessionManager != this._sessionManager) {
                request.setSessionManager(this._sessionManager);
                request.setSession(null);
            }
            HttpSession httpSession2 = null;
            if (this._sessionManager != null) {
                httpSession2 = request.getSession(false);
                if (httpSession2 != null) {
                    Cookie cookie;
                    if (httpSession2 != httpSession && (cookie = this._sessionManager.access(httpSession2, httpServletRequest.isSecure())) != null) {
                        httpServletResponse.addCookie(cookie);
                    }
                } else {
                    httpSession2 = request.recoverNewSession(this._sessionManager);
                    if (httpSession2 != null) {
                        request.setSession(httpSession2);
                    }
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug("sessionManager=" + this._sessionManager);
                Log.debug("session=" + httpSession2);
            }
            this.getHandler().handle(string, httpServletRequest, httpServletResponse, n);
        }
        catch (RetryRequest retryRequest) {
            HttpSession httpSession3 = request.getSession(false);
            if (httpSession3 != null && httpSession3.isNew()) {
                request.saveNewSession(this._sessionManager, httpSession3);
            }
            throw retryRequest;
        }
        finally {
            HttpSession httpSession4 = httpServletRequest.getSession(false);
            if (sessionManager != this._sessionManager) {
                if (httpSession4 != null) {
                    this._sessionManager.complete(httpSession4);
                }
                request.setSessionManager(sessionManager);
                request.setSession(httpSession);
            }
        }
    }

    protected void setRequestedId(HttpServletRequest httpServletRequest, int n) {
        int n2;
        String string;
        int n3;
        Object object;
        Request request = httpServletRequest instanceof Request ? (Request)httpServletRequest : HttpConnection.getCurrentConnection().getRequest();
        String string2 = httpServletRequest.getRequestedSessionId();
        if (n != 1 || string2 != null) {
            return;
        }
        SessionManager sessionManager = this.getSessionManager();
        boolean bl = false;
        HttpSession httpSession = null;
        if (this._sessionManager.isUsingCookies() && (object = httpServletRequest.getCookies()) != null && ((Cookie[])object).length > 0) {
            for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                if (!sessionManager.getSessionCookie().equalsIgnoreCase(object[n3].getName())) continue;
                if (string2 != null && sessionManager.getHttpSession(string2) != null) break;
                string2 = object[n3].getValue();
                bl = true;
                if (Log.isDebugEnabled()) {
                    Log.debug("Got Session ID " + string2 + " from cookie");
                }
                if ((httpSession = sessionManager.getHttpSession(string2)) == null) continue;
                request.setSession(httpSession);
            }
        }
        if ((string2 == null || httpSession == null) && (n3 = ((String)(object = httpServletRequest.getRequestURI())).lastIndexOf(59)) >= 0 && (string = sessionManager.getSessionURL()) != null && (n2 = ((String)object).indexOf(string, n3 + 1)) > 0) {
            string2 = ((String)object).substring(n2 + string.length() + 1);
            bl = false;
            if (Log.isDebugEnabled()) {
                Log.debug("Got Session ID " + string2 + " from URL");
            }
        }
        request.setRequestedSessionId(string2);
        request.setRequestedSessionIdFromCookie(string2 != null && bl);
    }

    public void addEventListener(EventListener eventListener) {
        if (this._sessionManager != null) {
            this._sessionManager.addEventListener(eventListener);
        }
    }

    public void clearEventListeners() {
        if (this._sessionManager != null) {
            this._sessionManager.clearEventListeners();
        }
    }
}

